/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.logic.head_generator.model.parameters;

import fzmm.zailer.me.client.logic.head_generator.model.parameters.ColorParameter;
import fzmm.zailer.me.client.logic.head_generator.model.parameters.OffsetParameter;
import fzmm.zailer.me.client.logic.head_generator.model.parameters.ParameterList;
import fzmm.zailer.me.client.logic.head_generator.model.steps.IModelStep;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public interface INestedParameters {
    default public boolean hasRequestedParameters() {
        return this.getNestedColorParameters().hasRequestedParameters() || this.getNestedTextureParameters().hasRequestedParameters() || this.getNestedOffsetParameters().hasRequestedParameters();
    }

    default public <T> ParameterList<T> getNestedParameters(Supplier<ParameterList<T>> parametersSupplier, Function<INestedParameters, ParameterList<T>> nestedParametersGetter) {
        ParameterList<T> result = new ParameterList<T>();
        result.put(parametersSupplier.get());
        for (IModelStep step : this.getSteps()) {
            if (!(step instanceof INestedParameters)) continue;
            INestedParameters nestedParameters = (INestedParameters)((Object)step);
            ParameterList<T> stepParameters = nestedParametersGetter.apply(nestedParameters);
            result.put(stepParameters);
        }
        return result;
    }

    default public ParameterList<OffsetParameter> getNestedOffsetParameters() {
        return this.getNestedParameters(this::getOffsetParameters, INestedParameters::getNestedOffsetParameters);
    }

    default public ParameterList<BufferedImage> getNestedTextureParameters() {
        return this.getNestedParameters(this::getTextureParameters, INestedParameters::getNestedTextureParameters);
    }

    default public ParameterList<ColorParameter> getNestedColorParameters() {
        return this.getNestedParameters(this::getColorParameters, INestedParameters::getNestedColorParameters);
    }

    public ParameterList<OffsetParameter> getOffsetParameters();

    public ParameterList<BufferedImage> getTextureParameters();

    public ParameterList<ColorParameter> getColorParameters();

    public List<IModelStep> getSteps();
}

