/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.logic.head_generator.model;

import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.logic.head_generator.AbstractHeadEntry;
import fzmm.zailer.me.client.logic.head_generator.HeadResourcesLoader;
import fzmm.zailer.me.client.logic.head_generator.model.HeadModelEntry;
import fzmm.zailer.me.client.logic.head_generator.model.steps.IModelStep;
import fzmm.zailer.me.client.logic.head_generator.model.steps.ModelCopyStep;
import java.util.ArrayList;
import java.util.List;

public class InternalModels {
    public static HeadModelEntry OLD_FORMAT_TO_NEW_FORMAT;
    public static HeadModelEntry SLIM_TO_WIDE;
    public static HeadModelEntry WIDE_TO_SLIM;
    public static HeadModelEntry ROTATE_IN_X_AXIS;
    public static HeadModelEntry ROTATE_IN_Y_AXIS;
    public static HeadModelEntry ROTATE_IN_Z_AXIS;

    private static HeadModelEntry load(String key) {
        AbstractHeadEntry entry = HeadResourcesLoader.getByPath(InternalModels.getPath(key)).orElseGet(() -> {
            FzmmClient.LOGGER.error("[InternalModels] Error loading '{}' model", (Object)("fzmm_models/internal/" + key));
            return new HeadModelEntry();
        });
        if (!(entry instanceof HeadModelEntry)) {
            FzmmClient.LOGGER.error("[InternalModels] '{}' is not a HeadModelEntry", (Object)("fzmm_models/internal/" + key));
            return new HeadModelEntry();
        }
        HeadModelEntry modelEntry = (HeadModelEntry)entry;
        return modelEntry;
    }

    private static HeadModelEntry reverseCopyStep(HeadModelEntry originalEntry, String key) {
        List<IModelStep> originalSteps = originalEntry.getSteps();
        ArrayList<IModelStep> stepsCopy = new ArrayList<IModelStep>();
        for (int i = originalSteps.size() - 1; i >= 0; --i) {
            IModelStep step = originalSteps.get(i);
            if (step instanceof ModelCopyStep) {
                ModelCopyStep modelCopyStep = (ModelCopyStep)step;
                step = modelCopyStep.reverseCopy();
            }
            stepsCopy.add(step);
        }
        HeadModelEntry result = originalEntry.copy(InternalModels.getPath(key));
        result.setSteps(stepsCopy);
        return result;
    }

    private static String getPath(String key) {
        return "internal/" + key;
    }

    public static void reload() {
        OLD_FORMAT_TO_NEW_FORMAT = InternalModels.load("old_format_to_new_format");
        SLIM_TO_WIDE = InternalModels.load("slim_to_wide");
        WIDE_TO_SLIM = InternalModels.reverseCopyStep(SLIM_TO_WIDE, "wide_to_slim");
        ROTATE_IN_X_AXIS = InternalModels.load("rotate_in_x_axis");
        ROTATE_IN_Y_AXIS = InternalModels.load("rotate_in_y_axis");
        ROTATE_IN_Z_AXIS = InternalModels.load("rotate_in_z_axis");
    }
}

