/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.logic;

import fzmm.zailer.me.utils.FzmmUtils;
import io.wispforest.owo.ui.core.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

public record TextFormatLogic(String message, boolean obfuscated, boolean bold, boolean strikethrough, boolean underline, boolean italic) {
    private class_2583 getStyle() {
        class_2583 style = class_2583.field_24360.method_10978(Boolean.valueOf(this.italic));
        if (this.obfuscated) {
            style = style.method_36141(Boolean.valueOf(true));
        }
        if (this.bold) {
            style = style.method_10982(Boolean.valueOf(true));
        }
        if (this.strikethrough) {
            style = style.method_36140(Boolean.valueOf(true));
        }
        if (this.underline) {
            style = style.method_30938(Boolean.valueOf(true));
        }
        return style;
    }

    public class_5250 getGradient(List<Color> colors) {
        if (colors.isEmpty()) {
            return class_2561.method_43473();
        }
        int messageLength = FzmmUtils.splitMessage(this.message).size();
        int[][] colorComponents = this.getColorComponents(colors);
        int[][] gradientComponents = this.getGradientComponents(colorComponents, messageLength);
        int[] gradientColors = this.getGradientColors(gradientComponents);
        return this.applyColors(FzmmUtils.splitMessage(this.message), gradientColors);
    }

    public int[][] getGradientComponents(int[][] colorComponents, int messageLength) {
        ArrayList<int[]> gradient = new ArrayList<int[]>();
        int minStep = messageLength / (colorComponents.length - 1);
        int maxStep = minStep + 1;
        int numMaxSteps = messageLength % (colorComponents.length - 1);
        for (int i = 0; i < colorComponents.length - 1; ++i) {
            int[] startColor = colorComponents[i];
            int[] endColor = colorComponents[i + 1];
            int currentStep = i < numMaxSteps ? maxStep : minStep;
            for (int j = 0; j < currentStep; ++j) {
                int[] currentColor = new int[]{startColor[0] + (endColor[0] - startColor[0]) * j / currentStep, startColor[1] + (endColor[1] - startColor[1]) * j / currentStep, startColor[2] + (endColor[2] - startColor[2]) * j / currentStep};
                gradient.add(currentColor);
            }
        }
        return (int[][])gradient.toArray((T[])new int[gradient.size()][]);
    }

    private int[][] getColorComponents(List<Color> colors) {
        return (int[][])colors.stream().map(color -> {
            int colorInt = color.rgb();
            return new int[]{colorInt >> 16 & 0xFF, colorInt >> 8 & 0xFF, colorInt & 0xFF};
        }).toArray(x$0 -> new int[x$0][]);
    }

    private int[] getGradientColors(int[][] gradientComponents) {
        return Stream.of(gradientComponents).mapToInt(components -> components[0] << 16 | components[1] << 8 | components[2]).toArray();
    }

    private class_5250 applyColors(List<String> characters, int[] colors) {
        class_5250 text = class_2561.method_43473().method_10862(this.getStyle());
        for (int i = 0; i != characters.size(); ++i) {
            int color = 0;
            if (colors.length > i) {
                color = colors[i];
            }
            text.method_10852((class_2561)class_2561.method_43470((String)characters.get(i)).method_10862(class_2583.field_24360.method_36139(color)));
        }
        return text;
    }

    public class_2561 getRainbow(float hue, float saturation, float brightness, float hueStep) {
        List<String> characters = FzmmUtils.splitMessage(this.message);
        int messageLength = characters.size();
        int[] colors = new int[messageLength];
        for (int i = 0; i != messageLength; ++i) {
            float hue2 = (hue + hueStep * (float)i) % 1.0f;
            colors[i] = Color.ofHsv((float)hue2, (float)saturation, (float)brightness).rgb();
        }
        return this.applyColors(characters, colors);
    }

    public class_2561 getWithColor(int color) {
        return class_2561.method_43470((String)this.message).method_10862(this.getStyle().method_36139(color));
    }

    public class_2561 getInterleaved(List<Color> colors, int distance) {
        List<String> characters = FzmmUtils.splitMessage(this.message);
        ArrayList<String> messageSplit = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i != characters.size(); ++i) {
            stringBuilder.append(characters.get(i));
            if (i % distance != distance - 1) continue;
            messageSplit.add(stringBuilder.toString());
            stringBuilder = new StringBuilder();
        }
        if (!stringBuilder.isEmpty()) {
            messageSplit.add(stringBuilder.toString());
        }
        int messageLength = messageSplit.size();
        int[] finalColors = new int[messageLength];
        for (int i = 0; i != messageLength; ++i) {
            finalColors[i] = colors.get(i % colors.size()).rgb();
        }
        return this.applyColors(messageSplit, finalColors);
    }
}

