/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.utils.select_item;

import com.google.common.collect.ImmutableList;
import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.components.row.ButtonRow;
import fzmm.zailer.me.client.gui.components.row.TextBoxRow;
import fzmm.zailer.me.client.gui.utils.select_item.RequestedItem;
import fzmm.zailer.me.client.logic.FzmmHistory;
import fzmm.zailer.me.mixin.combined_inventory_getter.PlayerInventoryAccessor;
import fzmm.zailer.me.utils.FzmmUtils;
import fzmm.zailer.me.utils.ItemUtils;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.util.FocusHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2371;
import net.minecraft.class_342;
import net.minecraft.class_437;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_7706;
import org.jetbrains.annotations.Nullable;

public class SelectItemScreen
extends BaseFzmmScreen {
    private static final String REQUESTED_ITEMS_LIST_ID = "requested-items-list";
    private static final String INVENTORY_BUTTON_ID = "inventory-button";
    private static final String DEFAULT_BUTTON_ID = "default-button";
    private static final String HISTORY_BUTTON_ID = "history-button";
    private static final String ALL_BUTTON_ID = "all-button";
    private static final String ITEM_LAYOUT_ID = "item-layout";
    private static final String ITEM_SEARCH_ID = "item-search";
    private static final String EXECUTE_BUTTON_ID = "execute";
    private final HashMap<RequestedItem, ItemComponent> requestedItems = new HashMap();
    private final RequestedItem selectedRequestedItem;
    private final List<ItemComponent> itemComponentList = new ArrayList<ItemComponent>();
    private FlowLayout requestedItemsLayout;
    private FlowLayout itemLayout;
    private class_342 searchField;
    private List<ButtonComponent> sourceButtons;
    private ButtonComponent executeButton;
    private boolean executed = false;

    public SelectItemScreen(@Nullable class_437 parent, RequestedItem requestedItem) {
        this(parent, List.of(requestedItem));
    }

    public SelectItemScreen(@Nullable class_437 parent, List<RequestedItem> requestedItems) {
        super("utils/select_item", "selectItem", parent);
        for (RequestedItem requestedItem : requestedItems) {
            this.requestedItems.put(requestedItem, Components.item((class_1799)class_1799.field_8037));
        }
        this.selectedRequestedItem = requestedItems.get(0);
    }

    @Override
    protected void setup(FlowLayout rootComponent) {
        assert (this.field_22787 != null);
        assert (this.field_22787.field_1724 != null);
        this.requestedItemsLayout = (FlowLayout)rootComponent.childById(FlowLayout.class, REQUESTED_ITEMS_LIST_ID);
        SelectItemScreen.checkNull((Component)this.requestedItemsLayout, "flow-layout", REQUESTED_ITEMS_LIST_ID);
        this.itemLayout = (FlowLayout)rootComponent.childById(FlowLayout.class, ITEM_LAYOUT_ID);
        SelectItemScreen.checkNull((Component)this.itemLayout, "flow-layout", ITEM_LAYOUT_ID);
        this.searchField = TextBoxRow.setup(rootComponent, ITEM_SEARCH_ID, "", 255, str -> this.applyFilter());
        this.searchField.horizontalSizing(Sizing.fill((int)50));
        this.setupSourceButtons(rootComponent);
        this.addRequestedItemButtons();
        this.executeButton = ButtonRow.setup(rootComponent, ButtonRow.getButtonId(EXECUTE_BUTTON_ID), this.canExecute(), buttonComponent -> {
            this.execute(false);
            this.method_25419();
        });
    }

    @Override
    protected void initFocus(FocusHandler focusHandler) {
        focusHandler.focus((Component)this.searchField, Component.FocusSource.MOUSE_CLICK);
    }

    private void setupSourceButtons(FlowLayout rootComponent) {
        assert (this.field_22787 != null);
        assert (this.field_22787.field_1724 != null);
        ButtonComponent inventoryButton = (ButtonComponent)rootComponent.childById(ButtonComponent.class, INVENTORY_BUTTON_ID);
        SelectItemScreen.checkNull((Component)inventoryButton, "button", INVENTORY_BUTTON_ID);
        inventoryButton.onPress(buttonComponent -> {
            this.sourceButtonsClicked(INVENTORY_BUTTON_ID);
            class_1661 inventory = this.field_22787.field_1724.method_31548();
            List<class_2371<class_1799>> inventoryStacks = ((PlayerInventoryAccessor)inventory).getCombinedInventory();
            for (class_2371<class_1799> stackList : inventoryStacks) {
                this.addItemCallback((Collection<class_1799>)stackList, true);
            }
        });
        ButtonComponent defaultButton = (ButtonComponent)rootComponent.childById(ButtonComponent.class, DEFAULT_BUTTON_ID);
        SelectItemScreen.checkNull((Component)defaultButton, "button", DEFAULT_BUTTON_ID);
        defaultButton.onPress(buttonComponent -> {
            this.sourceButtonsClicked(DEFAULT_BUTTON_ID);
            this.addItemCallback(this.selectedRequestedItem.defaultItems(), false);
        });
        ButtonComponent historyButton = (ButtonComponent)rootComponent.childById(ButtonComponent.class, HISTORY_BUTTON_ID);
        SelectItemScreen.checkNull((Component)historyButton, "button", HISTORY_BUTTON_ID);
        historyButton.onPress(buttonComponent -> {
            this.sourceButtonsClicked(HISTORY_BUTTON_ID);
            this.addItemCallback(FzmmHistory.getAllItems(), true);
        });
        class_7706.method_47330((class_7699)this.field_22787.field_1724.field_3944.method_45735(), (boolean)true, (class_7225.class_7874)FzmmUtils.getRegistryManager());
        ButtonComponent allButton = (ButtonComponent)rootComponent.childById(ButtonComponent.class, ALL_BUTTON_ID);
        SelectItemScreen.checkNull((Component)allButton, "button", ALL_BUTTON_ID);
        allButton.onPress(buttonComponent -> {
            this.sourceButtonsClicked(ALL_BUTTON_ID);
            LinkedHashSet<class_1799> stackList = new LinkedHashSet<class_1799>();
            class_1661 inventory = this.field_22787.field_1724.method_31548();
            List<class_2371<class_1799>> inventoryStacks = ((PlayerInventoryAccessor)inventory).getCombinedInventory();
            for (class_2371<class_1799> list : inventoryStacks) {
                stackList.addAll((Collection<class_1799>)list);
            }
            for (class_1761 itemGroup : class_7706.method_47341()) {
                stackList.addAll(itemGroup.method_47313());
            }
            this.addItemCallback(stackList, false);
        });
        this.sourceButtons = ImmutableList.of((Object)inventoryButton, (Object)defaultButton, (Object)historyButton, (Object)allButton);
        inventoryButton.method_25306();
        if (this.itemComponentList.isEmpty()) {
            defaultButton.method_25306();
        }
    }

    private void addItemCallback(Collection<class_1799> stackList, boolean filter) {
        ArrayList<ItemComponent> itemComponents = new ArrayList<ItemComponent>();
        Predicate<class_1799> stackPredicate = this.selectedRequestedItem.predicate();
        for (class_1799 stack : stackList) {
            if (filter && !stackPredicate.test(stack) || stack.method_7960()) continue;
            itemComponents.add(this.getItemCallback(stack));
        }
        this.itemComponentList.addAll(itemComponents);
        this.applyFilter();
    }

    private ItemComponent getItemCallback(class_1799 stack) {
        assert (this.field_22787 != null);
        class_1799 processedStack = ItemUtils.process(stack);
        ItemComponent itemComponent = (ItemComponent)Components.item((class_1799)processedStack).tooltip((Collection)processedStack.method_7950(class_1792.class_9635.field_51353, (class_1657)this.field_22787.field_1724, (class_1836)(this.field_22787.field_1690.field_1827 ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070)));
        itemComponent.mouseDown().subscribe((mouseX, mouseY, button) -> {
            this.selectedRequestedItem.setStack(processedStack);
            this.requestedItems.get(this.selectedRequestedItem).stack(processedStack);
            this.executeButton.field_22763 = this.canExecute();
            return true;
        });
        return itemComponent;
    }

    private void sourceButtonsClicked(String id) {
        this.itemComponentList.clear();
        for (ButtonComponent sourceButton : this.sourceButtons) {
            sourceButton.field_22763 = !id.equals(sourceButton.id());
        }
    }

    private void addRequestedItemButtons() {
        List entries = this.requestedItems.keySet().stream().toList();
        ArrayList<Component> requestedItemsEntries = new ArrayList<Component>();
        for (int i = 0; i != entries.size(); ++i) {
            RequestedItem entry = (RequestedItem)entries.get(i);
            requestedItemsEntries.add(this.addRequestedItemButton(entry, entry.stack().orElse(class_1799.field_8037), i));
        }
        this.requestedItemsLayout.children(requestedItemsEntries);
    }

    private Component addRequestedItemButton(RequestedItem requestedItem, class_1799 stack, int index) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", String.valueOf(index));
        FlowLayout requestedItemLayout = (FlowLayout)this.getModel().expandTemplate(FlowLayout.class, "requested-item", parameters);
        this.requestedItems.put(requestedItem, this.getRequestedItemPreview(requestedItemLayout, stack, index));
        LabelComponent labelComponent = (LabelComponent)requestedItemLayout.childById(LabelComponent.class, index + "-requested-item-label");
        if (labelComponent != null) {
            labelComponent.text(requestedItem.title());
        }
        return requestedItemLayout;
    }

    private ItemComponent getRequestedItemPreview(FlowLayout layout, class_1799 stack, int index) {
        ItemComponent itemComponent = (ItemComponent)layout.childById(ItemComponent.class, index + "-requested-item-item");
        if (itemComponent != null) {
            assert (this.field_22787 != null);
            itemComponent.stack(stack);
            itemComponent.tooltip((Collection)stack.method_7950(class_1792.class_9635.field_51353, (class_1657)this.field_22787.field_1724, (class_1836)(this.field_22787.field_1690.field_1827 ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070)));
        }
        return itemComponent;
    }

    private void applyFilter() {
        if (this.searchField == null) {
            return;
        }
        this.itemLayout.clearChildren();
        ArrayList<ItemComponent> resultList = new ArrayList<ItemComponent>();
        String search = this.searchField.method_1882().toLowerCase();
        for (ItemComponent itemComponent : this.itemComponentList) {
            if (!itemComponent.stack().method_7964().getString().toLowerCase().contains(search)) continue;
            resultList.add(itemComponent);
        }
        this.itemLayout.children(resultList);
    }

    private boolean canExecute() {
        for (RequestedItem requestedItem : this.requestedItems.keySet()) {
            if (requestedItem.canExecute()) continue;
            return false;
        }
        return true;
    }

    private void execute(boolean replaceWithEmpty) {
        this.executed = true;
        for (RequestedItem requestedItem : this.requestedItems.keySet()) {
            if (!replaceWithEmpty && requestedItem.canExecute()) {
                requestedItem.execute();
                continue;
            }
            requestedItem.execute(class_1799.field_8037);
        }
    }

    @Override
    public void method_25432() {
        super.method_25432();
        if (!this.executed) {
            this.execute(true);
        }
    }
}

