/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.text_format.tabs;

import fzmm.zailer.me.client.gui.components.row.ColorRow;
import fzmm.zailer.me.client.gui.text_format.TextFormatScreen;
import fzmm.zailer.me.client.gui.text_format.tabs.ITextFormatTab;
import fzmm.zailer.me.client.gui.utils.memento.IMementoObject;
import fzmm.zailer.me.client.logic.TextFormatLogic;
import io.wispforest.owo.config.ui.component.ConfigTextBox;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_5819;

public class TextFormatSimpleTab
implements ITextFormatTab {
    private static final String COLOR_ID = "color";
    private ConfigTextBox color;
    private Consumer<Object> callback;

    @Override
    public String getId() {
        return "simple";
    }

    @Override
    public class_2561 getText(TextFormatLogic logic) {
        if (!this.color.isValid()) {
            return TextFormatScreen.EMPTY_COLOR_TEXT;
        }
        Color color = (Color)this.color.parsedValue();
        return logic.getWithColor(color.rgb());
    }

    @Override
    public void setupComponents(FlowLayout rootComponent) {
        this.color = ColorRow.setup(rootComponent, COLOR_ID, Color.ofRgb((int)Integer.parseInt("FFFFFF", 16)), false, 0, s -> this.callback.accept(""));
    }

    @Override
    public void setRandomValues() {
        Color color = Color.ofRgb((int)class_5819.method_43047().method_43048(0xFFFFFF));
        this.color.text(color.asHexString(false));
    }

    @Override
    public void componentsCallback(Consumer<Object> callback) {
        this.callback = callback;
    }

    @Override
    public boolean hasStyles() {
        return true;
    }

    @Override
    public IMementoObject createMemento() {
        return new SimpleMementoTab((Color)this.color.parsedValue());
    }

    @Override
    public void restoreMemento(IMementoObject mementoTab) {
        SimpleMementoTab simpleMementoTab = (SimpleMementoTab)mementoTab;
        this.color.text(simpleMementoTab.color.asHexString(false));
    }

    private record SimpleMementoTab(Color color) implements IMementoObject
    {
    }
}

