/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.imagetext.tabs;

import fzmm.zailer.me.builders.ArmorStandBuilder;
import fzmm.zailer.me.builders.ContainerBuilder;
import fzmm.zailer.me.builders.DisplayBuilder;
import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.components.row.NumberRow;
import fzmm.zailer.me.client.gui.imagetext.algorithms.IImagetextAlgorithm;
import fzmm.zailer.me.client.gui.imagetext.tabs.IImagetextTab;
import fzmm.zailer.me.client.gui.utils.InvisibleEntityWarning;
import fzmm.zailer.me.client.gui.utils.memento.IMementoObject;
import fzmm.zailer.me.client.logic.imagetext.ImagetextData;
import fzmm.zailer.me.client.logic.imagetext.ImagetextLogic;
import fzmm.zailer.me.utils.ItemUtils;
import io.wispforest.owo.config.ui.component.ConfigTextBox;
import io.wispforest.owo.ui.container.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class ImagetextHologramTab
implements IImagetextTab {
    private static final String POS_X_ID = "hologramPosX";
    private static final String POS_Y_ID = "hologramPosY";
    private static final String POS_Z_ID = "hologramPosZ";
    private static final String HOLOGRAM_TAG = "ImagetextHologram";
    private static final String BASE_ITEMS_TRANSLATION_KEY = "fzmm.item.imagetext.hologram.";
    private static final float Y_DISTANCE = 0.23f;
    private ConfigTextBox posX;
    private ConfigTextBox posY;
    private ConfigTextBox posZ;

    @Override
    public void generate(IImagetextAlgorithm algorithm, ImagetextLogic logic, ImagetextData data, boolean isExecute) {
        logic.generateImagetext(algorithm, data);
    }

    @Override
    public void execute(ImagetextLogic logic) {
        int x = (Integer)this.posX.parsedValue();
        int y = (Integer)this.posY.parsedValue();
        int z = (Integer)this.posZ.parsedValue();
        int color = FzmmClient.CONFIG.colors.imagetextHologram().rgb();
        List<class_1799> hologramContainers = ContainerBuilder.builder().containerItem(class_1802.field_8722).maxItemByContainer(27).addAll(this.getHologramItems(logic, x, y, z)).getAsList();
        class_1799 hologramMainContainer = ContainerBuilder.builder().containerItem(class_1802.field_8722).maxItemByContainer(27).addAll(hologramContainers).getAsList().get(0);
        hologramMainContainer = DisplayBuilder.of(hologramMainContainer).setName((class_2561)class_2561.method_43471((String)"fzmm.item.imagetext.hologram.name"), color).addLore((class_2561)class_2561.method_43469((String)"fzmm.item.imagetext.hologram.lore.1", (Object[])new Object[]{x, y, z}), color).addLore((class_2561)class_2561.method_43469((String)"fzmm.item.imagetext.hologram.lore.2", (Object[])new Object[]{logic.getWidth(), logic.getHeight()}), color).get();
        ItemUtils.give(hologramMainContainer);
        InvisibleEntityWarning.add(true, true, (class_2561)class_2561.method_43471((String)"fzmm.snack_bar.entityDifficultToRemove.entity.hologram"), HOLOGRAM_TAG);
    }

    public List<class_1799> getHologramItems(ImagetextLogic logic, int x, double y, int z) {
        ArrayList<class_1799> hologramItems = new ArrayList<class_1799>();
        List<class_2561> imagetext = logic.getWrappedText();
        int size = imagetext.size();
        for (int i = 0; i != size; ++i) {
            class_1799 armorStandHologram = ArmorStandBuilder.builder().setPos(x, y += (double)0.23f, z).setTags(HOLOGRAM_TAG).setAsHologram(imagetext.get(size - i - 1)).getItem(String.valueOf(i));
            hologramItems.add(armorStandHologram);
        }
        return hologramItems;
    }

    @Override
    public void setupComponents(FlowLayout rootComponent) {
        class_746 player = class_310.method_1551().field_1724;
        assert (player != null);
        this.posX = NumberRow.setup(rootComponent, POS_X_ID, player.method_31477(), Integer.class);
        this.posY = NumberRow.setup(rootComponent, POS_Y_ID, player.method_31478(), Integer.class);
        this.posZ = NumberRow.setup(rootComponent, POS_Z_ID, player.method_31479(), Integer.class);
    }

    @Override
    public String getId() {
        return "hologram";
    }

    public static boolean isHologramPart(class_1799 stack) {
        class_2487 entityNbt = ((class_9279)stack.method_57825(class_9334.field_49609, (Object)class_9279.method_57456((class_2487)new class_2487()))).method_57461();
        class_2499 tags = entityNbt.method_10554("Tags", 8);
        for (int i = 0; i < tags.size(); ++i) {
            if (!tags.method_10608(i).equals(HOLOGRAM_TAG)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IMementoObject createMemento() {
        return null;
    }

    @Override
    public void restoreMemento(IMementoObject mementoTab) {
    }
}

