/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.imagetext.algorithms;

import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.components.SuggestionTextBox;
import fzmm.zailer.me.client.gui.components.row.TextBoxRow;
import fzmm.zailer.me.client.gui.imagetext.algorithms.IImagetextAlgorithm;
import fzmm.zailer.me.client.gui.utils.memento.IMementoObject;
import fzmm.zailer.me.client.logic.imagetext.ImagetextData;
import fzmm.zailer.me.client.logic.imagetext.ImagetextLine;
import fzmm.zailer.me.client.logic.imagetext.ImagetextLogic;
import fzmm.zailer.me.utils.ImageUtils;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Sizing;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class ImagetextCharactersAlgorithm
implements IImagetextAlgorithm {
    private static final String CHARACTERS_ID = "characters";
    private SuggestionTextBox charactersTextField;
    private BufferedImage image = null;

    @Override
    public String getId() {
        return "algorithm.characters";
    }

    @Override
    public List<class_5250> get(ImagetextLogic logic, ImagetextData data, int lineSplitInterval) {
        this.cacheResizedImage(data);
        ArrayList<class_5250> linesList = new ArrayList<class_5250>();
        String characters = this.charactersTextField.method_1882();
        if (characters == null || characters.isBlank()) {
            characters = "\u2588";
        }
        for (int y = 0; y != data.height(); ++y) {
            ImagetextLine line = new ImagetextLine(characters, data.percentageOfSimilarityToCompress(), lineSplitInterval);
            for (int x = 0; x != data.width(); ++x) {
                line.add(this.image.getRGB(x, y));
            }
            linesList.addAll(line.getLineComponents());
        }
        return linesList;
    }

    @Override
    public String getCharacters() {
        return this.charactersTextField.method_1882();
    }

    @Override
    public float widthRatio() {
        return 1.0f;
    }

    @Override
    public float heightRatio() {
        return 1.0f;
    }

    @Override
    public void setUpdatePreviewCallback(Runnable callback) {
        this.charactersTextField.onChanged().subscribe(value -> callback.run());
    }

    @Override
    public void cacheResizedImage(ImagetextData data) {
        if (this.image == null || this.image.getWidth() != data.width() || this.image.getHeight() != data.height()) {
            this.clearCache();
            this.image = ImageUtils.fastResizeImage(data.image(), data.width(), data.height(), data.smoothRescaling());
        }
    }

    @Override
    public void clearCache() {
        if (this.image != null) {
            this.image.flush();
        }
        this.image = null;
    }

    @Override
    public void setupComponents(FlowLayout rootComponent) {
        this.charactersTextField = (SuggestionTextBox)TextBoxRow.setup(rootComponent, CHARACTERS_ID, "\u2588", FzmmClient.CONFIG.imagetext.maxResolution());
        this.charactersTextField.method_1870(false);
        this.charactersTextField.setSuggestionProvider((nul, builder) -> {
            if (builder.getInput().isBlank()) {
                builder.suggest("\u2588");
                List<String> suggestions = List.of("\u258e", "\u258b", "\u2610", "\ud83c\udf11");
                for (String suggestion : suggestions) {
                    builder.suggest(suggestion);
                }
            }
            return CompletableFuture.completedFuture(builder.build());
        });
        this.charactersTextField.enableFontProcess(true);
        FlowLayout parentLayout = (FlowLayout)rootComponent.childById(FlowLayout.class, TextBoxRow.getTextBoxId(CHARACTERS_ID) + "-parent");
        BaseFzmmScreen.checkNull((Component)parentLayout, "flow-layout", TextBoxRow.getTextBoxId(CHARACTERS_ID) + "-parent");
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof BaseFzmmScreen) {
            BaseFzmmScreen baseScreen = (BaseFzmmScreen)class_4372;
            parentLayout.removeChild((Component)this.charactersTextField);
            List<Component> buttons = baseScreen.getSymbolChatCompat().getButtons(baseScreen, (class_342)this.charactersTextField);
            for (Component button : buttons) {
                button.sizing(Sizing.fixed((int)16));
            }
            parentLayout.children(buttons);
            parentLayout.child((Component)this.charactersTextField);
        }
    }

    @Override
    public IMementoObject createMemento() {
        return new CharactersAlgorithmMementoTab(this.charactersTextField.method_1882());
    }

    @Override
    public void restoreMemento(IMementoObject mementoObject) {
        CharactersAlgorithmMementoTab memento = (CharactersAlgorithmMementoTab)mementoObject;
        this.charactersTextField.text(memento.characters);
    }

    private record CharactersAlgorithmMementoTab(String characters) implements IMementoObject
    {
    }
}

