/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.imagetext;

import fzmm.zailer.me.builders.DisplayBuilder;
import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.components.BooleanButton;
import fzmm.zailer.me.client.gui.components.ContextMenuButton;
import fzmm.zailer.me.client.gui.components.SliderWidget;
import fzmm.zailer.me.client.gui.components.image.ImageButtonComponent;
import fzmm.zailer.me.client.gui.components.image.ImageMode;
import fzmm.zailer.me.client.gui.components.row.ButtonRow;
import fzmm.zailer.me.client.gui.components.row.SliderRow;
import fzmm.zailer.me.client.gui.components.row.image.ImageRows;
import fzmm.zailer.me.client.gui.components.row.image.ImageRowsElements;
import fzmm.zailer.me.client.gui.components.style.StyledContainers;
import fzmm.zailer.me.client.gui.components.style.container.StyledFlowLayout;
import fzmm.zailer.me.client.gui.components.tabs.IScreenTab;
import fzmm.zailer.me.client.gui.components.tabs.ITabsEnum;
import fzmm.zailer.me.client.gui.imagetext.algorithms.IImagetextAlgorithm;
import fzmm.zailer.me.client.gui.imagetext.algorithms.ImagetextAlgorithms;
import fzmm.zailer.me.client.gui.imagetext.tabs.IImagetextTab;
import fzmm.zailer.me.client.gui.imagetext.tabs.IImagetextTooltip;
import fzmm.zailer.me.client.gui.imagetext.tabs.ImagetextMode;
import fzmm.zailer.me.client.gui.utils.memento.IMementoObject;
import fzmm.zailer.me.client.gui.utils.memento.IMementoScreen;
import fzmm.zailer.me.client.logic.imagetext.ImagetextData;
import fzmm.zailer.me.client.logic.imagetext.ImagetextLogic;
import fzmm.zailer.me.config.FzmmConfig;
import fzmm.zailer.me.utils.FzmmUtils;
import fzmm.zailer.me.utils.ItemUtils;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.SmallCheckboxComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Animatable;
import io.wispforest.owo.ui.core.Animation;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Easing;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.util.FocusHandler;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class ImagetextScreen
extends BaseFzmmScreen
implements IMementoScreen {
    private static final double DEFAULT_SIZE_VALUE = 32.0;
    public static final double MAX_PERCENTAGE_OF_SIMILARITY_TO_COMPRESS = 10.0;
    private static ImagetextMode selectedMode = ImagetextMode.LORE;
    private static ImagetextAlgorithms selectedAlgorithm = ImagetextAlgorithms.CHARACTERS;
    private static ImagetextMemento memento = null;
    private final ImagetextLogic imagetextLogic;
    private final HashMap<String, IScreenTab> algorithmsTabs;
    private ImageRowsElements imageElements;
    private BooleanButton preserveImageAspectRatioToggle;
    private SmallCheckboxComponent showResolutionCheckbox;
    private SmallCheckboxComponent smoothImageCheckbox;
    private SliderWidget widthSlider;
    private SliderWidget heightSlider;
    private SliderWidget percentageOfSimilarityToCompress;
    private LabelComponent previewLabel;
    private Animation.Composed smallGuiAnimation;
    private CompletableFuture<Void> scheduledUpdatePreview = CompletableFuture.completedFuture(null);

    public ImagetextScreen(@Nullable class_437 parent) {
        super("imagetext", "imagetext", parent);
        this.imagetextLogic = new ImagetextLogic();
        this.algorithmsTabs = new HashMap();
    }

    @Override
    protected void setup(FlowLayout rootComponent) {
        FzmmConfig.Imagetext config = FzmmClient.CONFIG.imagetext;
        ImageRows imageRows = new ImageRows(this.getBaseScreenTranslationKey(), "image", "imageSourceType", true);
        this.imageElements = ImageRows.setup(imageRows, "image", "imageSourceType", ImageMode.URL);
        FlowLayout imageTextBoxLayout = (FlowLayout)rootComponent.childById(FlowLayout.class, "image-textbox");
        BaseFzmmScreen.checkNull((Component)imageTextBoxLayout, "flow-layout", "image-textbox");
        imageTextBoxLayout.child(this.imageElements.valueField().sizing(Sizing.expand((int)100), Sizing.fixed((int)16)));
        FlowLayout imageButtonLayout = (FlowLayout)rootComponent.childById(FlowLayout.class, "image-buttons");
        BaseFzmmScreen.checkNull((Component)imageButtonLayout, "flow-layout", "image-buttons");
        ArrayList<StyledFlowLayout> imageButtonList = new ArrayList<StyledFlowLayout>();
        for (ImageMode imageMode : ImageMode.values()) {
            StyledFlowLayout buttonLayout = StyledContainers.horizontalFlow(Sizing.content(), Sizing.content());
            buttonLayout.tooltip((class_2561)class_2561.method_43471((String)(imageMode.getTranslationKey() + ".tooltip")));
            ButtonComponent button2 = this.imageElements.imageModeButtons().get((Object)imageMode);
            button2.sizing(Sizing.fixed((int)16));
            buttonLayout.child((Component)button2);
            imageButtonList.add(buttonLayout);
        }
        imageButtonList.add((StyledFlowLayout)Components.spacer().verticalSizing(Sizing.fixed((int)1)));
        imageButtonList.add((StyledFlowLayout)this.imageElements.imageButton().verticalSizing(Sizing.fixed((int)16)).margins(Insets.none()));
        ImageButtonComponent imageButton = this.imageElements.imageButton();
        this.preserveImageAspectRatioToggle = (BooleanButton)rootComponent.childById(BooleanButton.class, "preserveImageAspectRatio");
        BaseFzmmScreen.checkNull((Component)this.preserveImageAspectRatioToggle, "boolean-button", "preserveImageAspectRatio");
        this.preserveImageAspectRatioToggle.enabled(config.defaultPreserveImageAspectRatio());
        this.showResolutionCheckbox = (SmallCheckboxComponent)rootComponent.childById(SmallCheckboxComponent.class, "showResolution");
        BaseFzmmScreen.checkNull((Component)this.showResolutionCheckbox, "small-checkbox", "showResolution");
        this.showResolutionCheckbox.checked(false);
        this.smoothImageCheckbox = (SmallCheckboxComponent)rootComponent.childById(SmallCheckboxComponent.class, "smoothImage");
        BaseFzmmScreen.checkNull((Component)this.smoothImageCheckbox, "small-checkbox", "smoothImage");
        this.smoothImageCheckbox.checked(true);
        this.widthSlider = SliderRow.setup(rootComponent, "width", 32.0, 2.0, config.maxResolution(), Integer.class, 0, 3.0, aDouble -> this.onResolutionChanged(this.widthSlider, this.heightSlider, true));
        this.heightSlider = SliderRow.setup(rootComponent, "height", 32.0, 2.0, config.maxResolution(), Integer.class, 0, 3.0, aDouble -> this.onResolutionChanged(this.heightSlider, this.widthSlider, false));
        this.percentageOfSimilarityToCompress = SliderRow.setup(rootComponent, "percentageOfSimilarityToCompress", config.defaultPercentageOfSimilarityToCompress(), 0.0, 10.0, Double.class, 1, 0.1, null);
        this.percentageOfSimilarityToCompress.message(s -> class_2561.method_43470((String)(s + "%")));
        imageButtonLayout.children(imageButtonList);
        ContextMenuButton algorithmButton = (ContextMenuButton)rootComponent.childById(ContextMenuButton.class, "algorithm-button");
        BaseFzmmScreen.checkNull((Component)algorithmButton, "button", "algorithm-button");
        algorithmButton.setContextMenuOptions(contextMenu -> {
            for (ImagetextAlgorithms algorithm : ImagetextAlgorithms.values()) {
                contextMenu.button(algorithm.getText(this.getBaseScreenTranslationKey()), dropdown -> {
                    algorithmButton.removeContextMenu();
                    this.getTab(selectedAlgorithm, IImagetextAlgorithm.class, this.algorithmsTabs).clearCache();
                    selectedAlgorithm = algorithm;
                    algorithmButton.method_25355(this.getAlgorithmText());
                    this.selectTab(rootComponent, algorithm, this.algorithmsTabs);
                    this.scheduleUpdatePreview();
                    this.onResolutionChanged(this.widthSlider, this.heightSlider, true);
                });
            }
        });
        algorithmButton.method_25355(this.getAlgorithmText());
        this.setTabs(rootComponent, selectedAlgorithm, ImagetextAlgorithms.values(), this.algorithmsTabs);
        ContextMenuButton modeButton = (ContextMenuButton)rootComponent.childById(ContextMenuButton.class, "mode-button");
        BaseFzmmScreen.checkNull((Component)modeButton, "button", "mode-button");
        modeButton.setContextMenuOptions(contextMenu -> {
            for (ImagetextMode mode : ImagetextMode.values()) {
                contextMenu.button(mode.getText(this.getBaseScreenTranslationKey()), dropdown -> {
                    modeButton.removeContextMenu();
                    selectedMode = mode;
                    modeButton.method_25355(this.getModeText());
                    this.selectTab(rootComponent, mode, this.tabs);
                    this.scheduleUpdatePreview();
                });
            }
        });
        modeButton.method_25355(this.getModeText());
        this.setTabs(rootComponent, selectedMode, ImagetextMode.values(), this.tabs);
        this.previewLabel = (LabelComponent)rootComponent.childById(LabelComponent.class, "preview-label");
        BaseFzmmScreen.checkNull((Component)this.previewLabel, "label", "preview-label");
        this.widthSlider.onChanged().subscribe(value -> this.scheduleUpdatePreview());
        this.heightSlider.onChanged().subscribe(value -> this.scheduleUpdatePreview());
        this.percentageOfSimilarityToCompress.onChanged().subscribe(value -> this.scheduleUpdatePreview());
        this.showResolutionCheckbox.onChanged().subscribe(buttonComponent -> this.scheduleUpdatePreview());
        this.smoothImageCheckbox.onChanged().subscribe(buttonComponent -> {
            this.getTab(selectedAlgorithm, IImagetextAlgorithm.class, this.algorithmsTabs).clearCache();
            this.scheduleUpdatePreview();
        });
        for (ImagetextAlgorithms imagetextTab : ImagetextAlgorithms.values()) {
            IImagetextAlgorithm tab = this.getTab(imagetextTab, IImagetextAlgorithm.class, this.algorithmsTabs);
            tab.setUpdatePreviewCallback(this::scheduleUpdatePreview);
        }
        ButtonComponent buttonComponent2 = ButtonRow.setup(rootComponent, ButtonRow.getButtonId("execute"), false, button -> this.execute());
        imageButton.setButtonCallback(image -> {
            boolean hasImage;
            executeButton.field_22763 = hasImage = image != null;
            if (hasImage) {
                this.getTab(selectedAlgorithm, IImagetextAlgorithm.class, this.algorithmsTabs).clearCache();
                this.scheduleUpdatePreview();
                this.updateAspectRatio((BufferedImage)image);
            }
        });
        FlowLayout imageOptionsLayout = (FlowLayout)rootComponent.childById(FlowLayout.class, "image-options-layout");
        BaseFzmmScreen.checkNull((Component)imageOptionsLayout, "flow-layout", "image-options-layout");
        FlowLayout algorithmOptionsLayout = (FlowLayout)rootComponent.childById(FlowLayout.class, "algorithm-options-layout");
        BaseFzmmScreen.checkNull((Component)algorithmOptionsLayout, "flow-layout", "algorithm-options-layout");
        FlowLayout imageModeLayout = (FlowLayout)rootComponent.childById(FlowLayout.class, "image-mode-layout");
        BaseFzmmScreen.checkNull((Component)imageModeLayout, "flow-layout", "image-mode-layout");
        Animation imageLayoutAnimation = imageOptionsLayout.horizontalSizing().animate(100, Easing.LINEAR, (Animatable)Sizing.expand((int)100));
        Animation algorithmLayoutAnimationHorizontal = algorithmOptionsLayout.horizontalSizing().animate(100, Easing.LINEAR, (Animatable)Sizing.expand((int)100));
        Animation algorithmLayoutAnimationVertical = algorithmOptionsLayout.verticalSizing().animate(100, Easing.LINEAR, (Animatable)Sizing.content());
        Animation imageModeFixAnimation = imageModeLayout.horizontalSizing().animate(100, Easing.LINEAR, (Animatable)Sizing.expand((int)100));
        this.smallGuiAnimation = Animation.compose((Animation[])new Animation[]{imageLayoutAnimation, algorithmLayoutAnimationHorizontal, algorithmLayoutAnimationVertical, imageModeFixAnimation});
        ScrollContainer leftOptionsScroll = (ScrollContainer)rootComponent.childById(ScrollContainer.class, "left-options-scroll");
        BaseFzmmScreen.checkNull((Component)leftOptionsScroll, "scroll", "left-options-scroll");
        ButtonComponent expandPreviewButton = (ButtonComponent)rootComponent.childById(ButtonComponent.class, "expand-preview-button");
        BaseFzmmScreen.checkNull((Component)expandPreviewButton, "button", "expand-preview-button");
        Animation leftOptionsAnimation = leftOptionsScroll.horizontalSizing().animate(100, Easing.CUBIC, (Animatable)Sizing.expand((int)0));
        AtomicBoolean isExpanded = new AtomicBoolean(false);
        expandPreviewButton.onPress(buttonComponent -> {
            if (isExpanded.getAndSet(!isExpanded.get())) {
                leftOptionsAnimation.reverse();
                expandPreviewButton.method_25355((class_2561)class_2561.method_43471((String)"fzmm.gui.button.arrow2.left"));
            } else {
                leftOptionsAnimation.forwards();
                expandPreviewButton.method_25355((class_2561)class_2561.method_43471((String)"fzmm.gui.button.arrow2.right"));
            }
        });
        this.setSmallGuiAnimation(this.field_22789);
    }

    @Override
    protected void initFocus(FocusHandler focusHandler) {
        focusHandler.focus((Component)this.imageElements.valueField(), Component.FocusSource.MOUSE_CLICK);
    }

    private void setTabs(FlowLayout rootComponent, ITabsEnum selectedTab, ITabsEnum[] enumValues, HashMap<String, IScreenTab> tabsHashMap) {
        Enum selectedTabEnum = (Enum)((Object)selectedTab);
        this.setTabs(tabsHashMap, selectedTabEnum);
        for (ITabsEnum imagetextTab : enumValues) {
            IImagetextTab tab = this.getTab(imagetextTab, IImagetextTab.class, tabsHashMap);
            tab.setupComponents(rootComponent);
        }
        this.selectTab(rootComponent, selectedTab, tabsHashMap);
    }

    private void selectTab(FlowLayout rootComponent, ITabsEnum selectedTab, HashMap<String, IScreenTab> tabsHashMap) {
        Enum selectedTabEnum = (Enum)((Object)selectedTab);
        this.selectScreenTab(rootComponent, selectedTab, selectedTabEnum, tabsHashMap, false);
    }

    public void method_25410(class_310 client, int width, int height) {
        super.method_25410(client, width, height);
        this.setSmallGuiAnimation(width);
    }

    private boolean isSmallGuiDesign(int width) {
        return (float)width * 0.3f < 200.0f;
    }

    private void setSmallGuiAnimation(int width) {
        if (this.isSmallGuiDesign(width)) {
            this.smallGuiAnimation.forwards();
        } else {
            this.smallGuiAnimation.backwards();
        }
    }

    private class_2561 getAlgorithmText() {
        return class_2561.method_43469((String)"fzmm.gui.imagetext.tab.algorithm", (Object[])new Object[]{selectedAlgorithm.getText(this.getBaseScreenTranslationKey())});
    }

    private class_2561 getModeText() {
        return class_2561.method_43469((String)"fzmm.gui.imagetext.tab.mode", (Object[])new Object[]{selectedMode.getText(this.getBaseScreenTranslationKey())});
    }

    private void onResolutionChanged(SliderWidget config, SliderWidget configToChange, boolean isWidth) {
        float algorithmAspectRatio;
        int valueToChange;
        int value;
        if (!this.imageElements.imageButton().hasImage() || !this.preserveImageAspectRatioToggle.enabled()) {
            return;
        }
        Optional<BufferedImage> imageOptional = this.imageElements.imageButton().getImage();
        if (imageOptional.isEmpty()) {
            return;
        }
        BufferedImage image = imageOptional.get();
        int width = image.getWidth();
        int height = image.getHeight();
        IImagetextAlgorithm algorithm = (IImagetextAlgorithm)this.algorithmsTabs.get(selectedAlgorithm.getId());
        if (isWidth) {
            value = width;
            valueToChange = height;
            algorithmAspectRatio = algorithm.widthRatio();
        } else {
            value = height;
            valueToChange = width;
            algorithmAspectRatio = algorithm.heightRatio();
        }
        this.preserveAspectRatio(config, configToChange, value, valueToChange, algorithmAspectRatio);
    }

    private void preserveAspectRatio(SliderWidget config, SliderWidget configToChange, int value, int valueToChange, float algorithmAspectRatio) {
        valueToChange = (int)((float)valueToChange * algorithmAspectRatio);
        int configValue = (Integer)config.parsedValue();
        int newValue = ImagetextLogic.getResizedAspectRatio(value, valueToChange, configValue);
        newValue = (int)Math.clamp((double)newValue, configToChange.min(), configToChange.max());
        configToChange.setDiscreteValueWithoutCallback(newValue);
    }

    public void execute() {
        CompletableFuture.runAsync(() -> {
            Optional<BufferedImage> image = this.imageElements.imageButton().getImage();
            if (image.isEmpty()) {
                return;
            }
            this.generateImagetext(image.get(), true);
            this.getTab(selectedMode, IImagetextTab.class).execute(this.imagetextLogic);
        });
    }

    public void scheduleUpdatePreview() {
        if (this.scheduledUpdatePreview != null && !this.scheduledUpdatePreview.isDone()) {
            this.scheduledUpdatePreview.cancel(true);
            this.scheduledUpdatePreview = null;
        }
        int delay = FzmmClient.CONFIG.imagetext.previewUpdateDelayInMillis();
        this.scheduledUpdatePreview = CompletableFuture.runAsync(() -> this.updatePreview(false), CompletableFuture.delayedExecutor(delay, TimeUnit.MILLISECONDS));
    }

    public void updatePreview(boolean isExecute) {
        Optional<BufferedImage> image = this.imageElements.imageButton().getImage();
        if (image.isEmpty()) {
            return;
        }
        this.generateImagetext(image.get(), isExecute);
        class_2561 text = this.imagetextLogic.getText();
        List<class_2561> wrappedText = this.imagetextLogic.getWrappedText();
        class_1799 placeholderStack = DisplayBuilder.builder().addLore(wrappedText).get();
        String nbtSize = ItemUtils.getLengthInKB(ItemUtils.getLengthInBytes(placeholderStack));
        String textSize = ItemUtils.getLengthInKB(class_2561.class_2562.method_10867((class_2561)text, (class_7225.class_7874)FzmmUtils.getRegistryManager()).length());
        class_5250 tooltipText = class_2561.method_43473().method_10862(class_2583.field_24360.method_10977(class_124.field_1080));
        tooltipText.method_10852((class_2561)class_2561.method_43469((String)"fzmm.gui.imagetext.label.imagetextSize", (Object[])new Object[]{nbtSize, textSize}));
        IImagetextTab iImagetextTab = this.getTab(selectedMode, IImagetextTab.class);
        if (iImagetextTab instanceof IImagetextTooltip) {
            IImagetextTooltip metadata = (IImagetextTooltip)((Object)iImagetextTab);
            tooltipText.method_27693("\n");
            tooltipText.method_10852(metadata.getTooltip(this.imagetextLogic));
        }
        assert (this.field_22787 != null);
        this.field_22787.execute(() -> {
            this.previewLabel.text(text);
            this.previewLabel.tooltip((class_2561)tooltipText);
        });
    }

    private void generateImagetext(BufferedImage image, boolean isExecute) {
        int width = (Integer)this.widthSlider.parsedValue();
        int height = (Integer)this.heightSlider.parsedValue();
        boolean smoothScaling = this.smoothImageCheckbox.checked();
        boolean showResolution = this.showResolutionCheckbox.checked();
        double percentageOfSimilarityToCompress = (Double)this.percentageOfSimilarityToCompress.parsedValue();
        IImagetextAlgorithm algorithm = (IImagetextAlgorithm)this.algorithmsTabs.get(selectedAlgorithm.getId());
        ImagetextData data = new ImagetextData(image, width, height, smoothScaling, percentageOfSimilarityToCompress);
        this.getTab(selectedMode, IImagetextTab.class).generate(algorithm, this.imagetextLogic, data, isExecute);
        if (showResolution) {
            this.imagetextLogic.addResolution();
        }
    }

    private void updateAspectRatio(BufferedImage image) {
        if (!this.preserveImageAspectRatioToggle.enabled()) {
            return;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        if (height > width) {
            this.onResolutionChanged(this.heightSlider, this.widthSlider, false);
        } else {
            this.onResolutionChanged(this.widthSlider, this.heightSlider, true);
        }
    }

    @Override
    public void setMemento(IMementoObject memento) {
        ImagetextScreen.memento = (ImagetextMemento)memento;
    }

    @Override
    public Optional<IMementoObject> getMemento() {
        return Optional.ofNullable(memento);
    }

    @Override
    public IMementoObject createMemento() {
        return new ImagetextMemento(this.imageElements.valueField().method_1882(), this.imageElements.mode().get(), (Integer)this.widthSlider.parsedValue(), (Integer)this.heightSlider.parsedValue(), this.smoothImageCheckbox.checked(), this.showResolutionCheckbox.checked(), this.preserveImageAspectRatioToggle.enabled(), (Double)this.percentageOfSimilarityToCompress.parsedValue(), this.createMementoTabs(this.tabs), this.createMementoTabs(this.algorithmsTabs));
    }

    @Override
    public void restoreMemento(IMementoObject mementoObject) {
        ImagetextMemento memento = (ImagetextMemento)mementoObject;
        this.imageElements.valueField().text(memento.imageRowValue);
        this.imageElements.imageModeButtons().get((Object)memento.imageMode).method_25306();
        this.widthSlider.setFromDiscreteValue(memento.width);
        this.heightSlider.setFromDiscreteValue(memento.height);
        this.smoothImageCheckbox.checked(memento.smoothScaling);
        this.showResolutionCheckbox.checked(memento.showResolution);
        this.preserveImageAspectRatioToggle.enabled(memento.preserveImageAspectRatio);
        this.percentageOfSimilarityToCompress.setFromDiscreteValue(memento.percentageOfSimilarityToCompress);
        this.restoreMementoTabs(memento.mementoTabHashMap, this.tabs);
        this.restoreMementoTabs(memento.mementoAlgorithmTabHashMap, this.algorithmsTabs);
    }

    private record ImagetextMemento(String imageRowValue, ImageMode imageMode, int width, int height, boolean smoothScaling, boolean showResolution, boolean preserveImageAspectRatio, double percentageOfSimilarityToCompress, HashMap<String, IMementoObject> mementoTabHashMap, HashMap<String, IMementoObject> mementoAlgorithmTabHashMap) implements IMementoObject
    {
    }
}

