/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.head_gallery;

import fzmm.zailer.me.builders.DisplayBuilder;
import fzmm.zailer.me.builders.HeadBuilder;
import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.entity.custom_skin.CustomHeadEntity;
import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.components.GiveItemComponent;
import fzmm.zailer.me.client.gui.components.row.ButtonRow;
import fzmm.zailer.me.client.gui.components.row.TextBoxRow;
import fzmm.zailer.me.client.gui.components.style.FzmmStyles;
import fzmm.zailer.me.client.gui.components.style.container.StyledFlowLayout;
import fzmm.zailer.me.client.gui.utils.memento.IMementoObject;
import fzmm.zailer.me.client.gui.utils.memento.IMementoScreen;
import fzmm.zailer.me.client.logic.head_gallery.HeadGalleryResources;
import fzmm.zailer.me.client.logic.head_gallery.MinecraftHeadsData;
import fzmm.zailer.me.config.FzmmConfig;
import fzmm.zailer.me.utils.HeadUtils;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.EntityComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.OverlayContainer;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.util.FocusHandler;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_407;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_8685;
import org.jetbrains.annotations.Nullable;

public class HeadGalleryScreen
extends BaseFzmmScreen
implements IMementoScreen {
    private static final int SELECTED_TAG_COLOR = 4439218;
    private static final String TAG_BUTTON_TEXT = "fzmm.gui.headGallery.button.tags";
    private static final String TAG_LABEL_TEXT = "fzmm.gui.headGallery.label.tags-overlay";
    private static final String CATEGORY_LAYOUT_ID = "minecraft-heads-category-list";
    private static final String TAGS_LAYOUT_ID = "tags-layout";
    private static final String TAGS_LIST_LTR_ID = "minecraft-heads-tags-ltr";
    private static final String TAGS_OVERLAY_LABEL_ID = "tags-overlay-label";
    private static final String TAG_SEARCH_ID = "tag-search";
    private static final String CLEAR_SELECTED_TAGS_ID = "clear-selected-tags";
    private static final String CONTENT_SCROLL = "content-scroll";
    private static final String CONTENT_ID = "content";
    private static final String PAGE_PREVIOUS_BUTTON_ID = "previous-page-button";
    private static final String CURRENT_PAGE_LABEL_ID = "current-page-label";
    private static final String NEXT_PAGE_BUTTON_ID = "next-page-button";
    private static final String CONTENT_SEARCH_ID = "content-search";
    private static final String MINECRAFT_HEADS_BUTTON_ID = "minecraft-heads";
    private static final String ERROR_MESSAGE_ID = "error-message";
    private static HeadGalleryMemento memento = null;
    private int page;
    private FlowLayout contentLayout;
    private LabelComponent currentPageLabel;
    private final ObjectArrayList<MinecraftHeadsData> categoryHeads = new ObjectArrayList();
    private final ObjectArrayList<MinecraftHeadsData> categoryHeadsWithFilter = new ObjectArrayList();
    private TextBoxComponent contentSearchField;
    private ButtonComponent tagButton;
    private List<Component> categoryButtonList;
    private Set<String> selectedTags;
    private Set<String> availableTags;
    @Nullable
    private OverlayContainer<?> tagOverlay;
    private LabelComponent errorLabel;
    private String selectedCategory;
    private ScrollContainer<?> contentScroll;
    private CustomHeadEntity frontEntityPreview;
    private CustomHeadEntity backEntityPreview;

    public HeadGalleryScreen(@Nullable class_437 parent) {
        super("head_gallery", "headGallery", parent);
    }

    @Override
    protected void setup(FlowLayout rootComponent) {
        this.page = 1;
        this.selectedTags = new HashSet<String>();
        this.availableTags = new HashSet<String>();
        this.tagOverlay = null;
        assert (this.field_22787 != null);
        StyledFlowLayout categoryList = (StyledFlowLayout)rootComponent.childById(StyledFlowLayout.class, CATEGORY_LAYOUT_ID);
        HeadGalleryScreen.checkNull((Component)categoryList, "flow-layout", CATEGORY_LAYOUT_ID);
        this.categoryButtonList = HeadGalleryResources.CATEGORY_LIST.stream().map(category -> Components.button((class_2561)class_2561.method_43471((String)("fzmm.gui.headGallery.button.category." + category)), buttonComponent -> this.categoryButtonExecute((ButtonComponent)buttonComponent, (String)category, null)).renderer(FzmmStyles.DEFAULT_FLAT_BUTTON).sizing(Sizing.fill((int)100), Sizing.fixed((int)16)).id(category)).collect(Collectors.toList());
        categoryList.children(this.categoryButtonList).surface(categoryList.styledPanel()).padding(Insets.of((int)4));
        FlowLayout tagsLayout = (FlowLayout)rootComponent.childById(FlowLayout.class, TAGS_LAYOUT_ID);
        HeadGalleryScreen.checkNull((Component)tagsLayout, "flow-layout", TAGS_LAYOUT_ID);
        this.tagButton = Components.button((class_2561)this.getTagButtonText(), buttonComponent -> this.openTagsExecute());
        this.tagButton.horizontalSizing(Sizing.fill((int)100));
        tagsLayout.child((Component)this.tagButton);
        this.contentLayout = (FlowLayout)rootComponent.childById(FlowLayout.class, CONTENT_ID);
        HeadGalleryScreen.checkNull((Component)this.contentLayout, "flow-layout", CONTENT_ID);
        this.contentScroll = (ScrollContainer)rootComponent.childById(ScrollContainer.class, CONTENT_SCROLL);
        HeadGalleryScreen.checkNull(this.contentScroll, "flow-layout", CONTENT_SCROLL);
        ButtonComponent previousPageButton = (ButtonComponent)rootComponent.childById(ButtonComponent.class, PAGE_PREVIOUS_BUTTON_ID);
        HeadGalleryScreen.checkNull((Component)previousPageButton, "button", PAGE_PREVIOUS_BUTTON_ID);
        this.currentPageLabel = (LabelComponent)rootComponent.childById(LabelComponent.class, CURRENT_PAGE_LABEL_ID);
        HeadGalleryScreen.checkNull((Component)this.currentPageLabel, "label", CURRENT_PAGE_LABEL_ID);
        ButtonComponent nextPageButton = (ButtonComponent)rootComponent.childById(ButtonComponent.class, NEXT_PAGE_BUTTON_ID);
        HeadGalleryScreen.checkNull((Component)nextPageButton, "button", NEXT_PAGE_BUTTON_ID);
        previousPageButton.onPress(buttonComponent -> this.setPage(this.page - 1));
        nextPageButton.onPress(buttonComponent -> this.setPage(this.page + 1));
        this.contentSearchField = (TextBoxComponent)rootComponent.childById(TextBoxComponent.class, CONTENT_SEARCH_ID);
        HeadGalleryScreen.checkNull((Component)this.contentSearchField, "text-box", CONTENT_SEARCH_ID);
        this.contentSearchField.onChanged().subscribe(s -> {
            this.applyFilters();
            this.setPage(this.page);
        });
        ButtonRow.setup(rootComponent, ButtonRow.getButtonId(MINECRAFT_HEADS_BUTTON_ID), true, buttonComponent -> this.minecraftHeadsExecute());
        this.errorLabel = (LabelComponent)rootComponent.childById(LabelComponent.class, ERROR_MESSAGE_ID);
        HeadGalleryScreen.checkNull((Component)this.errorLabel, "label", ERROR_MESSAGE_ID);
        FlowLayout previewLayout = (FlowLayout)rootComponent.childById(FlowLayout.class, "preview-layout");
        HeadGalleryScreen.checkNull((Component)previewLayout, "flow-layout", "preview-layout");
        this.frontEntityPreview = new CustomHeadEntity((class_1937)this.field_22787.field_1687);
        this.backEntityPreview = new CustomHeadEntity((class_1937)this.field_22787.field_1687);
        EntityComponent backEntityPreview = Components.entity((Sizing)Sizing.fixed((int)48), (class_1297)this.backEntityPreview).allowMouseRotation(true);
        backEntityPreview.onMouseDrag(0.0, 0.0, 160.0, 0.0, 0);
        backEntityPreview.allowMouseRotation(false);
        previewLayout.child((Component)Components.entity((Sizing)Sizing.fixed((int)48), (class_1297)this.frontEntityPreview));
        previewLayout.child((Component)backEntityPreview);
        this.updatePreview(class_1802.field_8575.method_7854());
        this.applyFilters();
        this.setPage(1);
    }

    @Override
    protected void initFocus(FocusHandler focusHandler) {
        focusHandler.focus((Component)this.contentSearchField, Component.FocusSource.MOUSE_CLICK);
    }

    private void categoryButtonExecute(ButtonComponent selectedButton, String category, @Nullable Runnable callback) {
        assert (this.field_22787 != null);
        for (Component component : this.categoryButtonList) {
            if (!(component instanceof class_4185)) continue;
            class_4185 button = (class_4185)component;
            button.field_22763 = false;
        }
        this.tagButton.field_22763 = false;
        ((CompletableFuture)HeadGalleryResources.getCategory(category).thenAccept(categoryData -> this.field_22787.execute(() -> {
            this.selectedCategory = category;
            this.categoryHeads.clear();
            this.categoryHeads.addAll((ObjectList)categoryData);
            for (Component component : this.categoryButtonList) {
                if (!(component instanceof class_4185)) continue;
                class_4185 button = (class_4185)component;
                button.field_22763 = true;
            }
            selectedButton.field_22763 = false;
            this.tagButton.field_22763 = true;
            this.updateAvailableTagList((ObjectArrayList<MinecraftHeadsData>)categoryData);
            if (callback == null) {
                this.applyFilters();
                this.setPage(1);
            } else {
                callback.run();
            }
        }))).whenComplete((unused, throwable) -> this.field_22787.execute(() -> {
            if (throwable == null) {
                this.errorLabel.text((class_2561)class_2561.method_43473());
                return;
            }
            this.categoryHeads.clear();
            this.applyFilters();
            this.setPage(1);
            this.errorLabel.text((class_2561)class_2561.method_43469((String)"fzmm.gui.headGallery.label.error", (Object[])new Object[]{category, throwable.getMessage()}).method_10862(class_2583.field_24360.method_36139(FzmmStyles.TEXT_ERROR_COLOR.rgb())));
            FzmmClient.LOGGER.error("[HeadGalleryScreen] Error while fetching category '{}'", (Object)category, throwable);
            for (Component component : this.categoryButtonList) {
                if (!(component instanceof class_4185)) continue;
                class_4185 button = (class_4185)component;
                button.field_22763 = true;
            }
        }));
    }

    private void updateAvailableTagList(ObjectArrayList<MinecraftHeadsData> categoryData) {
        HashSet<String> categoryTags = new HashSet<String>();
        for (MinecraftHeadsData minecraftHeadData : categoryData) {
            categoryTags.addAll(minecraftHeadData.tags());
        }
        categoryTags.removeIf(String::isBlank);
        this.selectedTags.clear();
        this.availableTags.clear();
        this.availableTags.addAll(categoryTags);
        this.tagButton.method_25355(this.getTagButtonText());
        this.tagOverlay = null;
    }

    private void openTagsExecute() {
        if (this.tagOverlay == null) {
            FlowLayout tagSelectPanel = (FlowLayout)((FlowLayout)this.getModel().expandTemplate(FlowLayout.class, "select-tag", Map.of())).configure(flowLayout -> {
                FlowLayout tagListLayout = (FlowLayout)flowLayout.childById(FlowLayout.class, TAGS_LIST_LTR_ID);
                HeadGalleryScreen.checkNull((Component)tagListLayout, "flow-layout", TAGS_LIST_LTR_ID);
                LabelComponent tagsOverlayLabel = (LabelComponent)flowLayout.childById(LabelComponent.class, TAGS_OVERLAY_LABEL_ID);
                HeadGalleryScreen.checkNull((Component)tagsOverlayLabel, "label", TAGS_OVERLAY_LABEL_ID);
                ButtonComponent clearSelectedTags = (ButtonComponent)flowLayout.childById(ButtonComponent.class, CLEAR_SELECTED_TAGS_ID);
                HeadGalleryScreen.checkNull((Component)clearSelectedTags, "button", CLEAR_SELECTED_TAGS_ID);
                tagsOverlayLabel.text(this.getTagLabelText());
                ArrayList<ButtonComponent> buttonList = new ArrayList<ButtonComponent>();
                for (String availableTag : this.availableTags.stream().sorted().toList()) {
                    class_5250 buttonText = this.selectedTags.contains(availableTag) ? this.getSelectedTagText(availableTag) : class_2561.method_43470((String)availableTag);
                    ButtonComponent button = (ButtonComponent)Components.button((class_2561)buttonText, buttonComponent -> this.tagButtonExecute((ButtonComponent)buttonComponent, tagsOverlayLabel)).horizontalSizing(Sizing.fixed((int)200));
                    buttonList.add(button);
                }
                tagListLayout.children(buttonList);
                clearSelectedTags.onPress(buttonComponent -> {
                    for (Component component : buttonList) {
                        ButtonComponent buttonTag;
                        if (!(component instanceof ButtonComponent) || !this.selectedTags.contains((buttonTag = (ButtonComponent)component).method_25369().getString())) continue;
                        buttonTag.method_25306();
                    }
                });
                TextBoxRow.setup(flowLayout, TAG_SEARCH_ID, "", 100, value -> {
                    ArrayList<Component> buttonListCopy = new ArrayList<Component>(buttonList);
                    String valueToLowerCase = value.toLowerCase();
                    buttonListCopy.removeIf(tagComponent -> {
                        if (!(tagComponent instanceof ButtonComponent)) {
                            return false;
                        }
                        ButtonComponent buttonTag = (ButtonComponent)tagComponent;
                        String message = buttonTag.method_25369().getString();
                        return !message.toLowerCase().contains(valueToLowerCase) && !this.selectedTags.contains(message);
                    });
                    tagListLayout.clearChildren();
                    tagListLayout.children(buttonListCopy);
                });
            });
            tagSelectPanel.mouseDown().subscribe((mouseX, mouseY, button) -> true);
            this.tagOverlay = Containers.overlay((Component)tagSelectPanel);
            this.tagOverlay.zIndex(500);
        }
        this.addOverlay((Component)this.tagOverlay);
    }

    private void tagButtonExecute(ButtonComponent selectedButton, LabelComponent tagsOverlayLabel) {
        String value = selectedButton.method_25369().getString();
        if (this.selectedTags.contains(value)) {
            this.selectedTags.remove(value);
            selectedButton.method_25355((class_2561)class_2561.method_43470((String)value));
        } else {
            this.selectedTags.add(value);
            selectedButton.method_25355(this.getSelectedTagText(value));
        }
        this.applyFilters();
        this.setPage(this.page);
        this.tagButton.method_25355(this.getTagButtonText());
        tagsOverlayLabel.text(this.getTagLabelText());
    }

    public void setPage(int page) {
        int maxHeadsPerPage = FzmmClient.CONFIG.headGallery.maxHeadsPerPage();
        if (page < 1) {
            page = 1;
        }
        int firstElementIndex = (page - 1) * maxHeadsPerPage;
        int lastPage = (int)Math.ceil((float)this.categoryHeadsWithFilter.size() / (float)maxHeadsPerPage);
        if (firstElementIndex >= this.categoryHeadsWithFilter.size()) {
            page = lastPage;
            firstElementIndex = this.categoryHeadsWithFilter.isEmpty() ? 0 : (lastPage - 1) * maxHeadsPerPage;
        }
        this.page = page;
        this.currentPageLabel.text((class_2561)class_2561.method_43469((String)"fzmm.gui.headGallery.label.page", (Object[])new Object[]{page, lastPage}));
        int lastElementIndex = Math.min(page * maxHeadsPerPage, this.categoryHeadsWithFilter.size());
        List<GiveItemComponent> currentPageHeads = this.getPageItems(firstElementIndex, lastElementIndex);
        assert (this.field_22787 != null);
        for (GiveItemComponent component : currentPageHeads) {
            component.mouseEnter().subscribe(() -> {
                if (this.contentScroll.isInBoundingBox((double)component.x(), (double)component.y())) {
                    this.updatePreview(component.stack());
                }
            });
        }
        this.field_22787.execute(() -> {
            this.contentLayout.clearChildren();
            this.contentLayout.children((Collection)currentPageHeads);
        });
    }

    public List<GiveItemComponent> getPageItems(int startIndex, int endIndex) {
        ArrayList<GiveItemComponent> pageItems = new ArrayList<GiveItemComponent>();
        FzmmConfig config = FzmmClient.CONFIG;
        int nameColor = config.colors.headGalleryName().rgb();
        int tagsColor = config.colors.headGalleryTags().rgb();
        boolean stylingHeads = config.headGallery.stylingHeads();
        for (int i = startIndex; i != endIndex; ++i) {
            MinecraftHeadsData minecraftHeadsData = (MinecraftHeadsData)this.categoryHeadsWithFilter.get(i);
            class_1799 head = HeadBuilder.builder().skinValue(minecraftHeadsData.value()).id(minecraftHeadsData.uuid()).notAddToHistory().get();
            DisplayBuilder builder = DisplayBuilder.of(head);
            if (stylingHeads) {
                builder.setName(class_2561.method_43469((String)"fzmm.item.headGallery.heads.name", (Object[])new Object[]{minecraftHeadsData.name()}).getString(), nameColor).addLore(class_2561.method_43471((String)"fzmm.item.headGallery.heads.tags.title").getString(), tagsColor);
                for (String tag : minecraftHeadsData.tags()) {
                    builder.addLore(class_2561.method_43469((String)"fzmm.item.headGallery.heads.tags.tag", (Object[])new Object[]{tag}).getString(), tagsColor);
                }
            } else {
                builder.setName(minecraftHeadsData.name());
            }
            head = builder.get();
            pageItems.add(new GiveItemComponent(head));
        }
        return pageItems;
    }

    public void applyFilters() {
        if (this.contentSearchField == null) {
            return;
        }
        this.categoryHeadsWithFilter.clear();
        this.categoryHeadsWithFilter.addAll(this.categoryHeads);
        String search = this.contentSearchField.method_1882().toLowerCase();
        this.categoryHeadsWithFilter.removeIf(itemComponent -> !itemComponent.filter(this.selectedTags, search));
    }

    private void minecraftHeadsExecute() {
        assert (this.field_22787 != null);
        class_407.method_60866((class_437)this.field_22787.field_1755, (String)"https://minecraft-heads.com", (boolean)true);
    }

    private class_2561 getTagButtonText() {
        return class_2561.method_43469((String)TAG_BUTTON_TEXT, (Object[])new Object[]{this.selectedTags.size()});
    }

    private class_2561 getTagLabelText() {
        return class_2561.method_43469((String)TAG_LABEL_TEXT, (Object[])new Object[]{this.selectedTags.size(), this.categoryHeadsWithFilter.size()});
    }

    private class_2561 getSelectedTagText(String value) {
        return class_2561.method_43470((String)value).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_30938(Boolean.valueOf(true)).method_36139(4439218));
    }

    private void updatePreview(class_1799 stack) {
        Optional<class_8685> skinTextures = HeadUtils.getSkinTextures(stack);
        if (skinTextures.isEmpty()) {
            return;
        }
        this.frontEntityPreview.skin(skinTextures.get());
        this.backEntityPreview.skin(skinTextures.get());
    }

    @Override
    public void setMemento(IMementoObject memento) {
        HeadGalleryScreen.memento = (HeadGalleryMemento)memento;
    }

    @Override
    public Optional<IMementoObject> getMemento() {
        return Optional.ofNullable(memento);
    }

    @Override
    public IMementoObject createMemento() {
        return new HeadGalleryMemento(new HashSet<String>(this.selectedTags), this.page, this.selectedCategory, this.contentSearchField.method_1882());
    }

    @Override
    public void restoreMemento(IMementoObject mementoObject) {
        HeadGalleryMemento memento = (HeadGalleryMemento)mementoObject;
        this.selectedCategory = memento.category;
        this.contentSearchField.text(memento.contentSearch);
        if (memento.category != null) {
            ArrayList<Component> categoryList = new ArrayList<Component>(this.categoryButtonList);
            categoryList.removeIf(component -> !this.selectedCategory.equals(component.id()));
            categoryList.stream().findAny().ifPresent(component -> this.categoryButtonExecute((ButtonComponent)component, this.selectedCategory, () -> {
                this.selectedTags = memento.selectedTags;
                this.tagButton.method_25355(this.getTagButtonText());
                this.applyFilters();
                this.setPage(memento.page);
            }));
        }
    }

    private record HeadGalleryMemento(Set<String> selectedTags, int page, String category, String contentSearch) implements IMementoObject
    {
    }
}

