/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.encrypt_book.components;

import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.components.snack_bar.BaseSnackBarComponent;
import fzmm.zailer.me.client.gui.components.style.FzmmStyles;
import fzmm.zailer.me.client.gui.components.style.StyledComponents;
import fzmm.zailer.me.client.gui.components.style.StyledContainers;
import fzmm.zailer.me.client.gui.components.style.component.StyledLabelComponent;
import fzmm.zailer.me.client.gui.components.style.container.StyledFlowLayout;
import fzmm.zailer.me.client.gui.encrypt_book.translation_file_saver.ITranslationFileSaver;
import fzmm.zailer.me.client.gui.encrypt_book.translation_file_saver.TranslationCreateResourcePack;
import fzmm.zailer.me.client.gui.encrypt_book.translation_file_saver.TranslationUpdateResourcePack;
import fzmm.zailer.me.client.gui.encrypt_book.translation_file_saver.TranslationWriteLang;
import fzmm.zailer.me.client.logic.enycrpt_book.TranslationEncryptProfile;
import fzmm.zailer.me.utils.SnackBarManager;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.OverlayContainer;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class DecryptorSaverOverlay
extends OverlayContainer<StyledFlowLayout> {
    private static final int WIDTH = 350;
    private ITranslationFileSaver selectedSaver;

    public DecryptorSaverOverlay(TranslationEncryptProfile selectedProfile) {
        super((Component)StyledContainers.verticalFlow(Sizing.fixed((int)350), Sizing.content()));
        this.addComponents(selectedProfile);
        ((StyledFlowLayout)this.child).alignment(HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        ((StyledFlowLayout)this.child).gap(12);
        ((StyledFlowLayout)this.child).padding(Insets.of((int)6));
        ((StyledFlowLayout)this.child).surface(((StyledFlowLayout)this.child).styledPanel());
        this.zIndex(300);
    }

    protected void addComponents(TranslationEncryptProfile selectedProfile) {
        StyledLabelComponent label = StyledComponents.label((class_2561)class_2561.method_43471((String)"fzmm.gui.encryptbook.getDecryptor.title"));
        label.horizontalSizing(Sizing.expand((int)100));
        StyledFlowLayout optionsLayout = StyledContainers.verticalFlow(Sizing.expand((int)100), Sizing.content());
        List<TranslationWriteLang> options = List.of(new TranslationCreateResourcePack(), new TranslationUpdateResourcePack(), new TranslationWriteLang());
        for (ITranslationFileSaver iTranslationFileSaver : options) {
            optionsLayout.child(Components.button((class_2561)iTranslationFileSaver.getMessage(), optionButton -> {
                for (Component optionComponent : optionsLayout.children()) {
                    if (!(optionComponent instanceof ButtonComponent)) continue;
                    ButtonComponent buttonComponent = (ButtonComponent)optionComponent;
                    buttonComponent.field_22763 = buttonComponent != optionButton;
                }
                this.selectedSaver = option;
            }).renderer(FzmmStyles.DEFAULT_FLAT_BUTTON).horizontalSizing(Sizing.expand((int)100)));
        }
        ((ButtonComponent)optionsLayout.children().get(0)).method_25306();
        StyledFlowLayout buttonLayout = StyledContainers.horizontalFlow(Sizing.expand((int)100), Sizing.fixed((int)20));
        buttonLayout.child(Components.button((class_2561)class_2561.method_43471((String)"gui.done"), buttonComponent -> {
            this.execute(this.selectedSaver, selectedProfile);
            this.remove();
        }).positioning(Positioning.relative((int)0, (int)0)).horizontalSizing(Sizing.fixed((int)100)));
        buttonLayout.child(Components.button((class_2561)class_2561.method_43471((String)"fzmm.gui.button.cancel"), buttonComponent -> this.remove()).positioning(Positioning.relative((int)100, (int)0)).horizontalSizing(Sizing.fixed((int)100)));
        ((StyledFlowLayout)this.child).child((Component)label);
        ((StyledFlowLayout)this.child).child((Component)optionsLayout);
        ((StyledFlowLayout)this.child).child((Component)buttonLayout);
    }

    protected void execute(ITranslationFileSaver translationFileSaver, TranslationEncryptProfile profile) {
        ((CompletableFuture)translationFileSaver.save(profile).exceptionally(throwable -> {
            class_310.method_1551().execute(() -> {
                FzmmClient.LOGGER.error("[GetDecryptorOverlay] Failed to get decryptor", throwable);
                SnackBarManager.getInstance().add(BaseSnackBarComponent.builder("encryptor_save").keepOnLimit().backgroundColor(FzmmStyles.ALERT_ERROR_COLOR).mediumTimer().title((class_2561)class_2561.method_43471((String)"fzmm.gui.encryptbook.getDecryptor.snack_bar.error")).startTimer().build());
            });
            return true;
        })).thenAccept(cancelled -> {
            if (cancelled.booleanValue()) {
                return;
            }
            SnackBarManager.getInstance().add(BaseSnackBarComponent.builder("encryptor_save").backgroundColor(FzmmStyles.ALERT_SUCCESS_COLOR).mediumTimer().title((class_2561)class_2561.method_43471((String)"fzmm.gui.encryptbook.getDecryptor.snack_bar.success")).startTimer().build());
        });
    }
}

