/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.encrypt_book.components;

import fzmm.zailer.me.client.gui.components.BooleanButton;
import fzmm.zailer.me.client.gui.components.style.FzmmStyles;
import fzmm.zailer.me.client.gui.components.style.StyledComponents;
import fzmm.zailer.me.client.gui.components.style.StyledContainers;
import fzmm.zailer.me.client.gui.components.style.component.StyledLabelComponent;
import fzmm.zailer.me.client.gui.components.style.container.StyledFlowLayout;
import fzmm.zailer.me.client.gui.encrypt_book.EncryptBookScreen;
import fzmm.zailer.me.client.logic.enycrpt_book.TranslationEncryptProfile;
import io.wispforest.owo.config.ui.component.ConfigTextBox;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.OverlayContainer;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class AddEncryptProfileOverlay
extends OverlayContainer<StyledFlowLayout> {
    private static final int WIDTH = 350;

    public AddEncryptProfileOverlay(Consumer<TranslationEncryptProfile> onAdd) {
        super((Component)StyledContainers.verticalFlow(Sizing.fixed((int)350), Sizing.content()));
        this.addComponents(onAdd);
        ((StyledFlowLayout)this.child).alignment(HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        ((StyledFlowLayout)this.child).gap(12);
        ((StyledFlowLayout)this.child).padding(Insets.of((int)6));
        ((StyledFlowLayout)this.child).surface(((StyledFlowLayout)this.child).styledPanel());
        this.zIndex(300);
    }

    protected void addComponents(Consumer<TranslationEncryptProfile> onAdd) {
        StyledLabelComponent label = StyledComponents.label((class_2561)class_2561.method_43471((String)"fzmm.gui.encryptbook.addProfile.title"));
        label.horizontalSizing(Sizing.expand((int)100));
        StyledFlowLayout optionsLayout = StyledContainers.verticalFlow(Sizing.expand((int)100), Sizing.content());
        ConfigTextBox seedComponent = new ConfigTextBox();
        ConfigTextBox keyComponent = new ConfigTextBox();
        ConfigTextBox lengthComponent = new ConfigTextBox();
        ConfigTextBox asymmetricComponent = new ConfigTextBox();
        BooleanButton oldAlgorithmComponent = new BooleanButton();
        StyledLabelComponent duplicatedKeyLabel = StyledComponents.label((class_2561)class_2561.method_43473());
        class_5250 duplicateKeyText = class_2561.method_43471((String)"fzmm.gui.encryptbook.addProfile.key.duplicated");
        ButtonComponent randomAsymmetric = Components.button((class_2561)class_2561.method_43471((String)"fzmm.gui.button.random"), buttonComponent -> {
            int value = new Random(System.currentTimeMillis()).nextInt();
            asymmetricComponent.text(String.valueOf(value));
        });
        List<TranslationEncryptProfile> profiles = EncryptBookScreen.getProfiles();
        String defaultKey = "secret_mc_%s";
        int defaultSeed = 0;
        for (int i = 0; i != profiles.size() + 1; ++i) {
            if (this.isDuplicatedKey(profiles, i, defaultKey)) continue;
            defaultSeed = i;
            break;
        }
        seedComponent.configureForNumber(Integer.class);
        seedComponent.text(String.valueOf(defaultSeed));
        seedComponent.onChanged().subscribe(arg_0 -> this.lambda$addComponents$1(profiles, seedComponent, keyComponent, duplicatedKeyLabel, (class_2561)duplicateKeyText, arg_0));
        keyComponent.applyPredicate(arg_0 -> this.lambda$addComponents$2(seedComponent, profiles, duplicatedKeyLabel, (class_2561)duplicateKeyText, arg_0));
        keyComponent.text(defaultKey);
        lengthComponent.configureForNumber(Integer.class);
        lengthComponent.applyPredicate(s -> {
            try {
                double value = Double.parseDouble(s);
                return value >= 1.0 && value <= 512.0;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        });
        lengthComponent.text("255");
        asymmetricComponent.configureForNumber(Integer.class);
        asymmetricComponent.text("0");
        oldAlgorithmComponent.enabled(false);
        String baseKey = "fzmm.gui.encryptbook.addProfile.";
        optionsLayout.child(this.getRow(baseKey + "seed", new Component[]{seedComponent}));
        optionsLayout.child(this.getRow(baseKey + "key", new Component[]{keyComponent, duplicatedKeyLabel}));
        optionsLayout.child(this.getRow(baseKey + "length", new Component[]{lengthComponent}));
        optionsLayout.child(this.getRow(baseKey + "asymmetric", new Component[]{asymmetricComponent, randomAsymmetric}));
        optionsLayout.child(this.getRow(baseKey + "oldAlgorithm", new Component[]{oldAlgorithmComponent}));
        StyledFlowLayout buttonLayout = StyledContainers.horizontalFlow(Sizing.expand((int)100), Sizing.fixed((int)20));
        buttonLayout.child(Components.button((class_2561)class_2561.method_43471((String)"fzmm.gui.encryptbook.addProfile.done"), buttonComponent -> {
            TranslationEncryptProfile profile = new TranslationEncryptProfile((Integer)seedComponent.parsedValue(), (Integer)lengthComponent.parsedValue(), keyComponent.method_1882(), (Integer)asymmetricComponent.parsedValue(), oldAlgorithmComponent.enabled() ? 1 : 2);
            onAdd.accept(profile);
            this.remove();
        }).positioning(Positioning.relative((int)0, (int)0)).horizontalSizing(Sizing.fixed((int)100)));
        buttonLayout.child(Components.button((class_2561)class_2561.method_43471((String)"fzmm.gui.button.cancel"), buttonComponent -> this.remove()).positioning(Positioning.relative((int)100, (int)0)).horizontalSizing(Sizing.fixed((int)100)));
        ((StyledFlowLayout)this.child).child((Component)label);
        ((StyledFlowLayout)this.child).child((Component)optionsLayout);
        ((StyledFlowLayout)this.child).child((Component)buttonLayout);
    }

    private Component getRow(String translationKey, Component ... components) {
        components[0].horizontalSizing(Sizing.fixed((int)100));
        ArrayList<Component> componentList = new ArrayList<Component>();
        componentList.add(StyledComponents.label((class_2561)class_2561.method_43471((String)translationKey)).horizontalSizing(Sizing.fixed((int)100)).tooltip((class_2561)class_2561.method_43471((String)(translationKey + ".tooltip"))));
        componentList.addAll(List.of(components));
        return StyledContainers.horizontalFlow(Sizing.content(), Sizing.content()).hoveredSurface(FzmmStyles.DEFAULT_HOVERED).children(componentList).gap(4).verticalAlignment(VerticalAlignment.CENTER).horizontalSizing(Sizing.expand((int)100));
    }

    private boolean isDuplicatedKey(List<TranslationEncryptProfile> profiles, int seed, String key) {
        String translationKey = TranslationEncryptProfile.translationKey(key, seed);
        return profiles.stream().anyMatch(profile -> profile.translationKey().equals(translationKey));
    }

    private /* synthetic */ boolean lambda$addComponents$2(ConfigTextBox seedComponent, List profiles, LabelComponent duplicatedKeyLabel, class_2561 duplicateKeyText, String key) {
        int seed = (Integer)seedComponent.parsedValue();
        boolean isDuplicated = this.isDuplicatedKey(profiles, seed, key);
        duplicatedKeyLabel.text((class_2561)(isDuplicated ? duplicateKeyText : class_2561.method_43473()));
        return !isDuplicated;
    }

    private /* synthetic */ void lambda$addComponents$1(List profiles, ConfigTextBox seedComponent, ConfigTextBox keyComponent, LabelComponent duplicatedKeyLabel, class_2561 duplicateKeyText, String value) {
        if (this.isDuplicatedKey(profiles, (Integer)seedComponent.parsedValue(), keyComponent.method_1882())) {
            duplicatedKeyLabel.text(duplicateKeyText);
            keyComponent.method_1868(keyComponent.invalidColor());
        } else {
            duplicatedKeyLabel.text((class_2561)class_2561.method_43473());
            keyComponent.method_1868(keyComponent.validColor());
        }
    }
}

