/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.components.row;

import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.components.row.AbstractRow;
import fzmm.zailer.me.client.gui.components.style.StyledContainers;
import fzmm.zailer.me.client.gui.components.tabs.IScreenTabIdentifier;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.ArrayList;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.w3c.dom.Element;

public class ScreenTabRow
extends AbstractRow {
    private FlowLayout tabsLayout;
    private ScrollContainer<?> scrollContainer;

    public ScreenTabRow(String baseTranslationKey, String id) {
        super(baseTranslationKey);
        this.id(id);
        this.sizing(Sizing.content(), Sizing.fixed((int)26));
        this.surface(Surface.flat((int)Integer.MIN_VALUE));
        this.alignment(HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        this.gap(4);
        this.hoveredSurface(null);
    }

    @Override
    public Component[] getComponents(String id, String tooltipId) {
        return new Component[0];
    }

    public static String getScreenTabButtonId(String id) {
        return id + "-screen-tab-button";
    }

    public static String getScreenTabButtonId(IScreenTabIdentifier tab) {
        return ScreenTabRow.getScreenTabButtonId(tab.getId());
    }

    public static void setup(FlowLayout rootComponent, String id, Enum<? extends IScreenTabIdentifier> defaultTab) {
        ScreenTabRow screenTabRow = (ScreenTabRow)rootComponent.childById(ScreenTabRow.class, id);
        if (screenTabRow == null) {
            return;
        }
        screenTabRow.setup(defaultTab);
    }

    public void setup(Enum<? extends IScreenTabIdentifier> defaultTab) {
        ArrayList<ButtonComponent> componentList = new ArrayList<ButtonComponent>();
        for (Enum tab : (Enum[])defaultTab.getClass().getEnumConstants()) {
            IScreenTabIdentifier screenTab = (IScreenTabIdentifier)((Object)tab);
            boolean active = tab != defaultTab;
            String translationKey = BaseFzmmScreen.getTabTranslationKey(this.baseTranslationKey) + screenTab.getId();
            class_5250 text = class_2561.method_43471((String)translationKey);
            ButtonComponent button = Components.button((class_2561)text, buttonComponent -> {});
            button.id(ScreenTabRow.getScreenTabButtonId(screenTab.getId()));
            button.field_22763 = active;
            button.verticalSizing(Sizing.fixed((int)16));
            componentList.add(button);
        }
        this.tabsLayout = StyledContainers.horizontalFlow(Sizing.content(), Sizing.content()).children(componentList).gap(this.gap());
        this.scrollContainer = (ScrollContainer)StyledContainers.horizontalScroll(Sizing.fill((int)100), Sizing.fill((int)100), this.tabsLayout).alignment(HorizontalAlignment.CENTER, VerticalAlignment.CENTER).padding(Insets.vertical((int)5)).margins(Insets.horizontal((int)20));
        this.child((Component)this.scrollContainer);
    }

    public static ScreenTabRow parse(Element element) {
        String baseTranslationKey = BaseFzmmScreen.getBaseTranslationKey(element);
        String id = ScreenTabRow.getId(element);
        return new ScreenTabRow(baseTranslationKey, id);
    }

    public boolean onMouseScroll(double mouseX, double mouseY, double amount) {
        if (this.scrollContainer.width() > this.tabsLayout.width()) {
            return false;
        }
        return super.onMouseScroll(mouseX, mouseY, amount);
    }
}

