/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.components.row;

import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.components.BooleanButton;
import fzmm.zailer.me.client.gui.components.row.AbstractRow;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Sizing;
import net.minecraft.class_4185;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;

public class BooleanRow
extends AbstractRow {
    public BooleanRow(String baseTranslationKey, String id, String tooltipId) {
        super(baseTranslationKey, id, tooltipId, true);
    }

    @Override
    public Component[] getComponents(String id, String tooltipId) {
        Component buttonComponent = new BooleanButton().id(BooleanRow.getBooleanButtonId(id));
        return new Component[]{buttonComponent};
    }

    public static String getBooleanButtonId(String id) {
        return id + "-boolean-button";
    }

    public static BooleanButton setup(FlowLayout rootComponent, String id, boolean defaultValue) {
        return BooleanRow.setup(rootComponent, id, defaultValue, null);
    }

    public static BooleanButton setup(FlowLayout rootComponent, String id, boolean defaultValue, @Nullable class_4185.class_4241 toggledListener) {
        BooleanButton booleanButton = (BooleanButton)rootComponent.childById(BooleanButton.class, BooleanRow.getBooleanButtonId(id));
        ButtonComponent resetButton = (ButtonComponent)rootComponent.childById(ButtonComponent.class, BooleanRow.getResetButtonId(id));
        BaseFzmmScreen.checkNull((Component)booleanButton, "boolean-button", BooleanRow.getBooleanButtonId(id));
        booleanButton.enabled(defaultValue);
        booleanButton.onPress(button -> {
            if (resetButton != null) {
                boolean bl = resetButton.field_22763 = booleanButton.enabled() != defaultValue;
            }
            if (toggledListener != null) {
                toggledListener.onPress((class_4185)button);
            }
        });
        booleanButton.horizontalSizing(Sizing.fixed((int)200));
        if (resetButton != null) {
            resetButton.onPress(button -> booleanButton.method_25306());
            resetButton.field_22763 = booleanButton.enabled() != defaultValue;
        }
        return booleanButton;
    }

    public static BooleanRow parse(Element element) {
        String baseTranslationKey = BaseFzmmScreen.getBaseTranslationKey(element);
        String id = BooleanRow.getId(element);
        String tooltipId = BooleanRow.getTooltipId(element, id);
        return new BooleanRow(baseTranslationKey, id, tooltipId);
    }
}

