/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.components.image.source;

import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.components.image.ScreenshotZoneComponent;
import fzmm.zailer.me.client.gui.components.image.source.IInteractiveImageLoader;
import fzmm.zailer.me.client.gui.components.snack_bar.BaseSnackBarComponent;
import fzmm.zailer.me.client.gui.components.snack_bar.ISnackBarComponent;
import fzmm.zailer.me.client.gui.components.style.FzmmStyles;
import fzmm.zailer.me.client.gui.components.style.StyledComponents;
import fzmm.zailer.me.client.gui.components.style.StyledContainers;
import fzmm.zailer.me.client.gui.components.style.component.StyledLabelComponent;
import fzmm.zailer.me.utils.FzmmUtils;
import fzmm.zailer.me.utils.SnackBarManager;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.VerticalAlignment;
import io.wispforest.owo.ui.hud.Hud;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import net.minecraft.class_1011;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_318;
import net.minecraft.class_437;

public class ScreenshotSource
implements IInteractiveImageLoader {
    private static final class_2960 HUD_CAPTURE_SCREENSHOT = class_2960.method_60655((String)"fzmm", (String)"screenshot_capture");
    private static ScreenshotSource instance;
    private BufferedImage image = null;
    private Consumer<BufferedImage> consumer;
    private BaseFzmmScreen previousScreen;

    public static ScreenshotSource getInstance() {
        return instance;
    }

    public static boolean hasInstance() {
        return instance != null;
    }

    @Override
    public void execute(Consumer<BufferedImage> consumer) {
        BaseFzmmScreen baseScreen;
        this.image = null;
        this.consumer = consumer;
        class_310 client = class_310.method_1551();
        class_437 class_4372 = client.field_1755;
        this.previousScreen = class_4372 instanceof BaseFzmmScreen ? (baseScreen = (BaseFzmmScreen)class_4372) : null;
        SnackBarManager.getInstance().moveToHud(this.previousScreen);
        client.method_1507(null);
        Hud.add((class_2960)HUD_CAPTURE_SCREENSHOT, this::getHud);
        instance = this;
    }

    @Override
    public Optional<BufferedImage> getImage() {
        return Optional.ofNullable(this.image);
    }

    @Override
    public boolean hasTextField() {
        return false;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
        this.consumer.accept(this.image);
    }

    private FlowLayout getHud() {
        FlowLayout hudLayout = (FlowLayout)StyledContainers.verticalFlow(Sizing.fill((int)100), Sizing.fill((int)100)).positioning(Positioning.absolute((int)0, (int)0));
        ScreenshotZoneComponent screenshotZoneComponent = new ScreenshotZoneComponent();
        screenshotZoneComponent.sizing(Sizing.fill((int)100), Sizing.fill((int)100)).positioning(Positioning.absolute((int)0, (int)0));
        FlowLayout labelLayout = (FlowLayout)StyledContainers.verticalFlow(Sizing.fill((int)100), Sizing.fixed((int)25)).alignment(HorizontalAlignment.CENTER, VerticalAlignment.CENTER).positioning(Positioning.absolute((int)0, (int)0));
        class_2561 keyTranslation = FzmmClient.OPEN_MAIN_GUI_KEYBINDING.method_16007();
        StyledLabelComponent labelComponent = StyledComponents.label((class_2561)class_2561.method_43469((String)"fzmm.gui.option.image.screenshot.message", (Object[])new Object[]{keyTranslation.getString()}));
        labelLayout.child((Component)labelComponent);
        hudLayout.child((Component)screenshotZoneComponent);
        hudLayout.child((Component)labelLayout);
        return hudLayout;
    }

    public void takeScreenshot() {
        byte[] byteArray = null;
        Exception exception = null;
        class_276 framebuffer = class_310.method_1551().method_1522();
        try (class_1011 screenshot = class_318.method_1663((class_276)framebuffer);){
            byteArray = screenshot.method_24036();
        }
        catch (Exception e) {
            exception = e;
        }
        byte[] finalByteArray = byteArray;
        Exception finalException = exception;
        CompletableFuture.supplyAsync(() -> {
            if (finalException != null) {
                throw new RuntimeException(finalException);
            }
            try {
                BufferedImage screenshot = ImageIO.read(new ByteArrayInputStream(finalByteArray));
                int width = screenshot.getWidth();
                int height = screenshot.getHeight();
                int smallerSide = Math.min(width, height);
                int halfLongerSide = smallerSide / 2;
                BufferedImage scaled = screenshot.getSubimage(width / 2 - halfLongerSide, height / 2 - halfLongerSide, smallerSide, smallerSide);
                BufferedImage finalImage = this.removePadding(scaled);
                screenshot.flush();
                scaled.flush();
                return finalImage;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, class_156.method_18349()).whenComplete((image, throwable) -> {
            instance = null;
            ISnackBarComponent snackBar = null;
            if (throwable != null || image == null) {
                FzmmClient.LOGGER.error("[ScreenshotSource] Unexpected error while taking screenshot", throwable);
                snackBar = BaseSnackBarComponent.builder("load_image").title((class_2561)class_2561.method_43471((String)"fzmm.snack_bar.image.error.title")).details((class_2561)class_2561.method_43471((String)"fzmm.snack_bar.image.error.details.unexpectedError")).backgroundColor(FzmmStyles.ALERT_ERROR_COLOR).closeButton().build();
            }
            ISnackBarComponent finalSnackBar = snackBar;
            class_310 client = class_310.method_1551();
            client.execute(() -> {
                SnackBarManager manager = SnackBarManager.getInstance();
                Hud.remove((class_2960)HUD_CAPTURE_SCREENSHOT);
                if (finalSnackBar != null) {
                    manager.add(finalSnackBar);
                }
                FzmmUtils.setScreen(this.previousScreen);
                this.previousScreen = null;
                this.setImage((BufferedImage)image);
            });
        });
    }

    private BufferedImage removePadding(BufferedImage image) {
        int padding = 25 * (Integer)class_310.method_1551().field_1690.method_42474().method_41753();
        BufferedImage paddedScreenshot = new BufferedImage(image.getWidth() - 2 * padding, image.getHeight() - 2 * padding, 1);
        Graphics2D g2d = paddedScreenshot.createGraphics();
        g2d.drawImage((Image)image, -padding, -padding, null);
        g2d.dispose();
        return paddedScreenshot;
    }
}

