/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.components.containers;

import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.components.style.StyledComponents;
import fzmm.zailer.me.client.gui.components.style.StyledContainers;
import fzmm.zailer.me.client.gui.components.style.component.StyledLabelComponent;
import fzmm.zailer.me.client.gui.components.style.container.StyledFlowLayout;
import fzmm.zailer.me.client.gui.components.style.container.StyledScrollContainer;
import fzmm.zailer.me.config.FzmmConfig;
import fzmm.zailer.me.utils.FzmmUtils;
import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.component.BoxComponent;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.ColorPickerComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.OverlayContainer;
import io.wispforest.owo.ui.container.StackLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3545;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ColorOverlay
extends OverlayContainer<StyledFlowLayout> {
    private final List<FlowLayout> colorsLayouts = new ArrayList<FlowLayout>();
    @Nullable
    private Color selectedColor = null;
    private static final int WIDTH = 190;
    private static final int HEIGHT = 170;
    private static final int COLOR_SIZE = 16;

    public ColorOverlay(Color color, boolean withAlpha, Consumer<ColorPickerComponent> onConfirm, BoxComponent colorPreview) {
        super((Component)StyledContainers.verticalFlow(Sizing.content(), Sizing.content()));
        this.addComponents(color, withAlpha, onConfirm, colorPreview);
        ((StyledFlowLayout)this.child).alignment(HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        ((StyledFlowLayout)this.child).gap(4);
        this.zIndex(300);
    }

    protected void addComponents(Color color, boolean withAlpha, Consumer<ColorPickerComponent> onConfirm, BoxComponent colorPreview) {
        FlowLayout colorPickerLayout = this.getColorPickerComponent(color, withAlpha, onConfirm, colorPreview);
        StyledFlowLayout firstRow = StyledContainers.horizontalFlow(Sizing.content(), Sizing.content());
        firstRow.gap(4);
        ColorPickerComponent picker = (ColorPickerComponent)colorPickerLayout.childById(ColorPickerComponent.class, "color-picker");
        if (picker == null) {
            FzmmClient.LOGGER.warn("[ColorOverlay] 'color-picker' component not found");
            return;
        }
        firstRow.child((Component)this.getFavoriteColorsLayout(picker));
        firstRow.child((Component)colorPickerLayout);
        firstRow.gap(4);
        ((StyledFlowLayout)this.child).child((Component)firstRow);
        ((StyledFlowLayout)this.child).child((Component)this.getDefaultColorsLayout(picker));
        picker.selectedColor(color);
    }

    public FlowLayout getFavoriteColorsLayout(ColorPickerComponent picker) {
        FzmmConfig.Colors config = FzmmClient.CONFIG.colors;
        StyledFlowLayout layout = StyledContainers.verticalFlow(Sizing.fixed((int)190), Sizing.fixed((int)170));
        layout.gap(5);
        layout.padding(Insets.of((int)5));
        layout.surface(layout.styledPanel());
        layout.horizontalAlignment(HorizontalAlignment.CENTER);
        layout.mouseDown().subscribe((mouseX, mouseY, button) -> true);
        BaseComponent labelComponent = StyledComponents.label((class_2561)class_2561.method_43471((String)"fzmm.gui.colorPicker.title.favorite")).shadow(true).margins(Insets.top((int)3));
        StyledFlowLayout favoriteColorsComponent = StyledContainers.ltrTextFlow(Sizing.fill((int)100), Sizing.content());
        favoriteColorsComponent.children(config.favoriteColors().stream().map(color -> (FlowLayout)this.newColorBox(picker, (Color)color)).collect(Collectors.toList()));
        favoriteColorsComponent.horizontalAlignment(HorizontalAlignment.CENTER);
        StyledScrollContainer<StyledFlowLayout> favoriteColorsScroll = StyledContainers.verticalScroll(Sizing.content(), Sizing.fill((int)75), favoriteColorsComponent);
        ButtonComponent removeColorButton = Components.button((class_2561)class_2561.method_43471((String)"fzmm.gui.button.remove"), this.removeFavoriteExecute(favoriteColorsComponent, config));
        removeColorButton.sizing(Sizing.fixed((int)50), Sizing.fixed((int)15)).zIndex(300).id("remove-favorite-button");
        ButtonComponent addColorButton = Components.button((class_2561)class_2561.method_43471((String)"fzmm.gui.button.add"), this.addFavoriteExecute(picker, favoriteColorsComponent, config));
        addColorButton.sizing(Sizing.fixed((int)50), Sizing.fixed((int)15)).zIndex(300).id("add-favorite-button");
        FlowLayout buttonsLayout = this.getButtonsLayout(new Component[]{removeColorButton, addColorButton});
        layout.children(List.of(labelComponent, favoriteColorsScroll, buttonsLayout));
        return layout;
    }

    private Consumer<ButtonComponent> addFavoriteExecute(ColorPickerComponent picker, FlowLayout favoriteColorsComponent, FzmmConfig.Colors config) {
        return button -> {
            Color selectedColor = picker.selectedColor();
            if (this.getFavoriteList(favoriteColorsComponent).stream().anyMatch(color -> color.equals((Object)selectedColor))) {
                return;
            }
            FlowLayout colorLayout = (FlowLayout)this.newColorBox(picker, selectedColor);
            this.colorsLayouts.add(colorLayout);
            favoriteColorsComponent.child((Component)colorLayout);
            this.updateSelected(selectedColor, colorLayout);
            config.favoriteColors(this.getFavoriteList(favoriteColorsComponent));
            FzmmClient.CONFIG.save();
        };
    }

    private Consumer<ButtonComponent> removeFavoriteExecute(FlowLayout favoriteColorsComponent, FzmmConfig.Colors config) {
        return button -> {
            if (this.selectedColor == null) {
                return;
            }
            ArrayList<Color> updatedFavoriteColors = new ArrayList<Color>(config.favoriteColors());
            if (!updatedFavoriteColors.removeIf(color -> color.equals((Object)this.selectedColor))) {
                return;
            }
            List<Component> favoriteColorsComponentList = List.copyOf(favoriteColorsComponent.children());
            for (Component favoriteColor : favoriteColorsComponentList) {
                BoxComponent boxComponent;
                FlowLayout colorLayout;
                Object patt0$temp;
                if (!(favoriteColor instanceof FlowLayout) || !((patt0$temp = (colorLayout = (FlowLayout)favoriteColor).children().get(0)) instanceof BoxComponent) || (boxComponent = (BoxComponent)patt0$temp).startColor().get() != this.selectedColor) continue;
                favoriteColorsComponent.removeChild(favoriteColor);
                this.colorsLayouts.remove(favoriteColor);
            }
            this.updateSelected(null, null);
            config.favoriteColors(updatedFavoriteColors);
            FzmmClient.CONFIG.save();
        };
    }

    private List<Color> getFavoriteList(FlowLayout favoriteColorsComponent) {
        ArrayList<Color> colorList = new ArrayList<Color>();
        for (Component component : favoriteColorsComponent.children()) {
            FlowLayout layout;
            Object e;
            if (!(component instanceof FlowLayout) || !((e = (layout = (FlowLayout)component).children().get(0)) instanceof BoxComponent)) continue;
            BoxComponent boxComponent = (BoxComponent)e;
            colorList.add((Color)boxComponent.startColor().get());
        }
        return colorList;
    }

    public Component newColorBox(ColorPickerComponent picker, Color color) {
        BaseComponent boxComponent = Components.box((Sizing)Sizing.fixed((int)16), (Sizing)Sizing.fixed((int)16)).color(color).fill(true).margins(Insets.of((int)1)).cursorStyle(CursorStyle.HAND);
        StyledFlowLayout colorLayout = StyledContainers.horizontalFlow(Sizing.fixed((int)18), Sizing.fixed((int)18));
        colorLayout.padding(Insets.of((int)1));
        colorLayout.alignment(HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        colorLayout.child((Component)boxComponent);
        boxComponent.mouseDown().subscribe((mouseX, mouseY, button) -> {
            picker.selectedColor(color);
            this.updateSelected(color, colorLayout);
            return true;
        });
        this.colorsLayouts.add(colorLayout);
        return colorLayout;
    }

    private void updateSelected(@Nullable Color color, @Nullable FlowLayout colorLayout) {
        BoxComponent boxComponent;
        Object e;
        for (FlowLayout layout : this.colorsLayouts) {
            layout.surface(Surface.BLANK);
        }
        this.selectedColor = color;
        if (color != null && colorLayout != null && (e = colorLayout.children().get(0)) instanceof BoxComponent && ((Color)(boxComponent = (BoxComponent)e).startColor().get()).equals((Object)color)) {
            colorLayout.surface(Surface.outline((int)-1));
        }
    }

    public FlowLayout getColorPickerComponent(Color color, boolean withAlpha, Consumer<ColorPickerComponent> onConfirm, BoxComponent colorPreview) {
        StyledFlowLayout layout = StyledContainers.verticalFlow(Sizing.fixed((int)190), Sizing.fixed((int)170));
        layout.gap(5).padding(Insets.of((int)5)).surface(layout.styledPanel()).horizontalAlignment(HorizontalAlignment.CENTER).mouseDown().subscribe((mouseX, mouseY, button) -> true);
        StyledLabelComponent labelComponent = StyledComponents.label((class_2561)class_2561.method_43471((String)"fzmm.gui.colorPicker.title.picker"));
        ColorPickerComponent picker = (ColorPickerComponent)new ColorPickerComponent().selectedColor(color).showAlpha(withAlpha).sizing(Sizing.fixed((int)160), Sizing.fixed((int)100)).id("color-picker");
        BoxComponent currentColor = (BoxComponent)Components.box((Sizing)Sizing.fixed((int)80), (Sizing)Sizing.fixed((int)15)).fill(true).color(color).id("current-color");
        FlowLayout colorsLayout = StyledContainers.horizontalFlow(Sizing.content(), Sizing.content()).child((Component)Components.box((Sizing)Sizing.fixed((int)80), (Sizing)Sizing.fixed((int)15)).fill(true).color(color)).child((Component)currentColor);
        assert (((StyledFlowLayout)this.child).parent() != null);
        ButtonComponent cancelButton = Components.button((class_2561)class_2561.method_43471((String)"fzmm.gui.colorPicker.cancel"), buttonComponent -> ((StyledFlowLayout)this.child).parent().remove());
        cancelButton.sizing(Sizing.fixed((int)50), Sizing.fixed((int)15)).id("cancel-button");
        ButtonComponent confirmButton = Components.button((class_2561)class_2561.method_43471((String)"fzmm.gui.colorPicker.confirm"), buttonComponent -> {
            onConfirm.accept(picker);
            colorPreview.color(picker.selectedColor());
            ((StyledFlowLayout)this.child).parent().remove();
        });
        confirmButton.sizing(Sizing.fixed((int)50), Sizing.fixed((int)15)).id("confirm-button");
        FlowLayout buttonsLayout = this.getButtonsLayout(new Component[]{cancelButton, confirmButton});
        picker.onChanged().subscribe(selectedColor -> {
            this.selectedColor = selectedColor;
            currentColor.color(selectedColor);
        });
        List<FlowLayout> components = List.of(labelComponent, picker, colorsLayout, buttonsLayout);
        layout.children(components);
        return layout;
    }

    private FlowLayout getButtonsLayout(Component ... components) {
        return (FlowLayout)StyledContainers.horizontalFlow(Sizing.fill((int)100), Sizing.content()).children(Arrays.asList(components)).gap(10).horizontalAlignment(HorizontalAlignment.CENTER).positioning(Positioning.relative((int)0, (int)98));
    }

    private FlowLayout getDefaultColorsLayout(ColorPickerComponent picker) {
        StyledFlowLayout result = StyledContainers.verticalFlow(Sizing.content(), Sizing.content());
        result.gap(4);
        int width = 384;
        result.child((Component)this.getDyeColorsLayout(picker, width));
        result.child((Component)this.getFormattingLayout(picker, width));
        for (Component child : result.children()) {
            if (!(child instanceof StyledFlowLayout)) continue;
            StyledFlowLayout flowLayout = (StyledFlowLayout)child;
            flowLayout.padding(Insets.of((int)5)).surface(flowLayout.styledPanel()).horizontalAlignment(HorizontalAlignment.CENTER);
        }
        return result;
    }

    private FlowLayout getDyeColorsLayout(ColorPickerComponent picker, int width) {
        class_1767[] defaultDyeColorArray = FzmmUtils.getDyeColorsInOrder();
        ArrayList<class_3545<Color, Component>> dyeColorsComponents = new ArrayList<class_3545<Color, Component>>();
        for (class_1767 dyeColor : defaultDyeColorArray) {
            class_1792 dyeItem = class_1802.field_8162;
            for (class_1792 item : class_7923.field_41178.method_10220().toList()) {
                class_1769 dyeItem1;
                if (!(item instanceof class_1769) || (dyeItem1 = (class_1769)item).method_7802() != dyeColor) continue;
                dyeItem = item;
                break;
            }
            dyeColorsComponents.add((class_3545<Color, Component>)new class_3545((Object)Color.ofRgb((int)dyeColor.method_7787()), (Object)Components.item((class_1799)dyeItem.method_7854())));
        }
        List<Component> dyeComponents = this.getColorsComponentsWithIcon(picker, dyeColorsComponents);
        StyledFlowLayout dyeLayout = StyledContainers.ltrTextFlow(Sizing.fixed((int)width), Sizing.content());
        dyeLayout.children(dyeComponents);
        return dyeLayout;
    }

    private FlowLayout getFormattingLayout(ColorPickerComponent picker, int width) {
        class_124[] defaultFormattingArray = FzmmUtils.getFormattingColorsInOrder();
        ArrayList<FlowLayout> formattingComponents = new ArrayList<FlowLayout>();
        for (class_124 formatting : defaultFormattingArray) {
            if (formatting.method_532() == null) continue;
            String colorCode = String.valueOf(formatting.method_36145());
            FlowLayout colorLayout = (FlowLayout)this.newColorBox(picker, Color.ofFormatting((class_124)formatting));
            colorLayout.tooltip((class_2561)class_2561.method_43470((String)("&" + colorCode)));
            formattingComponents.add(colorLayout);
        }
        StyledFlowLayout formattingLayout = StyledContainers.ltrTextFlow(Sizing.fixed((int)width), Sizing.content());
        formattingLayout.children(formattingComponents);
        return formattingLayout;
    }

    private List<Component> getColorsComponentsWithIcon(ColorPickerComponent picker, List<class_3545<Color, Component>> colors) {
        ArrayList<Component> result = new ArrayList<Component>();
        for (class_3545<Color, Component> entry : colors) {
            StackLayout colorStack = Containers.stack((Sizing)Sizing.content(), (Sizing)Sizing.content());
            FlowLayout colorLayout = (FlowLayout)this.newColorBox(picker, (Color)entry.method_15442());
            Component colorIconComponent = (Component)entry.method_15441();
            colorStack.child((Component)colorLayout);
            colorStack.child(colorIconComponent);
            colorIconComponent.mouseDown().subscribe((arg_0, arg_1, arg_2) -> ((FlowLayout)colorLayout).onMouseDown(arg_0, arg_1, arg_2));
            colorIconComponent.cursorStyle(CursorStyle.HAND);
            colorStack.alignment(HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
            result.add((Component)colorStack);
        }
        return result;
    }
}

