/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.banner_editor.tabs;

import fzmm.zailer.me.builders.BannerBuilder;
import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.banner_editor.BannerEditorScreen;
import fzmm.zailer.me.client.gui.banner_editor.tabs.IBannerEditorTab;
import fzmm.zailer.me.utils.FzmmUtils;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.util.UISounds;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2582;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7446;
import net.minecraft.class_7924;
import net.minecraft.class_9307;

public class AddPatternsTab
implements IBannerEditorTab {
    private static final String PATTERNS_LAYOUT = "add-patterns-layout";
    private FlowLayout patternsLayout;

    @Override
    public String getId() {
        return "addPatterns";
    }

    @Override
    public void setupComponents(FlowLayout rootComponent) {
        this.patternsLayout = (FlowLayout)rootComponent.childById(FlowLayout.class, PATTERNS_LAYOUT);
        BaseFzmmScreen.checkNull((Component)this.patternsLayout, "flow-layout", PATTERNS_LAYOUT);
    }

    @Override
    public void update(BannerEditorScreen parent, BannerBuilder currentBanner, class_1767 color) {
        this.patternsLayout.clearChildren();
        ArrayList<Component> bannerList = new ArrayList<Component>();
        class_5455 registryManager = FzmmUtils.getRegistryManager();
        class_2378 bannerRegistry = registryManager.method_30530(class_7924.field_41252);
        Optional basePatternOptional = bannerRegistry.method_40264(class_7446.field_39151);
        if (basePatternOptional.isEmpty()) {
            FzmmClient.LOGGER.error("[AddPatternsTab] base pattern is null");
            return;
        }
        class_6880.class_6883 basePattern = (class_6880.class_6883)basePatternOptional.get();
        for (class_6880.class_6883 pattern : bannerRegistry.method_40270().toList()) {
            if (basePattern == pattern) continue;
            class_1799 banner = currentBanner.copy().addLayer(color, (class_6880<class_2582>)pattern).get();
            Component itemComponent = Components.item((class_1799)banner).sizing(Sizing.fixed((int)32), Sizing.fixed((int)32)).tooltip(BannerBuilder.tooltipOf(new class_9307.class_9308((class_6880)pattern, color)));
            itemComponent.mouseDown().subscribe((mouseX, mouseY, button) -> {
                UISounds.playButtonSound();
                parent.addUndo(currentBanner);
                currentBanner.addLayer(color, (class_6880<class_2582>)pattern);
                parent.updatePreview(currentBanner);
                return true;
            });
            itemComponent.cursorStyle(CursorStyle.HAND);
            bannerList.add(itemComponent);
        }
        this.patternsLayout.children(bannerList);
    }
}

