/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.command.fzmm;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import fzmm.zailer.me.builders.HeadBuilder;
import fzmm.zailer.me.client.command.ISubCommand;
import fzmm.zailer.me.utils.FzmmUtils;
import fzmm.zailer.me.utils.HeadUtils;
import fzmm.zailer.me.utils.ItemUtils;
import fzmm.zailer.me.utils.skin.CacheSkinGetter;
import fzmm.zailer.me.utils.skin.SkinGetterDecorator;
import fzmm.zailer.me.utils.skin.VanillaSkinGetter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_7157;

public class SkullCommand
implements ISubCommand {
    @Override
    public String alias() {
        return "skull";
    }

    @Override
    public String syntax() {
        return "skull <skull owner> cache/mineskin/mojang";
    }

    @Override
    public LiteralCommandNode<FabricClientCommandSource> getBaseCommand(class_7157 registryAccess, LiteralArgumentBuilder<FabricClientCommandSource> builder) {
        ArgumentCommandNode argument = ((RequiredArgumentBuilder)ClientCommandManager.argument((String)"skull owner", (ArgumentType)StringArgumentType.word()).suggests(FzmmUtils.SUGGESTION_PLAYER).executes(ctx -> {
            String skullOwner = (String)ctx.getArgument("skull owner", String.class);
            this.getHead(new CacheSkinGetter(new VanillaSkinGetter()), skullOwner).whenComplete((stack, throwable) -> ItemUtils.give(stack));
            return 1;
        })).build();
        for (LiteralCommandNode<FabricClientCommandSource> subCommand : this.getArgSubCommands()) {
            argument.addChild(subCommand);
        }
        return ((LiteralArgumentBuilder)builder.then((CommandNode)argument)).build();
    }

    private List<LiteralCommandNode<FabricClientCommandSource>> getArgSubCommands() {
        ArrayList<LiteralCommandNode<FabricClientCommandSource>> result = new ArrayList<LiteralCommandNode<FabricClientCommandSource>>();
        result.add(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cache").executes(ctx -> {
            String skullOwner = (String)ctx.getArgument("skull owner", String.class);
            this.getHead(new CacheSkinGetter(), skullOwner).whenComplete((stack, throwable) -> ItemUtils.give(stack));
            return 1;
        })).build());
        result.add(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"mineskin").executes(ctx -> {
            String skullOwner = (String)ctx.getArgument("skull owner", String.class);
            CompletableFuture.runAsync(() -> HeadUtils.uploadAndGetHead(skullOwner).ifPresent(ItemUtils::give), class_156.method_18349());
            return 1;
        })).build());
        result.add(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"mojang").executes(ctx -> {
            String skullOwner = (String)ctx.getArgument("skull owner", String.class);
            this.getHead(new VanillaSkinGetter(), skullOwner).whenComplete((stack, throwable) -> ItemUtils.give(stack));
            return 1;
        })).build());
        return result;
    }

    private CompletableFuture<class_1799> getHead(SkinGetterDecorator skinDecorator, String playerName) {
        return CompletableFuture.supplyAsync(() -> skinDecorator.getHead(playerName).orElseGet(() -> HeadBuilder.of(playerName)), class_156.method_18349());
    }
}

