/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client;

import fzmm.zailer.me.builders.ArmorStandBuilder;
import fzmm.zailer.me.builders.BlockStateItemBuilder;
import fzmm.zailer.me.builders.CrossbowBuilder;
import fzmm.zailer.me.builders.DisplayBuilder;
import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.utils.FzmmUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1299;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1826;
import net.minecraft.class_1935;
import net.minecraft.class_2073;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_3765;
import net.minecraft.class_39;
import net.minecraft.class_52;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_7706;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9279;
import net.minecraft.class_9284;
import net.minecraft.class_9297;
import net.minecraft.class_9334;

public class FzmmItemGroup {
    public static final String OPERATOR_BASE_TRANSLATION_KEY = "itemGroup.op";
    public static final String USEFUL_BLOCK_STATES_BASE_TRANSLATION_KEY = "itemGroup.fzmm.useful_block_states";
    public static final class_2960 USEFUL_BLOCK_STATES_IDENTIFIER = class_2960.method_60655((String)"fzmm", (String)"useful_block_states");
    public static final class_2960 LOOT_CHESTS_IDENTIFIER = class_2960.method_60655((String)"fzmm", (String)"loot_chests");

    public static void register() {
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41063).register(entries -> {
            class_5455 registryManager = FzmmUtils.getRegistryManager();
            ArrayList<class_1799> newEntries = new ArrayList<class_1799>();
            newEntries.add(new class_1799((class_1935)class_1802.field_8204));
            newEntries.add(new class_1799((class_1935)class_1802.field_8360));
            newEntries.add(new class_1799((class_1935)class_1802.field_8598));
            newEntries.add(class_1802.field_8361.method_7854());
            newEntries.add(new class_1799((class_1935)class_1802.field_8766));
            newEntries.add(new class_1799((class_1935)class_1802.field_8574));
            newEntries.add(new class_1799((class_1935)class_1802.field_8436));
            newEntries.add(new class_1799((class_1935)class_1802.field_8150));
            newEntries.add(new class_1799((class_1935)class_1802.field_8087));
            newEntries.add(class_1802.field_8840.method_7854());
            FzmmItemGroup.addSpawnEggs(newEntries);
            FzmmItemGroup.addArmorStand(newEntries);
            FzmmItemGroup.addItemFrames(newEntries);
            FzmmItemGroup.addNameTags(newEntries);
            FzmmItemGroup.addCrossbows(newEntries);
            try {
                newEntries.add(class_3765.method_16515((class_7871)registryManager.method_46762(class_7924.field_41252)));
            }
            catch (Exception e) {
                FzmmClient.LOGGER.warn("[FzmmItemGroup] Failed to add OminousBanner", (Throwable)e);
            }
            class_1799 elytra = new class_1799((class_1935)class_1802.field_8833);
            elytra.method_7974(elytra.method_7936() - 1);
            newEntries.add(elytra);
            entries.addAfter((class_1935)class_1802.field_8688, newEntries);
        });
        class_1761 usefulBlockStatesItemGroup = FabricItemGroup.builder().method_47321((class_2561)class_2561.method_43471((String)USEFUL_BLOCK_STATES_BASE_TRANSLATION_KEY)).method_47320(() -> new class_1799((class_1935)class_1802.field_8230)).method_47317((displayContext, entries) -> {
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_8230, "litRedstoneLamp").add("lit", true).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_8732, "litFurnace").add("lit", true).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_16309, "litSmoker").add("lit", true).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_16306, "litBlastFurnace").add("lit", true).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_17346, "offCampfire").add("lit", false).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_17346, "signalFireOfCampfire").add("signal_fire", true).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_23842, "offSoulCampfire").add("lit", false).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_23842, "signalFireOfSoulCampfire").add("signal_fire", true).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_8270, "snowyGrassBlock").add("snowy", true).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_8610, "snowyMycelium").add("snowy", true).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_8382, "snowyPodzol").add("snowy", true).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_8749, "snowBlock").add("layers", 8).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_16307, "openBarrel").add("open", true).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_8241, "openIronTrapdoor").add("open", true).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_8594, "openIronDoor").add("open", true).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_8827, "endPortalFrameWithEye").add("eye", true).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_16539, "hangingLantern").add("hanging", true).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_16539, "lanternOnTheFloor").add("hanging", false).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_22016, "hangingSoulLantern").add("hanging", true).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_22016, "soulLanternOnTheFloor").add("hanging", false).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_37508, "hangingMangrovePropagule").add("hanging", true).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_17530, "fullComposter").add("level", 8).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_23141, "fullRespawnAnchor").add("charges", 4).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_8648, "bambooWithLeaves").add("leaves", "large").get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_8317, "fullGrownWheat").add("age", 7).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_46249, "fullGrownPumpkin").add("age", 7).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_46250, "fullGrownMelon").add("age", 7).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_8179, "fullGrownCarrot").add("age", 7).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_8567, "fullGrownPotatoes").add("age", 7).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_8309, "fullGrownBeetroots").add("age", 3).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_8116, "fullGrownCocoa").add("age", 2).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_28659, "glowBerries").add("berries", true).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_8619, "repeaterTicks.2").add("delay", 2).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_8619, "repeaterTicks.3").add("delay", 3).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_8619, "repeaterTicks.4").add("delay", 4).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_8619, "lockedRepeater").add("locked", true).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_8239, "disabledHopper").add("enabled", false).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_20415, "beeNestFilledWithHoney").add("honey_level", 5).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_20416, "beehiveFilledWithHoney").add("honey_level", 5).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_17498, "seaPickle4").add("pickles", 4).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_8618, "turtleEgg4").add("eggs", 4).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_17534, "sliceOfCake").add("bites", 6).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_8626, "unstableTnt").add("unstable", true).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_8725, "poweredRedstone").add("power", 15).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_37525, "sculkCatalystBloom").add("bloom", true).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_37538, "sculkShriekerCanSummon").add("can_summon", true).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_37538, "sculkShriekerLocked").add("shrieking", true).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_28409, "glowLichenBlock").add("down", true).add("east", true).add("north", true).add("south", true).add("up", true).add("west", true).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_37524, "sculkVeinBlock").add("down", true).add("east", true).add("north", true).add("south", true).add("up", true).add("west", true).get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_8106, "leftChest").add("type", "left").get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_8106, "rightChest").add("type", "right").get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_8247, "leftTrappedChest").add("type", "left").get());
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_8247, "rightTrappedChest").add("type", "right").get());
            FzmmItemGroup.addHalfDoors(entries);
            FzmmItemGroup.addTallFlowers(entries);
            FzmmItemGroup.addLeaves(entries);
            FzmmItemGroup.addLitCandles(entries);
            FzmmItemGroup.addHalfBed(entries);
            FzmmItemGroup.addLockedBed(entries);
            entries.method_45420(new BlockStateItemBuilder(class_1802.field_37513, "waterloggedMangroveRoots").add("waterlogged", true).get());
            FzmmItemGroup.addWaterloggedBlocks(entries);
        }).method_47324();
        class_1761 lootChestsItemGroup = FabricItemGroup.builder().method_47321((class_2561)class_2561.method_43471((String)"itemGroup.fzmm.loot_chests")).method_47320(() -> new class_1799((class_1935)class_1802.field_8106)).method_47317((displayContext, entries) -> {
            List<class_5321<class_52>> lootTablesPath = class_39.method_270().stream().sorted(Comparator.comparing(t -> t.method_29177().method_12832())).collect(Collectors.toList());
            List<class_5321<class_52>> archeologyLootTablesPath = class_39.method_270().stream().sorted(Comparator.comparing(t -> t.method_29177().method_12832())).collect(Collectors.toList());
            archeologyLootTablesPath.removeIf(lootTable -> !lootTable.method_29177().method_12832().startsWith("archaeology"));
            lootTablesPath.removeIf(lootTable -> lootTable.method_29177().method_12832().startsWith("entities"));
            lootTablesPath.removeIf(archeologyLootTablesPath::contains);
            FzmmItemGroup.addLootChest(entries, class_1802.field_42689, archeologyLootTablesPath, true);
            FzmmItemGroup.addLootChest(entries, class_1802.field_43191, archeologyLootTablesPath, true);
            FzmmItemGroup.addLootChest(entries, class_1802.field_8106, lootTablesPath, false);
        }).method_47324();
        class_2378.method_10230((class_2378)class_7923.field_44687, (class_2960)USEFUL_BLOCK_STATES_IDENTIFIER, (Object)usefulBlockStatesItemGroup);
        class_2378.method_10230((class_2378)class_7923.field_44687, (class_2960)LOOT_CHESTS_IDENTIFIER, (Object)lootChestsItemGroup);
    }

    private static void addSpawnEggs(List<class_1799> entries) {
        Predicate<class_1799> hasGroup = stack -> {
            for (class_1761 group : class_7923.field_44687) {
                if (!group.method_45412(stack)) continue;
                return true;
            }
            return false;
        };
        for (class_1792 item : class_7923.field_41178) {
            if (!(item instanceof class_1826) || hasGroup.test(item.method_7854())) continue;
            entries.add(item.method_7854());
        }
    }

    private static void addArmorStand(List<class_1799> entries) {
        String baseTranslation = "armorStand.";
        class_1799 armorStandWithArms = ArmorStandBuilder.builder().setShowArms().getItem((class_2561)FzmmUtils.disableItalicConfig(class_2561.method_43471((String)("itemGroup.op." + baseTranslation + "arms")), true));
        entries.add(armorStandWithArms);
        class_1799 smallArmorStand = ArmorStandBuilder.builder().setSmall().getItem((class_2561)FzmmUtils.disableItalicConfig(class_2561.method_43471((String)("itemGroup.op." + baseTranslation + "small")), true));
        entries.add(smallArmorStand);
        class_1799 smallArmorStandWithArms = ArmorStandBuilder.builder().setSmall().setShowArms().getItem((class_2561)FzmmUtils.disableItalicConfig(class_2561.method_43471((String)("itemGroup.op." + baseTranslation + "smallWithArms")), true));
        entries.add(smallArmorStandWithArms);
    }

    private static void addItemFrames(List<class_1799> entries) {
        class_1799 itemFrame = new class_1799((class_1935)class_1802.field_8143);
        class_1799 glowItemFrame = new class_1799((class_1935)class_1802.field_28408);
        class_2487 entityTag = new class_2487();
        entityTag.method_10556("Invisible", true);
        itemFrame.method_57368(class_9334.field_49609, null, nbtComponent -> {
            class_2487 result = entityTag.method_10553();
            result.method_10582("id", class_7923.field_41177.method_10221((Object)class_1299.field_6043).method_12832());
            return class_9279.method_57456((class_2487)result);
        });
        glowItemFrame.method_57368(class_9334.field_49609, null, nbtComponent -> {
            class_2487 result = entityTag.method_10553();
            result.method_10582("id", class_7923.field_41177.method_10221((Object)class_1299.field_28401).method_12832());
            return class_9279.method_57456((class_2487)result);
        });
        itemFrame.method_57368(class_9334.field_49631, null, component -> {
            class_5250 translation = class_2561.method_43471((String)"itemGroup.op.invisibleItemFrame");
            return FzmmUtils.disableItalicConfig(translation.getString(), true);
        });
        glowItemFrame.method_57368(class_9334.field_49631, null, component -> {
            class_5250 translation = class_2561.method_43471((String)"itemGroup.op.invisibleGlowItemFrame");
            return FzmmUtils.disableItalicConfig(translation.getString(), true);
        });
        entries.add(itemFrame);
        entries.add(glowItemFrame);
    }

    private static void addNameTags(List<class_1799> entries) {
        int LORE_COLOR = 2018273;
        entries.add(DisplayBuilder.builder().item(class_1802.field_8448).setName("").addLore(FzmmItemGroup.getNameTagTranslation("empty", 1), 2018273).get());
        entries.add(DisplayBuilder.builder().item(class_1802.field_8448).setName("Dinnerbone").addLore(FzmmItemGroup.getNameTagTranslation("dinnerbone", 1), 2018273).get());
        entries.add(DisplayBuilder.builder().item(class_1802.field_8448).setName("Grumm").addLore(FzmmItemGroup.getNameTagTranslation("grumm", 1), 2018273).get());
        entries.add(DisplayBuilder.builder().item(class_1802.field_8448).setName("Toast").addLore(FzmmItemGroup.getNameTagTranslation("toast", 1), 2018273).addLore(FzmmItemGroup.getNameTagTranslation("toast", 2), 2018273).get());
        entries.add(DisplayBuilder.builder().item(class_1802.field_8448).setName("jeb_").addLore(FzmmItemGroup.getNameTagTranslation("jeb_", 1), 2018273).addLore(FzmmItemGroup.getNameTagTranslation("jeb_", 2), 2018273).get());
        entries.add(DisplayBuilder.builder().item(class_1802.field_8448).setName("Johnny").addLore(FzmmItemGroup.getNameTagTranslation("johnny", 1), 2018273).addLore(FzmmItemGroup.getNameTagTranslation("johnny", 2), 2018273).addLore(FzmmItemGroup.getNameTagTranslation("johnny", 3), 2018273).get());
    }

    private static String getNameTagTranslation(String value, int line) {
        String baseTranslation = "nameTag.";
        String commentTranslation = ".comment.";
        return class_2561.method_43471((String)("itemGroup.op." + baseTranslation + value + commentTranslation + line)).getString();
    }

    private static void addCrossbows(List<class_1799> entries) {
        CrossbowBuilder crossbowArrow = CrossbowBuilder.builder().putProjectile(new class_1799((class_1935)class_1802.field_8107));
        entries.add(crossbowArrow.get());
        class_1799 firework = new class_1799((class_1935)class_1802.field_8639);
        firework.method_57368(class_9334.field_49616, null, component -> new class_9284(2, new ArrayList()));
        CrossbowBuilder crossbowFirework = CrossbowBuilder.builder().putProjectile(firework);
        entries.add(crossbowFirework.get());
    }

    private static void addLeaves(class_1761.class_7704 entries) {
        class_2073 predicate = FzmmItemGroup.itemPredicate((class_6862<class_1792>)class_3489.field_15558);
        for (class_1792 item : class_7923.field_41178) {
            if (!predicate.method_8970(new class_1799((class_1935)item))) continue;
            entries.method_45420(new BlockStateItemBuilder(item, "nonPersistentLeaves", item).add("persistent", false).get());
        }
    }

    private static void addHalfDoors(class_1761.class_7704 entries) {
        class_2073 predicate = FzmmItemGroup.itemPredicate((class_6862<class_1792>)class_3489.field_15553);
        for (class_1792 item : class_7923.field_41178) {
            if (!predicate.method_8970(new class_1799((class_1935)item))) continue;
            FzmmItemGroup.addHalfUpper(entries, item, "halfDoor");
        }
    }

    private static void addTallFlowers(class_1761.class_7704 entries) {
        String suffix = "tallFlowerSelfDestructs";
        class_2073 predicate = FzmmItemGroup.itemPredicate((class_6862<class_1792>)class_3489.field_20343);
        for (class_1792 item : class_7923.field_41178) {
            if (!predicate.method_8970(new class_1799((class_1935)item))) continue;
            FzmmItemGroup.addHalfUpper(entries, item, suffix);
        }
        FzmmItemGroup.addHalfUpper(entries, class_1802.field_8256, suffix);
        FzmmItemGroup.addHalfUpper(entries, class_1802.field_8561, suffix);
        FzmmItemGroup.addHalfUpper(entries, class_1802.field_28658, suffix);
    }

    private static void addHalfUpper(class_1761.class_7704 entries, class_1792 item, String translation) {
        entries.method_45420(new BlockStateItemBuilder(item, translation, item).add("half", "upper").get());
    }

    private static void addLitCandles(class_1761.class_7704 entries) {
        class_2073 predicate = FzmmItemGroup.itemPredicate((class_6862<class_1792>)class_3489.field_26989);
        for (class_1792 item : class_7923.field_41178) {
            if (!predicate.method_8970(new class_1799((class_1935)item))) continue;
            entries.method_45420(new BlockStateItemBuilder(item, "litCandle", item).add("lit", true).get());
        }
    }

    private static void addHalfBed(class_1761.class_7704 entries) {
        class_2073 predicate = FzmmItemGroup.itemPredicate((class_6862<class_1792>)class_3489.field_16444);
        for (class_1792 item : class_7923.field_41178) {
            if (!predicate.method_8970(new class_1799((class_1935)item))) continue;
            entries.method_45420(new BlockStateItemBuilder(item, "bedHeadPart", item).add("part", "head").get());
        }
    }

    private static void addLockedBed(class_1761.class_7704 entries) {
        class_2073 predicate = FzmmItemGroup.itemPredicate((class_6862<class_1792>)class_3489.field_16444);
        for (class_1792 item : class_7923.field_41178) {
            if (!predicate.method_8970(new class_1799((class_1935)item))) continue;
            entries.method_45420(new BlockStateItemBuilder(item, "lockedBed", item).add("occupied", true).get());
        }
    }

    private static void addWaterloggedBlocks(class_1761.class_7704 entries) {
        class_2073 predicate = FzmmItemGroup.itemPredicate((class_6862<class_1792>)class_3489.field_15535);
        for (class_1792 item : class_7923.field_41178) {
            if (!predicate.method_8970(new class_1799((class_1935)item))) continue;
            entries.method_45420(new BlockStateItemBuilder(item, "waterloggedBlock", item).add("type", "double").add("waterlogged", true).get());
        }
    }

    private static class_2073 itemPredicate(class_6862<class_1792> tag) {
        return class_2073.class_2074.method_8973().method_8975(tag).method_8976();
    }

    private static void addLootChest(class_1761.class_7704 entries, class_1792 item, List<class_5321<class_52>> lootTableList, boolean isBrushable) {
        for (class_5321<class_52> lootTable : lootTableList) {
            class_1799 stack = new class_1799((class_1935)item);
            String identifierString = lootTable.method_29177().toString();
            if (isBrushable) {
                stack.method_57368(class_9334.field_49611, (Object)class_9279.field_49302, component -> {
                    class_2487 result = component.method_57461();
                    class_2586.method_38238((class_2487)result, (class_2591)class_2591.field_42780);
                    result.method_10582("LootTable", identifierString);
                    return class_9279.method_57456((class_2487)result);
                });
            } else {
                stack.method_57368(class_9334.field_49626, null, containerLootComponent -> new class_9297(lootTable, 0L));
            }
            stack.method_57368(class_9334.field_49631, null, text -> class_2561.method_43470((String)identifierString));
            entries.method_45420(stack);
        }
    }
}

