/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.builders;

import fzmm.zailer.me.utils.FzmmUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class SignBuilder {
    public static final int MAX_ROWS = 4;
    private class_1799 stack = class_1802.field_8788.method_7854();
    private final List<class_2561> frontTextList = new ArrayList<class_2561>();
    private final class_2487 frontCompound = new class_2487();
    private final List<class_2561> backTextList = new ArrayList<class_2561>();
    private final class_2487 backCompound = new class_2487();
    private boolean isWaxed = false;

    private SignBuilder() {
    }

    public static SignBuilder builder() {
        return new SignBuilder();
    }

    public SignBuilder item(class_1792 item) {
        this.stack = item.method_7854();
        return this;
    }

    public SignBuilder addFrontLine(class_2561 text, int expectedWidth) {
        return this.addLine(this.frontTextList, text, expectedWidth);
    }

    public SignBuilder addBackLine(class_2561 text, int expectedWidth) {
        return this.addLine(this.backTextList, text, expectedWidth);
    }

    private SignBuilder addLine(List<class_2561> list, class_2561 text, int expectedWidth) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        assert (class_310.method_1551().field_1724 != null);
        if (text == null) {
            return this;
        }
        class_5250 textCopy = text.method_27661();
        int spaceCount = 0;
        while (textRenderer.method_27525((class_5348)textCopy) < expectedWidth) {
            textCopy.method_27693(" ");
            ++spaceCount;
        }
        list.add((class_2561)text.method_27661().method_27693(" ".repeat(spaceCount)));
        return this;
    }

    public SignBuilder glowingFront() {
        return this.glowing(this.frontCompound);
    }

    public SignBuilder glowingBack() {
        return this.glowing(this.backCompound);
    }

    private SignBuilder glowing(class_2487 compound) {
        compound.method_10556("has_glowing_text", true);
        return this;
    }

    public SignBuilder colorFront(String color) {
        return this.color(this.frontCompound, color);
    }

    public SignBuilder colorBack(String color) {
        return this.color(this.backCompound, color);
    }

    private SignBuilder color(class_2487 compound, String color) {
        compound.method_10582("color", color);
        return this;
    }

    public SignBuilder wax() {
        this.isWaxed = true;
        return this;
    }

    public class_1799 get() {
        this.stack.method_57368(class_9334.field_49611, (Object)class_9279.field_49302, component -> {
            class_2487 result = component.method_57461();
            class_2586.method_38238((class_2487)result, (class_2591)class_2591.field_11911);
            this.addSignMessage(this.frontTextList, this.frontCompound, result, "front_text");
            this.addSignMessage(this.backTextList, this.backCompound, result, "back_text");
            result.method_10556("is_waxed", this.isWaxed);
            return class_9279.method_57456((class_2487)result);
        });
        return this.stack;
    }

    private void addSignMessage(List<class_2561> list, class_2487 compound, class_2487 blockEntityTag, String key) {
        if (list.isEmpty()) {
            return;
        }
        while (list.size() < 4) {
            list.add((class_2561)class_2561.method_43473());
        }
        class_5455 registryManager = FzmmUtils.getRegistryManager();
        class_2499 listTag = new class_2499();
        listTag.addAll(list.stream().map(text -> {
            String textJson = class_2561.class_2562.method_10867((class_2561)text, (class_7225.class_7874)registryManager);
            return class_2519.method_23256((String)textJson);
        }).toList());
        compound.method_10566("messages", (class_2520)listTag);
        blockEntityTag.method_10566(key, (class_2520)compound);
    }
}

