/*
 * Decompiled with CFR 0.152.
 */
package net.mision_thi.nbttooltips.tooltips;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2509;
import net.minecraft.class_2514;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_6903;
import net.minecraft.class_7876;
import net.minecraft.class_9326;
import net.mision_thi.nbttooltips.NBTtooltipsMod;
import net.mision_thi.nbttooltips.config.ModConfigs;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TooltipChanger {
    public static final class_7876<?> ALL_EQUALITY_OWNER = new class_7876<Object>(){

        public boolean method_46767(class_7876<Object> other) {
            return true;
        }
    };
    private static final class_6903<class_2520> NBT_OPS_UNLIMITED = class_6903.method_40414((DynamicOps)class_2509.field_11560, (class_6903.class_7863)new class_6903.class_7863(){
        private final class_6903.class_7862<?> INFO = new class_6903.class_7862(ALL_EQUALITY_OWNER, null, null);

        public <T> Optional<class_6903.class_7862<T>> method_46623(class_5321<? extends class_2378<? extends T>> registryRef) {
            return Optional.of(this.INFO);
        }
    });

    public static void Main(class_1799 itemStack, List<class_2561> list) {
        class_5250 findText = class_2561.method_43469((String)"item.components", (Object[])new Object[]{itemStack.method_57353().method_57835()}).method_27692(class_124.field_1063);
        int index = list.indexOf(findText);
        if (index == -1) {
            index = Math.max(0, list.size() - 1);
        } else {
            list.remove(index);
        }
        NbtTextBuilder builder = new NbtTextBuilder();
        builder.append((class_2561)class_2561.method_43471((String)"item.nbt_tags.nbttooltips").method_27692(class_124.field_1063));
        builder.buildElement((class_2520)class_9326.field_49589.encodeStart(NBT_OPS_UNLIMITED, (Object)itemStack.method_57380()).getOrThrow());
        list.addAll(index, builder.build());
    }

    private static class NbtTextBuilder {
        private static final Set<List<String>> textPaths = Set.of(List.of("minecraft:custom_data", "display", "Name"), List.of("minecraft:custom_data", "display", "Lore", "[]"), List.of("minecraft:custom_name"), List.of("minecraft:lore", "[]"));
        private final int SPACE_WIDTH;
        private final int lineStep;
        private final class_124 stringColour;
        private final class_124 quotationColour;
        private final class_124 separationColour;
        private final class_124 integerColour;
        private final class_124 typeColour;
        private final class_124 fieldColour;
        private final class_124 lstringColour;
        private final class_2561 SINGLE_QUOTE;
        private final class_2561 DOUBLE_QUOTE;
        private final class_2561 LSTRING;
        private final class_2561 INDENT;
        private final class_2561 SPACE;
        private final class_2561 BRACKET_START;
        private final class_2561 BRACKET_END;
        private final class_2561 SQUARE_BRACKET_START;
        private final class_2561 SQUARE_BRACKET_END;
        private final class_2561 SEPARATOR;
        private final class_2561 COLON;
        private final class_2561 SEMICOLON;
        private final class_2561 BYTE;
        private final class_2561 SHORT;
        private final class_2561 INTEGER;
        private final class_2561 LONG;
        private final class_2561 FLOAT;
        private final Stack<String> stack;
        private final List<List<class_2561>> list;
        private List<class_2561> currentLine;
        private int column;
        private boolean doSpace;
        private boolean ignoreNextSeparator;
        @Nullable
        private List<class_2561> groups;

        @Contract(pure=true)
        private static class_124 colour(@NotNull String colour) {
            return switch (colour) {
                case "black" -> class_124.field_1074;
                case "dark_blue" -> class_124.field_1058;
                case "dark_green" -> class_124.field_1077;
                case "dark_aqua" -> class_124.field_1062;
                case "dark_red" -> class_124.field_1079;
                case "dark_purple" -> class_124.field_1064;
                case "gold" -> class_124.field_1065;
                case "gray" -> class_124.field_1080;
                case "dark_gray" -> class_124.field_1063;
                case "blue" -> class_124.field_1078;
                case "green" -> class_124.field_1060;
                case "aqua" -> class_124.field_1075;
                case "red" -> class_124.field_1061;
                case "light_purple" -> class_124.field_1076;
                case "yellow" -> class_124.field_1054;
                default -> class_124.field_1068;
            };
        }

        @NotNull
        private static class_2561 joinTexts(@NotNull List<class_2561> texts) {
            class_5250 text = class_2561.method_43473();
            for (class_2561 sub : texts) {
                text.method_10852(sub);
            }
            return text;
        }

        private NbtTextBuilder() {
            this.SPACE_WIDTH = NBTtooltipsMod.client.field_1772.method_1727(" ");
            this.lineStep = Math.min(ModConfigs.LINE_LIMIT * 6, NBTtooltipsMod.client.method_22683().method_4486() - 80);
            this.stringColour = NbtTextBuilder.colour(ModConfigs.STRING_COLOUR);
            this.quotationColour = NbtTextBuilder.colour(ModConfigs.QUOTATION_COLOUR);
            this.separationColour = NbtTextBuilder.colour(ModConfigs.SEPARATION_COLOUR);
            this.integerColour = NbtTextBuilder.colour(ModConfigs.INTEGER_COLOUR);
            this.typeColour = NbtTextBuilder.colour(ModConfigs.TYPE_COLOUR);
            this.fieldColour = NbtTextBuilder.colour(ModConfigs.FIELD_COLOUR);
            this.lstringColour = NbtTextBuilder.colour(ModConfigs.LSTRING_COLOUR);
            this.SINGLE_QUOTE = class_2561.method_43470((String)"'").method_27692(this.quotationColour);
            this.DOUBLE_QUOTE = class_2561.method_43470((String)"\"").method_27692(this.quotationColour);
            this.LSTRING = class_2561.method_43473().method_10852(this.DOUBLE_QUOTE).method_10852((class_2561)class_2561.method_43470((String)"....").method_27692(this.lstringColour)).method_10852(this.DOUBLE_QUOTE);
            this.INDENT = class_2561.method_43470((String)"     ");
            this.SPACE = class_2561.method_43470((String)" ").method_27692(this.separationColour);
            this.BRACKET_START = class_2561.method_43470((String)"{").method_27692(this.separationColour);
            this.BRACKET_END = class_2561.method_43470((String)"}").method_27692(this.separationColour);
            this.SQUARE_BRACKET_START = class_2561.method_43470((String)"[").method_27692(this.separationColour);
            this.SQUARE_BRACKET_END = class_2561.method_43470((String)"]").method_27692(this.separationColour);
            this.SEPARATOR = class_2561.method_43470((String)",").method_27692(this.separationColour);
            this.COLON = class_2561.method_43470((String)":").method_27692(this.separationColour);
            this.SEMICOLON = class_2561.method_43470((String)";").method_27692(this.separationColour);
            this.BYTE = class_2561.method_43470((String)"b").method_27692(this.typeColour);
            this.SHORT = class_2561.method_43470((String)"s").method_27692(this.typeColour);
            this.INTEGER = class_2561.method_43470((String)"I").method_27692(this.typeColour);
            this.LONG = class_2561.method_43470((String)"L").method_27692(this.typeColour);
            this.FLOAT = class_2561.method_43470((String)"f").method_27692(this.typeColour);
            this.stack = new Stack();
            this.list = new ArrayList<List<class_2561>>();
            this.column = 0;
            this.doSpace = false;
            this.ignoreNextSeparator = false;
            this.groups = null;
            this.nextLine();
        }

        private void nextLine() {
            this.currentLine = new ArrayList<class_2561>();
            this.list.add(this.currentLine);
            this.column = 0;
        }

        private void groupStart() {
            this.groups = new ArrayList<class_2561>();
        }

        private void groupEnd() {
            if (this.groups != null) {
                class_2561 text = NbtTextBuilder.joinTexts(this.groups);
                this.groups = null;
                this.append(text);
            }
        }

        private NbtTextBuilder appendNoLineBreak(class_2561 text) {
            return this.append(text, false);
        }

        private NbtTextBuilder append(class_2561 text) {
            return this.append(text, true);
        }

        private NbtTextBuilder append(class_2561 text, boolean checkLineBreak) {
            if (this.groups != null) {
                this.groups.add(text);
                return this;
            }
            int length = NBTtooltipsMod.client.field_1772.method_27525((class_5348)text);
            if (checkLineBreak && this.column + (this.doSpace ? this.SPACE_WIDTH : 0) + length >= this.lineStep) {
                this.nextLine();
                this.currentLine.add(this.INDENT);
            }
            if (this.doSpace) {
                if (this.column != 0) {
                    this.currentLine.add(this.SPACE);
                    this.column += this.SPACE_WIDTH;
                }
                this.doSpace = false;
            }
            this.currentLine.add(text);
            this.column += length;
            return this;
        }

        private NbtTextBuilder appendRaw(String str, class_124 format) {
            return this.append((class_2561)class_2561.method_43470((String)str).method_27692(format));
        }

        private void appendField(String str) {
            this.appendRaw(str, this.fieldColour).appendNoLineBreak(this.COLON).space();
        }

        private void arrayHeader(class_2561 type) {
            this.appendNoLineBreak(this.SQUARE_BRACKET_START).appendNoLineBreak(type).appendNoLineBreak(this.SEMICOLON).space().ignoreNextSeparator();
        }

        private void appendString(String str) {
            if (NBTtooltipsMod.client.field_1772.method_1727(str = class_2519.method_10706((String)str)) >= this.lineStep) {
                this.append(this.LSTRING);
            } else {
                class_2561 quote = str.charAt(0) == '\'' ? this.SINGLE_QUOTE : this.DOUBLE_QUOTE;
                this.append((class_2561)class_2561.method_43473().method_10852(quote).method_10852((class_2561)class_2561.method_43470((String)str.substring(1, str.length() - 1)).method_27692(this.stringColour)).method_10852(quote));
            }
        }

        private NbtTextBuilder space() {
            if (this.groups == null) {
                this.doSpace = true;
            } else {
                this.groups.add(this.SPACE);
            }
            return this;
        }

        private void ignoreNextSeparator() {
            this.ignoreNextSeparator = true;
        }

        private NbtTextBuilder separator() {
            if (this.ignoreNextSeparator) {
                this.ignoreNextSeparator = false;
                return this;
            }
            return this.appendNoLineBreak(this.SEPARATOR).space();
        }

        private void appendNumber(String str) {
            this.append((class_2561)class_2561.method_43470((String)str).method_27692(this.integerColour));
        }

        private void appendNumber(String str, class_2561 unit) {
            this.append((class_2561)class_2561.method_43473().method_27693(str).method_27692(this.integerColour).method_10852(unit));
        }

        private void append(byte num) {
            this.appendNumber(Byte.toString(num), this.BYTE);
        }

        private void append(short num) {
            this.appendNumber(Short.toString(num), this.SHORT);
        }

        private void append(int num) {
            this.appendNumber(Integer.toString(num));
        }

        private void append(long num) {
            this.appendNumber(Long.toString(num), this.LONG);
        }

        private void append(float num) {
            this.appendNumber(Float.toString(num), this.FLOAT);
        }

        private void append(double num) {
            this.appendNumber(Double.toString(num));
        }

        public void buildElement(class_2520 element) {
            if (element == null) {
                this.appendRaw("null", this.typeColour);
                return;
            }
            switch (element.method_10711()) {
                case 1: {
                    this.append(((class_2481)element).method_10698());
                    break;
                }
                case 2: {
                    this.append(((class_2516)element).method_10696());
                    break;
                }
                case 3: {
                    this.append(((class_2497)element).method_10701());
                    break;
                }
                case 4: {
                    this.append(((class_2503)element).method_10699());
                    break;
                }
                case 5: {
                    this.append(((class_2494)element).method_10700());
                    break;
                }
                case 6: {
                    this.append(((class_2489)element).method_10697());
                    break;
                }
                case 99: {
                    this.appendNumber(((class_2514)element).method_10702().toString());
                    break;
                }
                case 8: {
                    this.appendString(textPaths.contains(this.stack) ? element.method_10714().replaceAll("(?<=[,{])\"(?:bold|italic|underlined|strikethrough|obfuscated)\":false,", "").replaceAll(",\"underlined\":false(?=})", "") : element.method_10714());
                    break;
                }
                case 10: {
                    class_2487 compound = (class_2487)element;
                    this.appendNoLineBreak(this.BRACKET_START).ignoreNextSeparator();
                    for (String key : compound.method_10541()) {
                        class_2520 e = compound.method_10580(key);
                        this.separator();
                        if (e instanceof class_2514) {
                            this.groupStart();
                        }
                        this.appendField(key.replaceFirst("^minecraft:", "mc:"));
                        this.stack.push(key);
                        this.buildElement(e);
                        this.stack.pop();
                        this.groupEnd();
                    }
                    this.append(this.BRACKET_END);
                    break;
                }
                case 9: {
                    this.appendNoLineBreak(this.SQUARE_BRACKET_START).ignoreNextSeparator();
                    this.stack.push("[]");
                    for (class_2520 e : (class_2499)element) {
                        this.separator().buildElement(e);
                    }
                    this.stack.pop();
                    this.append(this.SQUARE_BRACKET_END);
                    break;
                }
                case 7: {
                    this.arrayHeader(this.BYTE);
                    for (class_2481 e : (class_2479)element) {
                        this.separator().append(e.method_10698());
                    }
                    this.append(this.SQUARE_BRACKET_END);
                    break;
                }
                case 11: {
                    this.arrayHeader(this.INTEGER);
                    for (class_2497 e : (class_2495)element) {
                        this.separator().append(e.method_10701());
                    }
                    this.append(this.SQUARE_BRACKET_END);
                    break;
                }
                case 12: {
                    this.arrayHeader(this.LONG);
                    for (class_2503 e : (class_2501)element) {
                        this.separator().append(e.method_10699());
                    }
                    this.append(this.SQUARE_BRACKET_END);
                    break;
                }
                case 0: {
                    this.appendRaw("end", this.typeColour);
                    break;
                }
                default: {
                    this.appendRaw(element.method_10714(), class_124.field_1061);
                }
            }
        }

        public List<class_2561> build() {
            return this.list.stream().map(NbtTextBuilder::joinTexts).toList();
        }
    }
}

