/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.client.network;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.github.thecsdev.tcdcommons.TCDCommons;
import io.github.thecsdev.tcdcommons.api.badge.PlayerBadge;
import io.github.thecsdev.tcdcommons.api.badge.PlayerBadgeHandler;
import io.github.thecsdev.tcdcommons.api.client.badge.ClientPlayerBadge;
import io.github.thecsdev.tcdcommons.api.client.network.PlayerBadgeNetworkListener;
import io.github.thecsdev.tcdcommons.api.hooks.entity.EntityHooks;
import io.github.thecsdev.tcdcommons.api.network.CustomPayloadNetworkReceiver;
import io.github.thecsdev.tcdcommons.api.network.packet.TCustomPayload;
import io.github.thecsdev.tcdcommons.api.registry.TRegistries;
import io.github.thecsdev.tcdcommons.api.util.collections.GenericProperties;
import io.github.thecsdev.tcdcommons.api.util.thread.TaskScheduler;
import io.github.thecsdev.tcdcommons.client.TCDCommonsClient;
import io.github.thecsdev.tcdcommons.mixin.hooks.AccessorCustomPayloadNetwork;
import io.github.thecsdev.tcdcommons.network.TCDCommonsNetwork;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2547;
import net.minecraft.class_2596;
import net.minecraft.class_2598;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_746;
import net.minecraft.class_8710;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class TcdcClientPlayNetworkHandler {
    private static final class_2960 CUSTOM_DATA_ID = class_2960.method_60655((String)TCDCommons.getModID(), (String)"client_play_network_handler");
    private final class_746 player;
    private long nextC2SFracturedCpnPacketId = 0L;
    private final Cache<Long, TCustomPayload> fracturedS2CCpnPackets;

    private TcdcClientPlayNetworkHandler(class_746 player) throws NullPointerException {
        this.player = Objects.requireNonNull(player);
        this.fracturedS2CCpnPackets = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
        TaskScheduler.schedulePeriodicCacheCleanup(this.fracturedS2CCpnPackets);
    }

    public final class_746 getPlayer() {
        return this.player;
    }

    public final long nextC2SFracturedCpnPacketId() {
        this.nextC2SFracturedCpnPacketId = Math.max(this.nextC2SFracturedCpnPacketId + 1L, 1L);
        return this.nextC2SFracturedCpnPacketId;
    }

    public final void onCustomPayloadNetwork(TCustomPayload payload) {
        final class_2960 packetId = payload.getPacketId();
        final class_2540 packetData = new class_2540(payload.getPacketPayload());
        CustomPayloadNetworkReceiver handler = AccessorCustomPayloadNetwork.getPlayS2C().getOrDefault(packetId, null);
        if (handler == null) {
            return;
        }
        handler.receiveCustomPayload(new CustomPayloadNetworkReceiver.PacketContext(){

            public class_746 getPlayer() {
                return TcdcClientPlayNetworkHandler.this.player;
            }

            @Override
            public class_2547 getPacketListener() {
                return TcdcClientPlayNetworkHandler.this.player.field_3944;
            }

            @Override
            public class_2598 getNetworkSide() {
                return class_2598.field_11942;
            }

            @Override
            public class_2960 getPacketId() {
                return packetId;
            }

            @Override
            public class_2540 getPacketBuffer() {
                return packetData;
            }
        });
    }

    public final void onFracturedCustomPayloadNetwork(CustomPayloadNetworkReceiver.PacketContext context) {
        TCDCommonsNetwork.handleFracturedCpnPacket(context, this.fracturedS2CCpnPackets, this::onCustomPayloadNetwork);
    }

    public final void onPlayerBadges(CustomPayloadNetworkReceiver.PacketContext context) {
        class_2540 payload = context.getPacketBuffer();
        PlayerBadgeHandler statHandler = ClientPlayerBadge.getClientPlayerBadgeHandler(this.player);
        int badgeCount = payload.readInt();
        for (int index = 0; index < badgeCount && payload.readableBytes() >= 2; ++index) {
            class_2960 badgeId = payload.method_10810();
            int badgeValue = payload.method_10816();
            @Nullable PlayerBadge badge = TRegistries.PLAYER_BADGE.getValue(badgeId).orElse(null);
            if (badge == null || badge instanceof ClientPlayerBadge) continue;
            statHandler.setValue(badgeId, badgeValue);
        }
        TCDCommonsClient.MC_CLIENT.method_40000(() -> {
            class_437 currentScreen = TCDCommonsClient.MC_CLIENT.field_1755;
            if (currentScreen instanceof PlayerBadgeNetworkListener) {
                PlayerBadgeNetworkListener listener = (PlayerBadgeNetworkListener)currentScreen;
                listener.onPlayerBadgesReady();
            }
        });
    }

    public final void sendCustomPayloadNetwork(class_2960 packetId, ByteBuf packetData) throws IllegalStateException, NullPointerException {
        Objects.requireNonNull(packetId);
        Objects.requireNonNull(packetData);
        if (packetData.refCnt() < 1) {
            throw new IllegalStateException("REF_CNT");
        }
        TCustomPayload payload = new TCustomPayload(packetId, packetData);
        if (packetData.readableBytes() > 5120) {
            TCDCommonsNetwork.sendFracturedCpnPacket(payload, this.nextC2SFracturedCpnPacketId(), fp -> this.player.field_3944.method_52787((class_2596)new class_2817((class_8710)fp)));
            return;
        }
        this.player.field_3944.method_52787((class_2596)new class_2817((class_8710)payload));
    }

    public static final TcdcClientPlayNetworkHandler of(class_746 player) throws NullPointerException {
        GenericProperties<class_2960> cd = EntityHooks.getCustomData((class_1297)Objects.requireNonNull(player));
        @Nullable TcdcClientPlayNetworkHandler cpnh = (TcdcClientPlayNetworkHandler)cd.getProperty(CUSTOM_DATA_ID);
        if (cpnh == null) {
            cpnh = new TcdcClientPlayNetworkHandler(player);
            cd.setProperty(CUSTOM_DATA_ID, cpnh);
        }
        return cpnh;
    }
}

