/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.util.collections;

import com.google.common.annotations.Beta;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Beta
public final class WeakCollection<E>
extends AbstractCollection<E> {
    protected final LinkedList<WeakReference<E>> list = new LinkedList();

    public final int cleanUp() {
        int i = 0;
        ListIterator listIter = this.list.listIterator();
        while (listIter.hasNext()) {
            WeakReference item = (WeakReference)listIter.next();
            if (item.get() != null) continue;
            listIter.remove();
            ++i;
        }
        return i;
    }

    public final int garbageSize() {
        int i = 0;
        for (WeakReference weakReference : this.list) {
            if (weakReference.get() != null) continue;
            ++i;
        }
        return i;
    }

    @Override
    public final boolean contains(Object o) {
        for (E item : this) {
            if (!Objects.equals(item, o)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Virtual
    public boolean add(E e) {
        this.cleanUp();
        return this.list.add(new WeakReference<E>(e));
    }

    @Override
    public final int size() {
        this.cleanUp();
        return this.list.size();
    }

    @Override
    public final void clear() {
        this.list.clear();
    }

    @Override
    public final Iterator<E> iterator() {
        return this.listIterator();
    }

    public final ListIterator<E> listIterator() {
        return new WcIterator();
    }

    private class WcIterator
    implements ListIterator<E> {
        protected final ListIterator<WeakReference<E>> listItr;

        protected WcIterator() {
            this.listItr = WeakCollection.this.list.listIterator();
        }

        @Override
        public final boolean hasNext() {
            return this.listItr.hasNext();
        }

        @Override
        @Nullable
        public final E next() {
            return this.listItr.next().get();
        }

        @Override
        public final boolean hasPrevious() {
            return this.listItr.hasPrevious();
        }

        @Override
        @Nullable
        public final E previous() {
            return this.listItr.previous().get();
        }

        @Override
        public final int nextIndex() {
            return this.listItr.nextIndex();
        }

        @Override
        public final int previousIndex() {
            return this.listItr.previousIndex();
        }

        @Override
        public final void remove() {
            this.listItr.remove();
        }

        @Override
        public final void set(E e) {
            this.listItr.set(new WeakReference(e));
        }

        @Override
        public final void add(E e) {
            this.listItr.add(new WeakReference(e));
        }
    }
}

