/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.panel.explorer.impl;

import io.github.thecsdev.tcdcommons.api.client.gui.panel.explorer.AbstractFileListPanel;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.explorer.impl.TFileExplorerPanel;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TTextFieldWidget;
import io.github.thecsdev.tcdcommons.api.util.interfaces.TFileFilter;
import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
final class FileListPanelProxyImpl
implements AbstractFileListPanel.FileListPanelProxy {
    protected final TFileExplorerPanel explorer;
    protected final TFileExplorerPanel.FileExplorerPanelProxy proxy;

    protected FileListPanelProxyImpl(TFileExplorerPanel explorer) {
        this.explorer = Objects.requireNonNull(explorer);
        this.proxy = Objects.requireNonNull(explorer.proxy);
    }

    @Override
    public Path getCurrentPath() {
        return this.proxy.getCurrentDirectory();
    }

    @Override
    public TFileFilter getCurrentFileFilter() {
        return this.proxy.getSelectedFileFilter();
    }

    @Override
    public void onPathSelected(Path selectedPath) {
        try {
            File file = selectedPath.toFile();
            switch (this.explorer.type) {
                case SELECT_DIRECTORY: {
                    if (file.isDirectory()) {
                        this.navigateToPath(selectedPath);
                    }
                    break;
                }
                default: {
                    if (file.isDirectory()) {
                        this.navigateToPath(selectedPath);
                        break;
                    }
                    String fileName = file.getName();
                    TTextFieldWidget nameInput = this.explorer.actionBar.getFileNameInput();
                    if (!Objects.equals(nameInput.getInput(), fileName)) {
                        nameInput.setInput(fileName);
                        break;
                    }
                    this.explorer.completeAsApprove(file);
                    break;
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private final void navigateToPath(Path selectedPath) {
        this.proxy.setCurrentDirectory(selectedPath);
        this.explorer.refresh();
    }
}

