/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui;

import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.TElementList;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TDrawContext;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TInputContext;
import io.github.thecsdev.tcdcommons.api.util.interfaces.IEnableStateProvider;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface TParentElement
extends IEnableStateProvider {
    public static final int MAX_CHILD_NESTING_DEPTH = 16;

    public int getX();

    public int getY();

    public int getWidth();

    public int getHeight();

    default public int getEndX() {
        return this.getX() + this.getWidth();
    }

    default public int getEndY() {
        return this.getY() + this.getHeight();
    }

    public void render(TDrawContext var1);

    default public float getZIndex() {
        return 0.0f;
    }

    default public boolean input(TInputContext inputContext) {
        return false;
    }

    default public boolean input(TInputContext inputContext, TInputContext.InputDiscoveryPhase inputPhase) {
        return false;
    }

    @Nullable
    public TParentElement getParent();

    public TElementList getChildren();

    default public boolean addChild(TElement child) {
        return this.getChildren().add(child);
    }

    default public boolean addChild(TElement child, boolean reposition) {
        return this.getChildren().add(child, reposition);
    }

    default public boolean removeChild(TElement child) {
        return this.getChildren().remove(child);
    }

    default public boolean removeChild(TElement child, boolean reposition) {
        return this.getChildren().remove(child, reposition);
    }

    default public void clearChildren() {
        this.getChildren().clear();
    }

    default public boolean isEnabled() {
        return this.getEnabled() && (this.getParent() == null || this.getParent().isEnabled());
    }

    @Override
    default public boolean getEnabled() {
        return true;
    }

    @Nullable
    default public TParentElement findParent(Predicate<TParentElement> predicate) {
        for (TParentElement parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!predicate.test(parent)) continue;
            return parent;
        }
        return null;
    }

    @Nullable
    default public TElement findParentTElement(Predicate<TElement> predicate) {
        for (TParentElement parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof TElement) || !predicate.test((TElement)parent)) continue;
            return (TElement)parent;
        }
        return null;
    }

    default public void forEachChild(Consumer<TElement> action, boolean nested) {
        this.findChild(child -> {
            if (action != null) {
                action.accept((TElement)child);
            }
            return false;
        }, nested);
    }

    @Nullable
    default public TElement findChild(Predicate<TElement> predicate, boolean nested) {
        return TParentElement.__findChild(this, predicate, nested, 0);
    }

    @ApiStatus.Internal
    @Nullable
    private static TElement __findChild(TParentElement parent, Predicate<TElement> predicate, boolean nested, int iteration) {
        if (iteration > 16) {
            return null;
        }
        for (TElement child : parent.getChildren()) {
            TElement nestedFind;
            child.__updateParent(parent);
            if (predicate != null && predicate.test(child)) {
                return child;
            }
            if (!nested || (nestedFind = TParentElement.__findChild(child, predicate, true, iteration + 1)) == null) continue;
            return nestedFind;
        }
        return null;
    }

    @Nullable
    default public TElement findLastChild(Predicate<TElement> predicate, boolean nested) {
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        this.forEachChild(child -> {
            if (predicate.test((TElement)child)) {
                result.set(child);
            }
        }, nested);
        return result.get();
    }
}

