/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.util;

import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.util.Image;
import com.tom.cpm.shared.definition.SafetyException;
import com.tom.cpm.shared.editor.EditorTexture;
import com.tom.cpm.shared.skin.TextureProvider;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class TextureStitcher {
    private Image image;
    private Map<Image, Box> images = new HashMap<Image, Box>();
    private Set<Box> usedSpaces;
    private Vec2i size;
    private boolean hasStitches = false;
    private TextureProvider provider;
    private float xs;
    private float ys;
    private int maxSize;
    private boolean overflow;

    public TextureStitcher(int maxSize) {
        this.maxSize = maxSize;
    }

    public void setBase(Image base) {
        this.image = new Image(base);
        this.size = new Vec2i(64, 64);
        this.usedSpaces = new HashSet<Box>();
        this.usedSpaces.add(new Box(0, 0, 64, 64));
        this.xs = 1.0f;
        this.ys = 1.0f;
        this.provider = null;
    }

    public void setBase(TextureProvider provider) {
        this.image = new Image(provider.getImage());
        this.size = provider.size;
        this.usedSpaces = new HashSet<Box>();
        Box b = new Box(0, 0, provider.size.x, provider.size.y);
        this.usedSpaces.add(b);
        this.images.put(provider.getImage(), b);
        this.xs = (float)provider.getImage().getWidth() / (float)provider.size.x;
        this.ys = (float)provider.getImage().getHeight() / (float)provider.size.y;
        this.provider = provider;
    }

    public void stitchImage(EditorTexture provider) {
        this.stitchImage(provider, (Vec2i uv) -> {
            provider.stitchPos = new Box(uv.x, uv.y, provider.getImage().getWidth(), provider.getImage().getHeight());
        });
    }

    public void stitchImage(TextureProvider provider, Consumer<Vec2i> uvUpdater) {
        float xs = (float)provider.getImage().getWidth() / (float)provider.size.x;
        float ys = (float)provider.getImage().getHeight() / (float)provider.size.y;
        this.stitchImage(provider.getImage(), (Vec2i uv) -> {
            if (uvUpdater != null) {
                uvUpdater.accept(new Vec2i((float)uv.x / xs, (float)uv.y / ys));
            }
        });
    }

    public void stitchImage(Image img, Consumer<Vec2i> uvUpdater) {
        if (this.overflow) {
            return;
        }
        Box b = new Box(0, 0, img.getWidth(), img.getHeight());
        this.hasStitches = true;
        int i = 0;
        while (i < this.maxSize) {
            b.x = i;
            int y = 0;
            while (y < i) {
                b.y = y;
                if (this.usedSpaces.stream().noneMatch(u -> u.intersects(b))) {
                    this.usedSpaces.add(b);
                    this.checkImageSize(b);
                    this.image.draw(img, b.x, b.y);
                    this.images.put(img, b);
                    if (uvUpdater != null) {
                        uvUpdater.accept(new Vec2i(b.x, b.y));
                    }
                    return;
                }
                y = (int)((float)y + 16.0f * this.ys);
            }
            b.y = i;
            int x = 0;
            while (x < i) {
                b.x = x;
                if (this.usedSpaces.stream().noneMatch(u -> u.intersects(b))) {
                    this.usedSpaces.add(b);
                    this.checkImageSize(b);
                    this.image.draw(img, b.x, b.y);
                    this.images.put(img, b);
                    if (uvUpdater != null) {
                        uvUpdater.accept(new Vec2i((float)b.x / this.xs, (float)b.y / this.ys));
                    }
                    return;
                }
                x = (int)((float)x + 16.0f * this.xs);
            }
            i = (int)((float)i + 16.0f * this.xs);
        }
        this.overflow = true;
    }

    public void allocSingleColor(Vec2i size, int color, Consumer<Vec2i> uvUpdater) {
        Image img = new Image(size.x, size.y);
        img.fill(color);
        this.stitchImage(img, uvUpdater);
    }

    public void checkImageSize(Box box) {
        if (this.image.getWidth() < box.x + box.w || this.image.getHeight() < box.y + box.h) {
            Image newImg = new Image(Math.max(TextureStitcher.smallestEncompassingPowerOfTwo(box.x + box.w), this.image.getWidth()), Math.max(TextureStitcher.smallestEncompassingPowerOfTwo(box.y + box.h), this.image.getHeight()));
            newImg.draw(this.image);
            this.image = newImg;
        }
    }

    public static int smallestEncompassingPowerOfTwo(int value) {
        int i = value - 1;
        i |= i >> 1;
        i |= i >> 2;
        i |= i >> 4;
        i |= i >> 8;
        i |= i >> 16;
        return i + 1;
    }

    public TextureProvider finish() throws SafetyException {
        if (this.overflow) {
            throw new SafetyException(SafetyException.BlockReason.TEXTURE_OVERFLOW);
        }
        if (this.hasStitches) {
            return new TextureProvider(this.image, new Vec2i((float)this.image.getWidth() / this.xs, (float)this.image.getHeight() / this.ys));
        }
        return this.provider;
    }

    public void finish(TextureProvider provider) {
        provider.setImage(this.image);
        provider.size = new Vec2i((float)this.image.getWidth() / this.xs, (float)this.image.getHeight() / this.ys);
    }

    public boolean hasStitches() {
        return this.hasStitches;
    }

    public boolean refresh(Image img) {
        Box box = this.images.get(img);
        if (box == null) {
            return false;
        }
        this.image.draw(img, box.x, box.y);
        return true;
    }
}

