/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.UI;
import com.tom.cpl.gui.elements.MessagePopup;
import com.tom.cpl.tag.TagType;
import com.tom.cpl.text.FormatText;
import com.tom.cpl.util.Image;
import com.tom.cpl.util.ThrowingConsumer;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.definition.Link;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.ExportException;
import com.tom.cpm.shared.editor.ExporterImpl;
import com.tom.cpm.shared.editor.anim.AnimatedTex;
import com.tom.cpm.shared.editor.anim.EditorAnim;
import com.tom.cpm.shared.editor.elements.ElementType;
import com.tom.cpm.shared.editor.elements.ModelElement;
import com.tom.cpm.shared.editor.gui.popup.AnimEncConfigPopup;
import com.tom.cpm.shared.editor.gui.popup.ExportStringResultPopup;
import com.tom.cpm.shared.editor.gui.popup.OverflowPopup;
import com.tom.cpm.shared.editor.tags.EditorTagManager;
import com.tom.cpm.shared.editor.template.EditorTemplate;
import com.tom.cpm.shared.editor.tree.TreeElement;
import com.tom.cpm.shared.editor.util.ExportHelper;
import com.tom.cpm.shared.editor.util.ModelDescription;
import com.tom.cpm.shared.effects.EffectColor;
import com.tom.cpm.shared.effects.EffectCopyTransform;
import com.tom.cpm.shared.effects.EffectDisableVanilla;
import com.tom.cpm.shared.effects.EffectExtrude;
import com.tom.cpm.shared.effects.EffectFirstPersonHandPos;
import com.tom.cpm.shared.effects.EffectGlow;
import com.tom.cpm.shared.effects.EffectHide;
import com.tom.cpm.shared.effects.EffectHideSkull;
import com.tom.cpm.shared.effects.EffectInvisGlow;
import com.tom.cpm.shared.effects.EffectModelScale;
import com.tom.cpm.shared.effects.EffectPerFaceUV;
import com.tom.cpm.shared.effects.EffectRemoveArmorOffset;
import com.tom.cpm.shared.effects.EffectRemoveBedOffset;
import com.tom.cpm.shared.effects.EffectRenderItem;
import com.tom.cpm.shared.effects.EffectScale;
import com.tom.cpm.shared.effects.EffectScaling;
import com.tom.cpm.shared.effects.EffectSingleTexture;
import com.tom.cpm.shared.effects.EffectUV;
import com.tom.cpm.shared.io.ChecksumOutputStream;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.io.ModelFile;
import com.tom.cpm.shared.io.SkinDataOutputStream;
import com.tom.cpm.shared.model.Cube;
import com.tom.cpm.shared.model.PlayerModelParts;
import com.tom.cpm.shared.model.RootModelType;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.parts.IModelPart;
import com.tom.cpm.shared.parts.ModelPartAnimatedTexture;
import com.tom.cpm.shared.parts.ModelPartAnimation;
import com.tom.cpm.shared.parts.ModelPartCloneable;
import com.tom.cpm.shared.parts.ModelPartDefinition;
import com.tom.cpm.shared.parts.ModelPartDupRoot;
import com.tom.cpm.shared.parts.ModelPartEnd;
import com.tom.cpm.shared.parts.ModelPartPlayer;
import com.tom.cpm.shared.parts.ModelPartPlayerPos;
import com.tom.cpm.shared.parts.ModelPartRenderEffect;
import com.tom.cpm.shared.parts.ModelPartRoot;
import com.tom.cpm.shared.parts.ModelPartSkin;
import com.tom.cpm.shared.parts.ModelPartSkinType;
import com.tom.cpm.shared.parts.ModelPartTags;
import com.tom.cpm.shared.parts.ModelPartTemplate;
import com.tom.cpm.shared.parts.ModelPartTexture;
import com.tom.cpm.shared.parts.ModelPartUUIDLockout;
import com.tom.cpm.shared.parts.PartCollection;
import com.tom.cpm.shared.paste.PastePopup;
import com.tom.cpm.shared.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class Exporter {
    public static void exportSkin(Editor e, UI gui, File f, boolean forceOut) {
        Exporter.exportSkin(e, gui, (Image img) -> {
            img.storeTo(f);
            gui.displayMessagePopup(gui.i18nFormat("label.cpm.export_success", new Object[0]), gui.i18nFormat("label.cpm.export_success.desc", f.getName()));
        }, forceOut);
    }

    public static void exportSkin(Editor e, UI gui, ThrowingConsumer<Image, IOException> out, boolean forceOut) {
        if (e.vanillaSkin == null) {
            gui.displayMessagePopup("Unknown Error", "Couldn't load vanilla skin");
            return;
        }
        if (e.vanillaSkin.getWidth() != 64 || e.vanillaSkin.getHeight() != 64) {
            gui.displayMessagePopup(gui.i18nFormat("label.cpm.error", new Object[0]), gui.i18nFormat("error.cpm.vanillaSkinSize", new Object[0]));
            return;
        }
        Image img = new Image(e.vanillaSkin);
        Exporter.exportSkin0(e, gui, new Result(() -> new SkinDataOutputStream(img, MinecraftClientAccess.get().getDefinitionLoader().getTemplate(), e.skinType.getChannel()), () -> out.accept(img), (d, c) -> Exporter.handleOverflow(d, c, "skin", gui, e)), forceOut);
    }

    public static void exportB64(Editor e, UI gui, Consumer<String> b64Out, boolean forceOut) {
        byte[] buffer = new byte[200];
        int[] size = new int[]{0};
        Exporter.exportSkin0(e, gui, new Result(() -> {
            size[0] = 0;
            return new BAOS(buffer, size);
        }, () -> b64Out.accept(Base64.getEncoder().encodeToString(Arrays.copyOf(buffer, size[0]))), (d, c) -> Exporter.handleOverflow(d, c, "b64", gui, e)), forceOut);
    }

    public static void exportUpdate(Editor e, UI gui, Link linkToUpdate) {
        try {
            PartCollection def = Exporter.prepareExport(e);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(83);
            ChecksumOutputStream cos = new ChecksumOutputStream(baos);
            def.writePackage(new IOHelper(cos));
            cos.close();
            String b64 = Base64.getEncoder().encodeToString(baos.toByteArray());
            Log.info(b64);
            if (linkToUpdate.getLoader().equals("p")) {
                PastePopup.runRequest(gui, c -> c.updateFile(linkToUpdate.getPath(), b64.getBytes(StandardCharsets.UTF_8)), () -> gui.displayPopup(frame -> {
                    MessagePopup popup = new MessagePopup((Frame)frame, gui.i18nFormat("label.cpm.export_success", new Object[0]), gui.i18nFormat("label.cpm.paste.updatedModel", new Object[0]));
                    popup.setOnClosed(MinecraftClientAccess.get().getDefinitionLoader()::clearCache);
                    return popup;
                }), () -> {}, "uploading");
            } else {
                gui.displayPopup(frame -> new ExportStringResultPopup((Frame)frame, "skin_update", b64));
            }
        }
        catch (ExportException ex) {
            gui.displayMessagePopup(gui.i18nFormat("label.cpm.error", new Object[0]), ex.toString(gui));
        }
        catch (Exception ex) {
            gui.onGuiException("Error while exporting", ex, false);
        }
    }

    public static void exportModel(Editor e, UI gui, File f, ModelDescription desc, boolean skinCompat) {
        ModelWriter wr = new ModelWriter(gui, f, skinCompat);
        wr.setDesc(desc.name, desc.desc, desc.icon);
        Exporter.exportSkin0(e, gui, new Result(wr::getOut, () -> {
            if (wr.finish()) {
                gui.displayMessagePopup(gui.i18nFormat("label.cpm.export_success", new Object[0]), gui.i18nFormat("label.cpm.export_success.desc", f.getName()));
            }
        }, (d, c) -> Exporter.handleOverflow(d, l -> {
            wr.setOverflow((byte[])d, (Link)l);
            c.accept(l);
        }, "model", gui, e)), false);
    }

    public static boolean exportTempModel(Editor e, UI gui) {
        File models = new File(MinecraftClientAccess.get().getGameDir(), "player_models");
        models.mkdirs();
        ModelWriter wr = new ModelWriter(gui, new File(models, ".temp.cpmmodel"), false);
        wr.setDesc("Test model", "", null);
        return Exporter.exportSkin0(e, gui, new Result(wr::getOut, wr::finish, (d, c) -> {
            Link l = new Link("local:test" + System.nanoTime());
            wr.setOverflow((byte[])d, l);
            c.accept(l);
        }), false);
    }

    private static PartCollection prepareExport(Editor e) throws IOException {
        if (ModConfig.getCommonConfig().getBoolean("experimentalExport0614", false)) {
            return ExporterImpl.prepareExport(e);
        }
        return Exporter.prepareDefinition(e);
    }

    @Deprecated
    private static ModelPartDefinition prepareDefinition(Editor e) throws IOException {
        ArrayList<Cube> flatList = new ArrayList<Cube>();
        ExportHelper.flattenElements(e.elements, new int[]{10}, flatList);
        ModelPartDefinition def = new ModelPartDefinition(flatList);
        ModelPartPlayer player = new ModelPartPlayer(e);
        ArrayList<IModelPart> otherParts = new ArrayList<IModelPart>();
        otherParts.add(player);
        if (e.textures.get((Object)TextureSheetType.SKIN).isEdited()) {
            otherParts.add(new ModelPartSkin(e));
        }
        for (PlayerModelParts p : PlayerModelParts.VALUES) {
            for (ModelElement el2 : e.elements) {
                if (el2.type != ElementType.ROOT_PART || el2.typeData != p || el2.duplicated || el2.pos.epsilon(0.1f) && el2.rotation.epsilon(0.1f)) continue;
                otherParts.add(new ModelPartPlayerPos(p.getId(el2.rc), el2.pos, el2.rotation));
            }
        }
        ArrayList otherParts2 = new ArrayList();
        ExportHelper.walkElements(e.elements, el -> {
            if (el.type == ElementType.NORMAL) {
                if (el.glow) {
                    otherParts.add(new ModelPartRenderEffect(new EffectGlow(el.id)));
                }
                if (Math.abs(el.mcScale) > 1.0E-4f || Math.abs(el.meshScale.x - 1.0f) > 0.01f || Math.abs(el.meshScale.y - 1.0f) > 0.01f || Math.abs(el.meshScale.z - 1.0f) > 0.01f) {
                    otherParts.add(new ModelPartRenderEffect(new EffectScale(el.id, el.meshScale, el.mcScale)));
                }
                if (el.hidden) {
                    otherParts.add(new ModelPartRenderEffect(new EffectHide(el.id)));
                }
                if (el.recolor) {
                    otherParts.add(new ModelPartRenderEffect(new EffectColor(el.id, el.rgb)));
                }
                if (el.singleTex) {
                    otherParts.add(new ModelPartRenderEffect(new EffectSingleTexture(el.id)));
                }
                if (el.extrude) {
                    otherParts.add(new ModelPartRenderEffect(new EffectExtrude(el.id)));
                }
                if (el.faceUV != null) {
                    otherParts.add(new ModelPartRenderEffect(new EffectPerFaceUV(el.id, el.faceUV)));
                } else if (el.u > 255 || el.v > 255) {
                    otherParts.add(new ModelPartRenderEffect(new EffectUV(el.id, el.u, el.v)));
                }
                if (el.itemRenderer != null) {
                    otherParts.add(new ModelPartRenderEffect(new EffectRenderItem(el.id, el.itemRenderer.slot, el.itemRenderer.slotID)));
                }
                if (el.copyTransform != null && el.copyTransform.from != null) {
                    otherParts2.add(new ModelPartRenderEffect(new EffectCopyTransform(el.copyTransform.from.id, el.id, el.copyTransform.toShort())));
                }
            }
        });
        for (ModelElement el3 : e.elements) {
            if (el3.type != ElementType.ROOT_PART) continue;
            if (el3.duplicated && el3.typeData instanceof PlayerModelParts) {
                if (el3.hidden) {
                    otherParts.add(new ModelPartRenderEffect(new EffectHide(el3.id)));
                }
                otherParts.add(new ModelPartDupRoot(el3.id, (PlayerModelParts)el3.typeData));
            } else if (el3.typeData instanceof RootModelType) {
                if (el3.hidden) {
                    otherParts.add(new ModelPartRenderEffect(new EffectHide(el3.id)));
                }
                otherParts.add(new ModelPartRoot(el3.id, (RootModelType)el3.typeData));
            }
            if (!el3.disableVanillaAnim) continue;
            otherParts.add(new ModelPartRenderEffect(new EffectDisableVanilla(el3.id)));
        }
        otherParts.addAll(otherParts2);
        if (!e.animations.isEmpty()) {
            otherParts.add(new ModelPartAnimation(e, otherParts));
        }
        e.textures.forEach((type, tex) -> {
            if (type.editable) {
                if (type != TextureSheetType.SKIN) {
                    otherParts.add(new ModelPartTexture(e, (TextureSheetType)((Object)((Object)type))));
                }
                if (!tex.animatedTexs.isEmpty()) {
                    tex.animatedTexs.forEach(at -> otherParts.add(new ModelPartAnimatedTexture((TextureSheetType)((Object)((Object)type)), (AnimatedTex)at)));
                }
            }
        });
        for (EditorTemplate et : e.templates) {
            otherParts.add(new ModelPartTemplate(et));
        }
        if (e.scalingElem.enabled) {
            otherParts.add(new ModelPartRenderEffect(new EffectScaling(e.scalingElem.scaling)));
            if (e.scalingElem.hasTransform()) {
                otherParts.add(new ModelPartRenderEffect(new EffectModelScale(e.scalingElem.pos, e.scalingElem.rotation, e.scalingElem.scale)));
            }
        }
        if (!e.hideHeadIfSkull) {
            otherParts.add(new ModelPartRenderEffect(new EffectHideSkull(e.hideHeadIfSkull)));
        }
        if (e.removeArmorOffset) {
            otherParts.add(new ModelPartRenderEffect(new EffectRemoveArmorOffset(e.removeArmorOffset)));
        }
        if (e.removeBedOffset) {
            otherParts.add(new ModelPartRenderEffect(new EffectRemoveBedOffset()));
        }
        if (e.enableInvisGlow) {
            otherParts.add(new ModelPartRenderEffect(new EffectInvisGlow()));
        }
        if (e.leftHandPos.isChanged() || e.rightHandPos.isChanged()) {
            otherParts.add(new ModelPartRenderEffect(new EffectFirstPersonHandPos(e.leftHandPos, e.rightHandPos)));
        }
        for (Iterator<TreeElement> iterator : TagType.VALUES) {
            if (!((EditorTagManager)e.tags.getByType((TagType)((Object)iterator))).hasTags()) continue;
            otherParts.add(new ModelPartTags((TagType)((Object)iterator), (EditorTagManager<?>)e.tags.getByType((TagType)((Object)iterator))));
        }
        if (e.description != null) {
            switch (e.description.copyProtection) {
                case CLONEABLE: {
                    otherParts.add(new ModelPartCloneable(e.description.name, e.description.desc, e.description.icon));
                    break;
                }
                case NORMAL: {
                    break;
                }
                case UUID_LOCK: {
                    otherParts.add(new ModelPartUUIDLockout(e.description.uuid != null ? e.description.uuid : MinecraftClientAccess.get().getClientPlayer().getUUID()));
                    break;
                }
            }
        }
        def.setOtherParts(otherParts);
        if (MinecraftObjectHolder.DEBUGGING) {
            Log.info(def);
        }
        return def;
    }

    private static boolean exportSkin0(Editor e, UI gui, Result result, boolean forceOut) {
        try {
            PartCollection def = Exporter.prepareExport(e);
            if (forceOut) {
                Exporter.writeOut(e, gui, def, result);
                return true;
            }
            try (OutputStream out = result.get();){
                out.write(83);
                ChecksumOutputStream cos = new ChecksumOutputStream(out);
                try (IOHelper dout = new IOHelper(cos);){
                    dout.writeObjectBlock(new ModelPartSkinType(e.skinType));
                    def.writeBlocks(dout);
                    dout.writeObjectBlock(ModelPartEnd.END);
                }
            }
            catch (EOFException unusedException) {
                Exporter.writeOut(e, gui, def, result);
                return true;
            }
            catch (IOException e1) {
                throw new ExportException(new FormatText("error.cpm.unknownError", new Object[0]), (Throwable)e1);
            }
            result.close();
            return true;
        }
        catch (ExportException ex) {
            Log.error("Export exception", ex);
            gui.displayMessagePopup(gui.i18nFormat("label.cpm.error", new Object[0]), ex.toString(gui));
            return false;
        }
        catch (Exception ex) {
            gui.onGuiException("Error while exporting", ex, false);
            gui.displayMessagePopup(gui.i18nFormat("label.cpm.error", new Object[0]), gui.i18nFormat("tooltip.cpm.errorTooltip", gui.i18nFormat("error.cpm.unknownError", new Object[0])));
            return false;
        }
    }

    private static void writeOut(Editor e, UI gui, PartCollection def, Result result) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(83);
        ChecksumOutputStream cos = new ChecksumOutputStream(baos);
        def.writePackage(new IOHelper(cos));
        cos.close();
        result.overflowWriter.accept(baos.toByteArray(), link -> {
            try {
                IModelPart defLink = def.toLink((Link)link);
                try (OutputStream out = result.get();){
                    out.write(83);
                    ChecksumOutputStream cos = new ChecksumOutputStream(out);
                    try (IOHelper dout = new IOHelper(cos);){
                        dout.writeObjectBlock(new ModelPartSkinType(e.skinType));
                        dout.writeObjectBlock(defLink);
                        dout.writeObjectBlock(ModelPartEnd.END);
                    }
                }
                result.close();
            }
            catch (ExportException ex) {
                gui.displayMessagePopup(gui.i18nFormat("label.cpm.error", new Object[0]), ex.toString(gui));
            }
            catch (Exception ex) {
                gui.onGuiException("Error while exporting", ex, false);
            }
        });
    }

    public static boolean check(Editor editor, UI gui, Runnable next) {
        if (!editor.animations.isEmpty() && editor.animEnc == null && editor.animations.stream().anyMatch(EditorAnim::isCustom)) {
            gui.displayPopup(f -> new AnimEncConfigPopup(f.getGui(), editor, next));
            return false;
        }
        return true;
    }

    private static void handleOverflow(byte[] data, Consumer<Link> linkC, String reason, UI gui, Editor e) {
        String b64 = Base64.getEncoder().encodeToString(data);
        Log.info(b64);
        gui.displayPopup(f -> new OverflowPopup((Frame)f, e, b64, reason, linkC));
    }

    public static void convert(ModelFile file, Image imgIn, SkinType type, Consumer<Image> outCons, Runnable error) {
        Image img = new Image(imgIn);
        try (SkinDataOutputStream out = new SkinDataOutputStream(img, MinecraftClientAccess.get().getDefinitionLoader().getTemplate(), type.getChannel());){
            out.write(file.getDataBlock());
        }
        catch (IOException e) {
            Log.error("Failed to convert model file to skin", e);
            error.run();
            return;
        }
        outCons.accept(img);
    }

    private static class Result
    implements Supplier<OutputStream>,
    Closeable {
        private Supplier<OutputStream> out;
        private Closeable finish;
        private BiConsumer<byte[], Consumer<Link>> overflowWriter;

        public Result(Supplier<OutputStream> out, Closeable finish, BiConsumer<byte[], Consumer<Link>> overflowWriter) {
            this.out = out;
            this.finish = finish;
            this.overflowWriter = overflowWriter;
        }

        @Override
        public OutputStream get() {
            return this.out.get();
        }

        @Override
        public void close() throws IOException {
            this.finish.close();
        }
    }

    private static class ModelWriter {
        private final UI gui;
        private byte[] buffer;
        private int[] size = new int[]{0};
        private byte[] overflow;
        private File out;
        private String name;
        private String desc;
        private Link l;
        private Image icon;

        public ModelWriter(UI gui, File out, boolean skinCompat) {
            this.gui = gui;
            this.out = out;
            this.buffer = new byte[skinCompat ? 2048 : 30720];
        }

        public void setDesc(String name, String desc, Image icon) {
            this.name = name;
            this.desc = desc;
            this.icon = icon;
        }

        public OutputStream getOut() {
            this.size[0] = 0;
            return new BAOS(this.buffer, this.size);
        }

        public void setOverflow(byte[] d, Link l) {
            this.overflow = d;
            this.l = l;
        }

        public boolean finish() {
            block12: {
                boolean bl;
                FileOutputStream fout = new FileOutputStream(this.out);
                try {
                    fout.write(83);
                    ChecksumOutputStream cos = new ChecksumOutputStream(fout);
                    IOHelper h = new IOHelper(cos);
                    h.writeUTF(this.name);
                    h.writeUTF(this.desc);
                    h.writeVarInt(this.size[0]);
                    h.write(this.buffer, 0, this.size[0]);
                    if (this.overflow != null) {
                        h.writeByteArray(this.overflow);
                        this.l.write(h);
                    } else {
                        h.writeVarInt(0);
                    }
                    if (this.icon != null) {
                        h.writeImage(this.icon);
                    } else {
                        h.writeVarInt(0);
                    }
                    cos.close();
                    bl = true;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            fout.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (ExportException ex) {
                        this.gui.displayMessagePopup(this.gui.i18nFormat("label.cpm.error", new Object[0]), ex.toString(this.gui));
                        break block12;
                    }
                    catch (Exception ex) {
                        this.gui.onGuiException("Error while exporting", ex, false);
                    }
                }
                fout.close();
                return bl;
            }
            return false;
        }
    }

    private static class BAOS
    extends OutputStream {
        private byte[] buffer;
        private int[] size;

        public BAOS(byte[] buffer, int[] size) {
            this.buffer = buffer;
            this.size = size;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.buffer.length <= this.size[0]) {
                throw new EOFException();
            }
            int n = this.size[0];
            this.size[0] = n + 1;
            this.buffer[n] = (byte)b;
        }
    }
}

