/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.animation.interpolator;

import com.tom.cpl.math.MathHelper;
import com.tom.cpm.shared.animation.interpolator.Interpolator;
import java.util.function.DoubleUnaryOperator;

public class TrigonometricInterpolator
implements Interpolator {
    private float[] values;

    @Override
    public double applyAsDouble(double operand) {
        double v = operand / (double)this.values.length * (double)(this.values.length - 1);
        int frm = Math.abs(MathHelper.floor(v));
        return MathHelper.trigInt((float)(v - Math.floor(v)), this.values[Math.min(frm, this.values.length - 1)], this.values[Math.min(frm + 1, this.values.length - 1)]);
    }

    @Override
    public void init(float[] values, DoubleUnaryOperator setup) {
        this.values = new float[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.values[i] = (float)setup.applyAsDouble(values[i]);
        }
    }
}

