/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.externals.org.apache.commons.math3;

import com.tom.cpm.externals.org.apache.commons.math3.MathArrays;
import com.tom.cpm.externals.org.apache.commons.math3.PolynomialFunction;
import java.util.Arrays;

public class PolynomialSplineFunction {
    private final double[] knots;
    private final PolynomialFunction[] polynomials;
    private final int n;

    public PolynomialSplineFunction(double[] knots, PolynomialFunction[] polynomials) {
        if (knots == null || polynomials == null) {
            throw new RuntimeException("Null argument");
        }
        if (knots.length < 2) {
            throw new RuntimeException("Number is to small: " + knots.length);
        }
        if (knots.length - 1 != polynomials.length) {
            throw new RuntimeException("Dimensions does not match! " + polynomials.length + " & " + knots.length);
        }
        MathArrays.checkOrder(knots);
        this.n = knots.length - 1;
        this.knots = new double[this.n + 1];
        System.arraycopy(knots, 0, this.knots, 0, this.n + 1);
        this.polynomials = new PolynomialFunction[this.n];
        System.arraycopy(polynomials, 0, this.polynomials, 0, this.n);
    }

    public double value(double v) {
        if (v < this.knots[0] || v > this.knots[this.n]) {
            throw new RuntimeException("out of range: " + v);
        }
        int i = Arrays.binarySearch(this.knots, v);
        if (i < 0) {
            i = -i - 2;
        }
        if (i >= this.polynomials.length) {
            --i;
        }
        return this.polynomials[i].value(v - this.knots[i]);
    }

    private PolynomialSplineFunction polynomialSplineDerivative() {
        PolynomialFunction[] derivativePolynomials = new PolynomialFunction[this.n];
        for (int i = 0; i < this.n; ++i) {
            derivativePolynomials[i] = this.polynomials[i].polynomialDerivative();
        }
        return new PolynomialSplineFunction(this.knots, derivativePolynomials);
    }

    public int getN() {
        return this.n;
    }

    public PolynomialFunction[] getPolynomials() {
        PolynomialFunction[] p = new PolynomialFunction[this.n];
        System.arraycopy(this.polynomials, 0, p, 0, this.n);
        return p;
    }

    public double[] getKnots() {
        double[] out = new double[this.n + 1];
        System.arraycopy(this.knots, 0, out, 0, this.n + 1);
        return out;
    }
}

