/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.KeyCodes;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.NativeGuiComponents;
import com.tom.cpl.gui.UIColors;
import com.tom.cpl.gui.elements.FileChooserPopup;
import com.tom.cpl.gui.elements.TextField;
import com.tom.cpl.item.Stack;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.text.IText;
import com.tom.cpm.client.GLFWKeyCodes;
import com.tom.cpm.client.MinecraftObject;
import com.tom.cpm.client.Panel3dImpl;
import com.tom.cpm.client.Platform;
import com.tom.cpm.client.TinyFDChooser;
import com.tom.cpm.common.ItemStackHandlerImpl;
import com.tom.cpm.mixin.GuiAccessor;
import com.tom.cpm.shared.MinecraftCommonAccess;
import com.tom.cpm.shared.gui.panel.Panel3d;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1074;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_1659;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_408;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4588;
import net.minecraft.class_5244;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import net.minecraft.client.ClientBrandRetriever;
import org.joml.Matrix4f;
import org.lwjgl.glfw.GLFW;

public class GuiImpl
extends class_437
implements IGui {
    protected static final KeyCodes CODES = new GLFWKeyCodes();
    protected static final NativeGuiComponents nativeComponents = new NativeGuiComponents();
    protected Frame gui;
    protected class_437 parent;
    protected IGui.CtxStack stack;
    protected UIColors colors = new UIColors();
    protected Consumer<Runnable> closeListener;
    protected int keyModif;
    protected class_332 graphics;
    protected boolean noScissorTest;
    protected int vanillaScale = -1;

    public GuiImpl(Function<IGui, Frame> creator, class_437 parent) {
        super((class_2561)class_2561.method_43470((String)""));
        this.parent = parent;
        try {
            this.gui = creator.apply(this);
        }
        catch (Throwable e) {
            this.onGuiException("Error creating gui", e, true);
        }
        this.noScissorTest = this.isCtrlDown();
    }

    private static <G extends Supplier<IGui>, N> NativeGuiComponents.NativeConstructor<G, N> local(Function<GuiImpl, N> fac) {
        return f -> fac.apply((GuiImpl)f.get());
    }

    public boolean method_25421() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        block9: {
            this.method_25420(graphics, mouseX, mouseY, partialTicks);
            try {
                this.graphics = graphics;
                graphics.method_51448().method_22903();
                this.stack = new IGui.CtxStack(this.field_22789, this.field_22790);
                RenderSystem.disableDepthTest();
                float pt = this.field_22787.method_60646().method_60638();
                RenderSystem.runAsFancy(() -> this.gui.draw(mouseX, mouseY, pt));
                if (this.noScissorTest) break block9;
            }
            catch (Throwable e) {
                block10: {
                    try {
                        this.onGuiException("Error drawing gui", e, true);
                        if (this.noScissorTest) break block10;
                    }
                    catch (Throwable throwable) {
                        if (!this.noScissorTest) {
                            RenderSystem.disableScissor();
                        }
                        String modVer = MinecraftCommonAccess.get().getModVersion();
                        Object s = "Minecraft " + class_155.method_16673().method_48019() + " (" + this.field_22787.method_1515() + "/" + ClientBrandRetriever.getClientModName() + (String)("release".equalsIgnoreCase(this.field_22787.method_1547()) ? "" : "/" + this.field_22787.method_1547()) + ") " + modVer;
                        graphics.method_51433(this.field_22793, (String)s, this.field_22789 - this.field_22793.method_1727((String)s) - 4, 2, -16777216, false);
                        s = this.field_22787.field_1770;
                        if (this.noScissorTest) {
                            s = (String)s + " No Scissor";
                        }
                        graphics.method_51433(this.field_22793, (String)s, this.field_22789 - this.field_22793.method_1727((String)s) - 4, 11, -16777216, false);
                        this.graphics = null;
                        graphics.method_51448().method_22909();
                        throw throwable;
                    }
                    RenderSystem.disableScissor();
                }
                String modVer = MinecraftCommonAccess.get().getModVersion();
                Object s = "Minecraft " + class_155.method_16673().method_48019() + " (" + this.field_22787.method_1515() + "/" + ClientBrandRetriever.getClientModName() + (String)("release".equalsIgnoreCase(this.field_22787.method_1547()) ? "" : "/" + this.field_22787.method_1547()) + ") " + modVer;
                graphics.method_51433(this.field_22793, (String)s, this.field_22789 - this.field_22793.method_1727((String)s) - 4, 2, -16777216, false);
                s = this.field_22787.field_1770;
                if (this.noScissorTest) {
                    s = (String)s + " No Scissor";
                }
                graphics.method_51433(this.field_22793, (String)s, this.field_22789 - this.field_22793.method_1727((String)s) - 4, 11, -16777216, false);
                this.graphics = null;
                graphics.method_51448().method_22909();
            }
            RenderSystem.disableScissor();
        }
        String modVer = MinecraftCommonAccess.get().getModVersion();
        Object s = "Minecraft " + class_155.method_16673().method_48019() + " (" + this.field_22787.method_1515() + "/" + ClientBrandRetriever.getClientModName() + (String)("release".equalsIgnoreCase(this.field_22787.method_1547()) ? "" : "/" + this.field_22787.method_1547()) + ") " + modVer;
        graphics.method_51433(this.field_22793, (String)s, this.field_22789 - this.field_22793.method_1727((String)s) - 4, 2, -16777216, false);
        s = this.field_22787.field_1770;
        if (this.noScissorTest) {
            s = (String)s + " No Scissor";
        }
        graphics.method_51433(this.field_22793, (String)s, this.field_22789 - this.field_22793.method_1727((String)s) - 4, 11, -16777216, false);
        this.graphics = null;
        graphics.method_51448().method_22909();
        if (this.field_22787.field_1724 != null && this.gui.enableChat()) {
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416(0.0f, 0.0f, 800.0f);
            ((GuiAccessor)this.field_22787.field_1705).callRenderChat(graphics, this.field_22787.method_60646());
            graphics.method_51448().method_22909();
        }
    }

    public void method_25432() {
        if (this.vanillaScale >= 0 && this.vanillaScale != (Integer)this.field_22787.field_1690.method_42474().method_41753()) {
            int v = this.vanillaScale;
            this.vanillaScale = -999;
            this.field_22787.field_1690.method_42474().method_41748((Object)v);
        }
    }

    public void method_25419() {
        class_437 p = this.parent;
        this.parent = null;
        this.field_22787.method_1507(p);
    }

    @Override
    public void drawBox(int x, int y, int w, int h, int color) {
        this.graphics.method_48196(class_1921.method_51785(), x += this.getOffset().x, y += this.getOffset().y, x + w, y + h, 0, color);
    }

    @Override
    public void drawBox(float x, float y, float w, float h, int color) {
        float minX = x += (float)this.getOffset().x;
        float minY = y += (float)this.getOffset().y;
        float maxX = x + w;
        float maxY = y + h;
        if (minX < maxX) {
            float i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            float j = minY;
            minY = maxY;
            maxY = j;
        }
        Matrix4f matrix = this.graphics.method_51448().method_23760().method_23761();
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        class_4588 bufferbuilder = this.graphics.method_51450().getBuffer(class_1921.method_51785());
        bufferbuilder.method_22918(matrix, minX, maxY, 0.0f).method_22915(f, f1, f2, f3);
        bufferbuilder.method_22918(matrix, maxX, maxY, 0.0f).method_22915(f, f1, f2, f3);
        bufferbuilder.method_22918(matrix, maxX, minY, 0.0f).method_22915(f, f1, f2, f3);
        bufferbuilder.method_22918(matrix, minX, minY, 0.0f).method_22915(f, f1, f2, f3);
        this.graphics.method_51452();
    }

    protected void method_25426() {
        try {
            this.gui.init(this.field_22789, this.field_22790);
        }
        catch (Throwable e) {
            this.onGuiException("Error in init gui", e, true);
        }
    }

    @Override
    public void drawText(int x, int y, String text, int color) {
        this.graphics.method_51448().method_22903();
        this.graphics.method_51448().method_46416(0.0f, 0.0f, 500.0f);
        this.graphics.method_51433(this.field_22793, text, x += this.getOffset().x, y += this.getOffset().y, color, false);
        this.graphics.method_51448().method_22909();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        try {
            this.keyModif = modifiers;
            KeyboardEvent evt = new KeyboardEvent(keyCode, scanCode, '\uffff', GLFW.glfwGetKeyName((int)keyCode, (int)scanCode));
            this.gui.keyPressed(evt);
            if (!evt.isConsumed() && this.field_22787.field_1724 != null && this.field_22787.field_1690.field_1890.method_1417(keyCode, scanCode) && this.field_22787.field_1690.method_42539().method_41753() != class_1659.field_7536) {
                RenderSystem.recordRenderCall(() -> {
                    int scale = this.vanillaScale;
                    this.vanillaScale = -1;
                    this.field_22787.method_1507((class_437)new Overlay(scale));
                    this.vanillaScale = scale;
                });
                return true;
            }
            return true;
        }
        catch (Throwable e) {
            this.onGuiException("Error processing key event", e, false);
            return true;
        }
    }

    public boolean method_25400(char codePoint, int modifiers) {
        try {
            this.keyModif = modifiers;
            KeyboardEvent evt = new KeyboardEvent(-1, -1, codePoint, null);
            this.gui.keyPressed(evt);
            return evt.isConsumed();
        }
        catch (Throwable e) {
            this.onGuiException("Error processing key event", e, false);
            return true;
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        try {
            MouseEvent evt = new MouseEvent((int)mouseX, (int)mouseY, button);
            this.gui.mouseClick(evt);
            return evt.isConsumed();
        }
        catch (Throwable e) {
            this.onGuiException("Error processing mouse event", e, false);
            return true;
        }
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        try {
            MouseEvent evt = new MouseEvent((int)mouseX, (int)mouseY, button);
            this.gui.mouseDrag(evt);
            return evt.isConsumed();
        }
        catch (Throwable e) {
            this.onGuiException("Error processing mouse event", e, false);
            return true;
        }
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        try {
            MouseEvent evt = new MouseEvent((int)mouseX, (int)mouseY, button);
            this.gui.mouseRelease(evt);
            return evt.isConsumed();
        }
        catch (Throwable e) {
            this.onGuiException("Error processing mouse event", e, false);
            return true;
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double xdelta, double ydelta) {
        if (ydelta != 0.0) {
            try {
                MouseEvent evt = new MouseEvent((int)mouseX, (int)mouseY, (int)ydelta);
                this.gui.mouseWheel(evt);
                return evt.isConsumed();
            }
            catch (Throwable e) {
                this.onGuiException("Error processing mouse event", e, false);
                return true;
            }
        }
        return false;
    }

    public void method_29638(List<Path> filesIn) {
        try {
            this.gui.filesDropped(filesIn.stream().map(Path::toFile).filter(File::exists).collect(Collectors.toList()));
        }
        catch (Throwable e) {
            this.onGuiException("Error processing mouse event", e, false);
        }
    }

    @Override
    public void displayError(String e) {
        class_437 p = this.parent;
        this.parent = null;
        class_310.method_1551().method_1507((class_437)new CrashScreen(e, p));
    }

    @Override
    public void closeGui() {
        if (this.closeListener != null) {
            this.closeListener.accept(this::method_25419);
        } else {
            this.method_25419();
        }
    }

    @Override
    public void drawTexture(int x, int y, int w, int h, int u, int v, String texture) {
        RenderSystem.disableDepthTest();
        this.graphics.method_25302(class_2960.method_43902((String)"cpm", (String)("textures/gui/" + texture + ".png")), x += this.getOffset().x, y += this.getOffset().y, u, v, w, h);
    }

    @Override
    public void drawTexture(int x, int y, int w, int h, int u, int v, String texture, int color) {
        x += this.getOffset().x;
        y += this.getOffset().y;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        RenderSystem.disableDepthTest();
        this.graphics.method_25302(class_2960.method_43902((String)"cpm", (String)("textures/gui/" + texture + ".png")), x, y, u, v, w, h);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void drawTexture(int x, int y, int width, int height, float u1, float v1, float u2, float v2) {
        x += this.getOffset().x;
        y += this.getOffset().y;
        RenderSystem.setShaderTexture((int)0, (class_2960)MinecraftObject.DynTexture.getBoundLoc());
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        class_289 tessellator = class_289.method_1348();
        class_287 bufferbuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        float bo = 0.0f;
        Matrix4f matrix = this.graphics.method_51448().method_23760().method_23761();
        bufferbuilder.method_22918(matrix, (float)x, (float)(y + height), bo).method_22913(u1, v2);
        bufferbuilder.method_22918(matrix, (float)(x + width), (float)(y + height), bo).method_22913(u2, v2);
        bufferbuilder.method_22918(matrix, (float)(x + width), (float)y, bo).method_22913(u2, v1);
        bufferbuilder.method_22918(matrix, (float)x, (float)y, bo).method_22913(u1, v1);
        class_286.method_43433((class_9801)bufferbuilder.method_60794());
        RenderSystem.disableBlend();
    }

    @Override
    public String i18nFormat(String key, Object ... obj) {
        return class_1074.method_4662((String)key, (Object[])obj);
    }

    @Override
    public void setupCut() {
        if (!this.noScissorTest) {
            int dw = this.field_22787.method_22683().method_4489();
            int dh = this.field_22787.method_22683().method_4506();
            float multiplierX = (float)dw / (float)this.field_22789;
            float multiplierY = (float)dh / (float)this.field_22790;
            Box box = this.getContext().cutBox;
            RenderSystem.enableScissor((int)((int)((float)box.x * multiplierX)), (int)(dh - (int)((float)(box.y + box.h) * multiplierY)), (int)((int)((float)box.w * multiplierX)), (int)((int)((float)box.h * multiplierY)));
        }
    }

    @Override
    public int textWidth(String text) {
        return this.field_22793.method_1727(text);
    }

    private TextField.ITextField createTextField() {
        return new TxtField();
    }

    @Override
    public UIColors getColors() {
        return this.colors;
    }

    @Override
    public void setCloseListener(Consumer<Runnable> listener) {
        this.closeListener = listener;
    }

    @Override
    public boolean isShiftDown() {
        return GuiImpl.method_25442();
    }

    @Override
    public boolean isCtrlDown() {
        return GuiImpl.method_25441();
    }

    @Override
    public boolean isAltDown() {
        return GuiImpl.method_25443();
    }

    @Override
    public KeyCodes getKeyCodes() {
        return CODES;
    }

    @Override
    public void drawGradientBox(int x, int y, int w, int h, int topLeft, int topRight, int bottomLeft, int bottomRight) {
        int left = x += this.getOffset().x;
        int top = y += this.getOffset().y;
        int right = x + w;
        int bottom = y + h;
        float atr = (float)(topRight >> 24 & 0xFF) / 255.0f;
        float rtr = (float)(topRight >> 16 & 0xFF) / 255.0f;
        float gtr = (float)(topRight >> 8 & 0xFF) / 255.0f;
        float btr = (float)(topRight & 0xFF) / 255.0f;
        float atl = (float)(topLeft >> 24 & 0xFF) / 255.0f;
        float rtl = (float)(topLeft >> 16 & 0xFF) / 255.0f;
        float gtl = (float)(topLeft >> 8 & 0xFF) / 255.0f;
        float btl = (float)(topLeft & 0xFF) / 255.0f;
        float abl = (float)(bottomLeft >> 24 & 0xFF) / 255.0f;
        float rbl = (float)(bottomLeft >> 16 & 0xFF) / 255.0f;
        float gbl = (float)(bottomLeft >> 8 & 0xFF) / 255.0f;
        float bbl = (float)(bottomLeft & 0xFF) / 255.0f;
        float abr = (float)(bottomRight >> 24 & 0xFF) / 255.0f;
        float rbr = (float)(bottomRight >> 16 & 0xFF) / 255.0f;
        float gbr = (float)(bottomRight >> 8 & 0xFF) / 255.0f;
        float bbr = (float)(bottomRight & 0xFF) / 255.0f;
        class_4588 bufferbuilder = this.graphics.method_51450().getBuffer(class_1921.method_51785());
        Matrix4f mat = this.graphics.method_51448().method_23760().method_23761();
        float bo = 0.0f;
        bufferbuilder.method_22918(mat, (float)right, (float)top, bo).method_22915(rtr, gtr, btr, atr);
        bufferbuilder.method_22918(mat, (float)left, (float)top, bo).method_22915(rtl, gtl, btl, atl);
        bufferbuilder.method_22918(mat, (float)left, (float)bottom, bo).method_22915(rbl, gbl, bbl, abl);
        bufferbuilder.method_22918(mat, (float)right, (float)bottom, bo).method_22915(rbr, gbr, bbr, abr);
    }

    @Override
    public NativeGuiComponents getNative() {
        return nativeComponents;
    }

    @Override
    public void setClipboardText(String text) {
        this.field_22787.field_1774.method_1455(text);
    }

    @Override
    public Frame getFrame() {
        return this.gui;
    }

    @Override
    public String getClipboardText() {
        return this.field_22787.field_1774.method_1460();
    }

    @Override
    public void setScale(int value) {
        if (this.vanillaScale == -999) {
            return;
        }
        if (value != (Integer)this.field_22787.field_1690.method_42474().method_41753()) {
            if (this.vanillaScale == -1) {
                this.vanillaScale = (Integer)this.field_22787.field_1690.method_42474().method_41753();
            }
            if (value == -1) {
                if ((Integer)this.field_22787.field_1690.method_42474().method_41753() != this.vanillaScale) {
                    this.field_22787.field_1690.method_42474().method_41748((Object)this.vanillaScale);
                    this.vanillaScale = -1;
                }
            } else {
                this.field_22787.field_1690.method_42474().method_41748((Object)value);
            }
        }
    }

    @Override
    public int getScale() {
        return (Integer)this.field_22787.field_1690.method_42474().method_41753();
    }

    @Override
    public int getMaxScale() {
        return this.field_22787.method_22683().method_4476(0, this.field_22787.method_1573()) + 1;
    }

    @Override
    public IGui.CtxStack getStack() {
        return this.stack;
    }

    public void method_25393() {
        try {
            this.gui.tick();
        }
        catch (Throwable e) {
            this.onGuiException("Error in tick gui", e, true);
        }
    }

    @Override
    public void drawFormattedText(float x, float y, IText text, int color, float scale) {
        this.graphics.method_51448().method_22903();
        this.graphics.method_51448().method_46416(x += (float)this.getOffset().x, y += (float)this.getOffset().y, 500.0f);
        this.graphics.method_51448().method_22905(scale, scale, scale);
        this.graphics.method_51439(this.field_22793, (class_2561)text.remap(), 0, 0, color, false);
        this.graphics.method_51448().method_22909();
    }

    @Override
    public int textWidthFormatted(IText text) {
        return this.field_22793.method_30880(((class_2561)text.remap()).method_30937());
    }

    @Override
    public void openURL0(String url) {
        class_156.method_668().method_670(url);
    }

    public class_332 getMCGraphics() {
        return this.graphics;
    }

    public void method_49589() {
        this.vanillaScale = -1;
    }

    @Override
    public void drawStack(int x, int y, Stack stack) {
        class_1799 s = (class_1799)ItemStackHandlerImpl.impl.unwrap(stack);
        this.graphics.method_51427(s, x += this.getOffset().x, y += this.getOffset().y);
        this.graphics.method_51431(this.field_22793, s, x, y);
    }

    @Override
    public void drawStackTooltip(int mx, int my, Stack stack) {
        this.graphics.method_51448().method_22903();
        this.graphics.method_51448().method_46416(0.0f, 0.0f, 100.0f);
        class_1799 s = (class_1799)ItemStackHandlerImpl.impl.unwrap(stack);
        this.graphics.method_51446(this.field_22793, s, mx, my);
        this.graphics.method_51448().method_22909();
    }

    static {
        nativeComponents.register(TextField.class, GuiImpl.local(GuiImpl::createTextField));
        nativeComponents.register(FileChooserPopup.class, TinyFDChooser::new);
        nativeComponents.register(Panel3d.class, Panel3dImpl::new);
    }

    private static class CrashScreen
    extends class_437 {
        private String error;
        private class_437 parent;

        public CrashScreen(String error, class_437 p) {
            super((class_2561)class_2561.method_43470((String)"Error"));
            this.error = error;
            this.parent = p;
        }

        public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
            super.method_25394(graphics, mouseX, mouseY, partialTicks);
            String[] txt = class_1074.method_4662((String)"error.cpm.crash", (Object[])new Object[]{this.error}).split("\\\\");
            for (int i = 0; i < txt.length; ++i) {
                graphics.method_25300(this.field_22793, txt[i], this.field_22789 / 2, 15 + i * 10, 0xFFFFFF);
            }
        }

        protected void method_25426() {
            super.method_25426();
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24339, p_213034_1_ -> this.field_22787.method_1507((class_437)null)).method_46434(this.field_22789 / 2 - 100, 140, 200, 20).method_46431());
        }

        public void method_25419() {
            if (this.parent != null) {
                class_437 p = this.parent;
                this.parent = null;
                this.field_22787.method_1507(p);
            }
        }
    }

    private class TxtField
    implements TextField.ITextField,
    Consumer<String> {
        private class_342 field;
        private Runnable eventListener;
        private Vec2i currentOff = new Vec2i(0, 0);
        private Box bounds = new Box(0, 0, 0, 0);
        private boolean settingText;
        private boolean updateField;
        private boolean enabled;

        public TxtField() {
            this.field = new class_342(GuiImpl.this.field_22793, 0, 0, 0, 0, (class_2561)class_2561.method_43471((String)"narrator.cpm.field"));
            this.field.method_1880(0x100000);
            this.field.method_1858(false);
            this.field.method_1862(true);
            this.field.method_1868(0xFFFFFF);
            this.field.method_1863((Consumer)this);
            this.enabled = true;
        }

        @Override
        public void draw(int mouseX, int mouseY, float partialTicks, Box bounds) {
            Vec2i off = GuiImpl.this.getOffset();
            this.field.method_46421(bounds.x + off.x + 4);
            this.field.method_46419(bounds.y + off.y + 6);
            this.currentOff.x = off.x;
            this.currentOff.y = off.y;
            this.bounds.x = bounds.x;
            this.bounds.y = bounds.y;
            this.bounds.w = bounds.w;
            this.bounds.h = bounds.h;
            this.field.method_25358(bounds.w - 5);
            Platform.setHeight((class_339)this.field, bounds.h - 12);
            if (this.updateField) {
                this.settingText = true;
                this.field.method_1872(false);
                this.settingText = false;
                this.updateField = false;
            }
            GuiImpl.this.graphics.method_51448().method_22903();
            GuiImpl.this.graphics.method_51448().method_46416(0.0f, 0.0f, 400.0f);
            this.field.method_25394(GuiImpl.this.graphics, mouseX, mouseY, partialTicks);
            GuiImpl.this.graphics.method_51448().method_22909();
        }

        @Override
        public void keyPressed(KeyboardEvent evt) {
            if (evt.isConsumed()) {
                return;
            }
            if (evt.keyCode == -1) {
                if (this.field.method_25400(evt.charTyped, GuiImpl.this.keyModif)) {
                    evt.consume();
                }
            } else if (this.field.method_25404(evt.keyCode, evt.scancode, GuiImpl.this.keyModif) || this.field.method_20315()) {
                evt.consume();
            }
        }

        @Override
        public void mouseClick(MouseEvent evt) {
            if (evt.isConsumed() || !this.enabled) {
                this.field.method_25365(false);
                this.field.method_1884(this.field.method_1881());
                return;
            }
            this.field.method_46421(this.bounds.x + this.currentOff.x);
            this.field.method_46419(this.bounds.y + this.currentOff.y);
            this.field.method_25358(this.bounds.w);
            Platform.setHeight((class_339)this.field, this.bounds.h);
            if (this.field.method_25402((double)(evt.x + this.currentOff.x), (double)(evt.y + this.currentOff.y), evt.btn)) {
                this.field.method_25365(true);
                evt.consume();
            } else {
                this.field.method_25365(false);
                this.field.method_1884(this.field.method_1881());
            }
        }

        @Override
        public String getText() {
            return this.field.method_1882();
        }

        @Override
        public void setText(String txt) {
            this.settingText = true;
            this.field.method_1852(txt);
            this.settingText = false;
            this.updateField = true;
        }

        @Override
        public void setEventListener(Runnable eventListener) {
            this.eventListener = eventListener;
        }

        @Override
        public void accept(String value) {
            if (this.eventListener != null && !this.settingText && this.enabled) {
                this.eventListener.run();
            }
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.field.method_1888(enabled);
            this.enabled = enabled;
        }

        @Override
        public boolean isFocused() {
            return this.field.method_25370();
        }

        @Override
        public void setFocused(boolean focused) {
            this.field.method_25365(focused);
        }

        @Override
        public int getCursorPos() {
            return this.field.method_1881();
        }

        @Override
        public void setCursorPos(int pos) {
            this.field.method_1875(pos);
        }

        @Override
        public void setSelectionPos(int pos) {
            this.field.method_1884(pos);
        }

        @Override
        public int getSelectionPos() {
            return this.field.field_2101;
        }
    }

    public class Overlay
    extends class_408 {
        private int vanillaScaleReset;

        public Overlay(int vanillaScaleReset) {
            super("");
            this.vanillaScaleReset = vanillaScaleReset;
        }

        public void method_25394(class_332 gr, int mouseX, int mouseY, float partialTicks) {
            gr.method_51448().method_22903();
            gr.method_51448().method_46416(0.0f, 0.0f, -50.0f);
            GuiImpl.this.method_25394(gr, Integer.MIN_VALUE, Integer.MIN_VALUE, partialTicks);
            gr.method_51448().method_22909();
            gr.method_51448().method_22903();
            gr.method_51448().method_46416(0.0f, 0.0f, 500.0f);
            super.method_25394(gr, mouseX, mouseY, partialTicks);
            gr.method_51448().method_22909();
        }

        public void method_25432() {
            super.method_25432();
            this.field_22787.method_18858(() -> {
                this.field_22787.method_1507((class_437)GuiImpl.this);
                GuiImpl.this.vanillaScale = this.vanillaScaleReset;
            });
        }
    }
}

