/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.util;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.LabelText;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.ScrollPanel;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.text.IText;
import com.tom.cpl.text.LiteralText;
import com.tom.cpl.text.StyledText;
import com.tom.cpl.text.TextStyle;
import com.tom.cpl.util.Image;
import com.tom.cpl.util.MarkdownRenderer;
import com.tom.cpl.util.StringBuilderStream;
import com.tom.cpm.shared.skin.TextureProvider;
import com.tom.cpm.shared.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class MarkdownParser {
    private static final Line NULL_LINE = new Line(){

        @Override
        public List<GuiElement> toElements(MarkdownRenderer mdr, Cursor cursor) {
            return Collections.emptyList();
        }
    };
    private static final Pattern LIST = Pattern.compile("^(\\d+)\\..*$");
    private static final String ESC_CHARS = "!#()*+-.[\\]_{}~`";
    private static final Map<String, Character> htmlEscapeEntities = new HashMap<String, Character>();
    private final List<Line> lines = new ArrayList<Line>();
    private final Map<Line, String> headerLines = new HashMap<Line, String>();
    private final Map<String, LinkReference> linkReferences = new HashMap<String, LinkReference>();

    public static MarkdownParser makeErrorPage(IGui gui, Throwable e) {
        StringBuilder sb = new StringBuilder("# ");
        sb.append(gui.i18nFormat("label.cpm.md.loadFail", new Object[0]));
        sb.append("\n");
        sb.append(gui.i18nFormat("label.cpm.md.loadFail." + (e instanceof IOException ? "network" : "unknown"), new Object[0]));
        sb.append("\n```");
        StringBuilderStream.stacktraceToString(e, sb, "\t");
        sb.append("```");
        return new MarkdownParser(sb.toString());
    }

    public MarkdownParser(String input) {
        try (BufferedReader rd = new BufferedReader(new StringReader(input));){
            String ln;
            StringBuilder sb = new StringBuilder();
            String codeBlock = null;
            String nextHeaderName = null;
            ArrayList<Component> prefix = new ArrayList<Component>();
            boolean lastBreak = false;
            IndentComponent lastIndent = null;
            while ((ln = rd.readLine()) != null) {
                String lnt = ln.trim();
                if (lnt.startsWith("```")) {
                    lastBreak = false;
                    if (codeBlock == null) {
                        this.parseLine(sb, 1.0f, prefix);
                        codeBlock = lnt.substring(3);
                        continue;
                    }
                    this.lines.add(new CodeLine(codeBlock, sb.toString()));
                    sb.setLength(0);
                    codeBlock = null;
                    continue;
                }
                if (codeBlock != null) {
                    sb.append(ln);
                    sb.append('\n');
                    continue;
                }
                if (lnt.isEmpty()) {
                    if (lastBreak) continue;
                    this.parseLine(sb, 1.0f, prefix);
                    this.lines.add(new EmptyLine(12));
                    lastBreak = true;
                    continue;
                }
                boolean wasLastBreak = lastBreak;
                lastBreak = false;
                if (!ln.startsWith("  ")) {
                    lastIndent = null;
                }
                if (ln.startsWith("|")) {
                    this.parseLine(sb, 1.0f, prefix);
                    ArrayList<String> t = new ArrayList<String>();
                    t.add(lnt);
                    while ((ln = rd.readLine()) != null && ln.startsWith("|")) {
                        t.add(ln.trim());
                    }
                    this.lines.add(new TableLine(t, this));
                } else if (ln.startsWith(">")) {
                    this.parseLine(sb, 1.0f, prefix);
                    ArrayList<String> t = new ArrayList<String>();
                    t.add(lnt);
                    while ((ln = rd.readLine()) != null && ln.startsWith(">")) {
                        t.add(ln.trim());
                    }
                    this.lines.add(new QuoteLine(t, this));
                } else if (lnt.startsWith("<a name=")) {
                    String e = lnt.substring(9);
                    int i = e.indexOf(34);
                    if (i != -1) {
                        nextHeaderName = e.substring(0, i);
                        if (!wasLastBreak) continue;
                        lastBreak = true;
                        continue;
                    }
                    if (sb.length() > 0) {
                        sb.append(' ');
                    }
                    sb.append(lnt);
                } else if (lnt.startsWith("#")) {
                    this.parseLine(sb, 1.0f, prefix);
                    this.lines.add(new EmptyLine(8));
                    float scl = 1.0f;
                    if (lnt.startsWith("####")) {
                        scl = 1.1f;
                    } else if (lnt.startsWith("###")) {
                        scl = 1.2f;
                    } else if (lnt.startsWith("##")) {
                        scl = 1.5f;
                    } else if (lnt.startsWith("#")) {
                        scl = 2.0f;
                    }
                    String h = lnt.replaceAll("^#+", "").trim();
                    sb.append(h);
                    Line line = this.parseLine(sb, scl, prefix);
                    if (nextHeaderName != null) {
                        this.headerLines.put(line, nextHeaderName);
                    } else {
                        this.headerLines.put(line, h.replaceAll("[^a-zA-Z0-9_\\-\\s]", "").replaceAll("[\\s\\-]", "-").toLowerCase(Locale.ROOT));
                    }
                    nextHeaderName = null;
                    if (scl > 1.3f) {
                        this.lines.add(new HorizontalLine());
                    } else {
                        this.lines.add(new EmptyLine(4));
                    }
                } else if (ln.startsWith("---") || ln.startsWith("***") || ln.startsWith("__")) {
                    this.parseLine(sb, 1.0f, prefix);
                    this.lines.add(new HorizontalLine());
                } else if (lnt.startsWith("[")) {
                    int j;
                    for (j = 0; j < lnt.length() && lnt.charAt(j) != ']'; ++j) {
                    }
                    if (MarkdownParser.at(lnt, j + 1) == ':') {
                        this.parseLine(sb, 1.0f, prefix);
                        String lnk = lnt.substring(1, j).toLowerCase(Locale.ROOT);
                        LinkReference ref = this.linkReferences.get(lnk);
                        if (ref != null) {
                            if (lnk.startsWith("^")) {
                                sb.append(lnt.substring(j + 2).trim());
                                prefix.add(new TextComponent(new StringBuilder(lnk + ": "), new TextStyle()));
                                Line line = this.parseLine(sb, 0.9f, prefix);
                                this.headerLines.put(line, "footnote_" + lnk);
                                ref.setLink("#footnote_" + lnk);
                                lastIndent = new IndentComponent();
                                lastIndent.setX(10);
                                continue;
                            }
                            String val = lnt.substring(j + 2).trim();
                            ref.setLink(val);
                        }
                    } else if (ln.endsWith("  ")) {
                        sb.append(lnt);
                        this.parseLine(sb, 1.0f, prefix);
                    } else {
                        if (sb.length() > 0) {
                            sb.append(' ');
                        }
                        sb.append(lnt);
                    }
                } else {
                    if (lnt.startsWith("- ") || lnt.startsWith("* ") || lnt.startsWith("+ ")) {
                        this.parseLine(sb, 1.0f, prefix);
                        for (int indC = 0; indC < ln.length() && ln.charAt(indC) == ' '; ++indC) {
                        }
                        lastIndent = new IndentComponent();
                        prefix.add(new ListComponent(indC /= 2, null, lastIndent));
                        sb.append(lnt.substring(1).trim());
                        if (!ln.endsWith("  ")) continue;
                        this.parseLine(sb, 1.0f, prefix);
                        continue;
                    }
                    if (LIST.matcher(lnt).matches()) {
                        int indC;
                        this.parseLine(sb, 1.0f, prefix);
                        for (indC = 0; indC < ln.length() && ln.charAt(indC) == ' '; ++indC) {
                        }
                        indC /= 2;
                        Matcher m = LIST.matcher(lnt);
                        m.find();
                        String num = m.group(1);
                        lastIndent = new IndentComponent();
                        prefix.add(new ListComponent(indC, m.group(1) + ". ", lastIndent));
                        sb.append(lnt.substring(num.length() + 1).trim());
                        if (!ln.endsWith("  ")) continue;
                        this.parseLine(sb, 1.0f, prefix);
                        continue;
                    }
                    if (ln.endsWith("  ")) {
                        if (ln.startsWith("  ") && lastIndent != null && !prefix.contains(lastIndent)) {
                            prefix.add(lastIndent);
                        }
                        sb.append(lnt);
                        this.parseLine(sb, 1.0f, prefix);
                    } else {
                        if (sb.length() > 0) {
                            sb.append(' ');
                        }
                        sb.append(lnt);
                    }
                }
                if (!ln.startsWith("  ") || lastIndent == null || prefix.contains(lastIndent)) continue;
                prefix.add(lastIndent);
            }
            this.parseLine(sb, 1.0f, prefix);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int toElements(MarkdownRenderer mdr, int width, Consumer<List<GuiElement>> elementAdder, Map<String, Integer> header) {
        Cursor c = new Cursor();
        c.maxWidth = width;
        this.lines.forEach(l -> {
            String h = this.headerLines.get(l);
            if (h != null) {
                header.put(h, c.y);
            }
            elementAdder.accept(l.toElements(mdr, c));
        });
        return c.y;
    }

    private Line parseLine(StringBuilder sb, float scl, List<Component> prefix) {
        Line ln = MarkdownParser.parseLine(sb, scl, prefix, this);
        this.lines.add(ln);
        return ln;
    }

    private static Line parseLine(StringBuilder sb, float scl, List<Component> prefix, MarkdownParser parser) {
        if (sb.length() == 0 && (prefix == null || prefix.isEmpty())) {
            return NULL_LINE;
        }
        String text = sb.toString();
        sb.setLength(0);
        ArrayList<Component> comp = new ArrayList<Component>();
        if (prefix != null) {
            comp.addAll(prefix);
            prefix.clear();
        }
        TextStyle current = new TextStyle();
        HashMap<Integer, TextStyle> styleEnd = new HashMap<Integer, TextStyle>();
        for (int i = 0; i < text.length(); ++i) {
            LinkReference ref;
            int j;
            boolean foundEnd;
            if (styleEnd.containsKey(i)) {
                if (sb.length() > 0) {
                    comp.add(new TextComponent(sb, current));
                }
                current = (TextStyle)styleEnd.get(i);
                continue;
            }
            char c = text.charAt(i);
            if (c == '\\') {
                char n = MarkdownParser.at(text, i + 1);
                if (ESC_CHARS.indexOf(n) > -1) {
                    sb.append(n);
                    ++i;
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (c == '*' || c == '_') {
                if (c == MarkdownParser.at(text, i + 1)) {
                    foundEnd = false;
                    int m = -1;
                    for (int j2 = i + 1; j2 < text.length(); ++j2) {
                        if (styleEnd.containsKey(j2) || text.charAt(j2) != c) continue;
                        m = j2;
                        if (MarkdownParser.at(text, j2 + 1) != c) continue;
                        foundEnd = true;
                        break;
                    }
                    if (foundEnd) {
                        styleEnd.put(m, current);
                        styleEnd.put(m + 1, new TextStyle(current));
                        comp.add(new TextComponent(sb, current));
                        current.bold = !current.bold;
                        ++i;
                        sb.setLength(0);
                        continue;
                    }
                    if (m != -1) {
                        sb.append(c);
                        styleEnd.put(m, new TextStyle(current));
                        comp.add(new TextComponent(sb, current));
                        current.italic = !current.italic;
                        sb.setLength(0);
                        continue;
                    }
                    sb.append(c);
                    continue;
                }
                foundEnd = false;
                int m = -1;
                for (int j3 = i + 1; j3 < text.length(); ++j3) {
                    if (styleEnd.containsKey(j3) || text.charAt(j3) != c) continue;
                    foundEnd = true;
                    m = j3;
                    break;
                }
                if (foundEnd) {
                    styleEnd.put(m, new TextStyle(current));
                    comp.add(new TextComponent(sb, current));
                    current.italic = !current.italic;
                    sb.setLength(0);
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (c == '~' && MarkdownParser.at(text, i + 1) == '~') {
                foundEnd = false;
                int m = -1;
                for (int j4 = i + 1; j4 < text.length(); ++j4) {
                    if (styleEnd.containsKey(j4) || text.charAt(j4) != c || MarkdownParser.at(text, j4 + 1) != c) continue;
                    m = j4;
                    foundEnd = true;
                    break;
                }
                if (foundEnd) {
                    styleEnd.put(m, current);
                    styleEnd.put(m + 1, new TextStyle(current));
                    comp.add(new TextComponent(sb, current));
                    current.strikethrough = !current.strikethrough;
                    sb.setLength(0);
                } else {
                    sb.append(c);
                    sb.append(c);
                }
                ++i;
                continue;
            }
            if (c == '!' && MarkdownParser.at(text, i + 1) == '[') {
                comp.add(new TextComponent(sb, current));
                sb.setLength(0);
                j = i++;
                ++i;
                while (i < text.length() && text.charAt(i) != ']') {
                    sb.append(text.charAt(i));
                    ++i;
                }
                String alt = sb.toString();
                sb.setLength(0);
                if (MarkdownParser.at(text, i + 1) == '(') {
                    ++i;
                    ++i;
                    while (i < text.length() && text.charAt(i) != ')') {
                        sb.append(text.charAt(i));
                        ++i;
                    }
                    String lnk = sb.toString();
                    sb.setLength(0);
                    comp.add(new ImageComponent(alt, new LinkReference(lnk)));
                    continue;
                }
                if (MarkdownParser.at(text, i + 1) == '[') {
                    ++i;
                    ++i;
                    while (i < text.length() && text.charAt(i) != ']') {
                        sb.append(text.charAt(i));
                        ++i;
                    }
                    String lnk = sb.toString();
                    sb.setLength(0);
                    ref = LinkReference.getRef(parser, lnk);
                    comp.add(new ImageComponent(alt, ref));
                    continue;
                }
                i = j + 1;
                sb.append("![");
                continue;
            }
            if (c == '$' && MarkdownParser.at(text, i + 1) == '[') {
                comp.add(new TextComponent(sb, current));
                sb.setLength(0);
                j = i++;
                ++i;
                while (i < text.length() && text.charAt(i) != ']') {
                    sb.append(text.charAt(i));
                    ++i;
                }
                String id = sb.toString();
                sb.setLength(0);
                if (MarkdownParser.at(text, i + 1) == '(') {
                    ++i;
                    ++i;
                    while (i < text.length() && text.charAt(i) != ')') {
                        sb.append(text.charAt(i));
                        ++i;
                    }
                    String args = sb.toString();
                    sb.setLength(0);
                    comp.add(new CustomComponent(id, args));
                    continue;
                }
                i = j + 1;
                sb.append("$[");
                continue;
            }
            if (c == '[') {
                comp.add(new TextComponent(sb, current));
                sb.setLength(0);
                j = i++;
                while (i < text.length() && text.charAt(i) != ']') {
                    sb.append(text.charAt(i));
                    ++i;
                }
                String lnkText = sb.toString();
                sb.setLength(0);
                if (MarkdownParser.at(text, i + 1) == '(') {
                    ++i;
                    ++i;
                    while (i < text.length() && text.charAt(i) != ')') {
                        sb.append(text.charAt(i));
                        ++i;
                    }
                    String lnk = sb.toString();
                    sb.setLength(0);
                    comp.add(new LinkComponent(lnkText, new LinkReference(lnk)));
                    continue;
                }
                if (MarkdownParser.at(text, i + 1) == '[') {
                    ++i;
                    ++i;
                    while (i < text.length() && text.charAt(i) != ']') {
                        sb.append(text.charAt(i));
                        ++i;
                    }
                    String lnk = sb.toString();
                    sb.setLength(0);
                    ref = LinkReference.getRef(parser, lnk);
                    comp.add(new LinkComponent(lnkText, ref));
                    continue;
                }
                if (lnkText.startsWith("^")) {
                    LinkReference ref2 = LinkReference.getRef(parser, lnkText);
                    comp.add(new ScaledComponent(0.5f, 0, new LinkComponent("[" + lnkText.substring(1) + "]", ref2)));
                    continue;
                }
                i = j;
                sb.append("[");
                continue;
            }
            if (c == '`') {
                comp.add(new TextComponent(sb, current));
                sb.setLength(0);
                ++i;
                while (i < text.length() && text.charAt(i) != '`') {
                    char ch = text.charAt(i);
                    if (ch == '&') {
                        i = MarkdownParser.parseEscape(i, text, sb);
                    } else {
                        sb.append(ch);
                    }
                    ++i;
                }
                comp.add(new CodeComponent(sb));
                continue;
            }
            if (c == '&') {
                i = MarkdownParser.parseEscape(i, text, sb);
                continue;
            }
            sb.append(c);
        }
        comp.add(new TextComponent(sb, current));
        sb.setLength(0);
        ComponentLine line = new ComponentLine(comp, scl);
        return line;
    }

    private static int parseEscape(int i, String text, StringBuilder sb) {
        int j = i++;
        while (i < text.length() && text.charAt(i) != ';') {
            ++i;
        }
        if (MarkdownParser.at(text, i) == ';') {
            if (MarkdownParser.at(text, j + 1) == '#') {
                try {
                    char ch = MarkdownParser.at(text, j + 2) == 'X' || MarkdownParser.at(text, j + 2) == 'x' ? (char)Integer.parseInt(text.substring(j + 3, i), 16) : (char)Integer.parseInt(text.substring(j + 2, i), 10);
                    sb.append(ch);
                }
                catch (NumberFormatException e) {
                    i = j;
                    sb.append('&');
                }
            } else {
                Character ec = htmlEscapeEntities.get(text.substring(j + 1, i));
                if (ec != null) {
                    sb.append(ec);
                } else {
                    i = j;
                    sb.append('&');
                }
            }
        } else {
            i = j;
            sb.append('&');
        }
        return i;
    }

    private static char at(String s, int i) {
        if (s.length() > i) {
            return s.charAt(i);
        }
        return '\u0000';
    }

    public static List<GuiElement> linewrapSimple(String textIn, Cursor cursor, Function<String, GuiElement> lbl, ToIntFunction<String> width) {
        return MarkdownParser.linewrap(textIn, cursor, Function.identity(), lbl, width);
    }

    public static <T> List<GuiElement> linewrap(String textIn, Cursor cursor, Function<String, T> toText, Function<T, GuiElement> lbl, ToIntFunction<T> width) {
        ArrayList<GuiElement> text = new ArrayList<GuiElement>();
        int splitStart = 0;
        int space = -1;
        float h = 10.0f * cursor.scale;
        for (int i = 0; i < textIn.length(); ++i) {
            char c = textIn.charAt(i);
            if (c != ' ') continue;
            T s = toText.apply(textIn.substring(splitStart, i));
            float lw = (float)width.applyAsInt(s) * cursor.scale;
            if ((float)cursor.x + lw > (float)cursor.maxWidth) {
                if (space != -1 || cursor.x <= cursor.maxWidth / 2) {
                    if (splitStart == space + 1) {
                        text.add(lbl.apply(s).setBounds(cursor.bounds(lw, h)));
                        splitStart = i + 1;
                    } else {
                        s = toText.apply(textIn.substring(splitStart, space));
                        text.add(lbl.apply(s).setBounds(cursor.bounds(lw, h)));
                        splitStart = space + 1;
                    }
                }
                cursor.x = cursor.xStart;
                cursor.y = (int)((float)cursor.y + cursor.scale * 10.0f);
            }
            space = i;
        }
        T s = toText.apply(textIn.substring(splitStart, textIn.length()));
        float lw = (float)width.applyAsInt(s) * cursor.scale;
        if ((float)cursor.x + lw > (float)cursor.maxWidth && space != -1) {
            if (splitStart == space + 1) {
                text.add(lbl.apply(s).setBounds(cursor.bounds(lw, h)));
                splitStart = textIn.length();
            } else {
                s = toText.apply(textIn.substring(splitStart, space));
                text.add(lbl.apply(s).setBounds(cursor.bounds(lw, h)));
                splitStart = space + 1;
            }
            cursor.x = cursor.xStart;
            cursor.y = (int)((float)cursor.y + cursor.scale * 10.0f);
        }
        if (splitStart < textIn.length()) {
            s = toText.apply(textIn.substring(splitStart, textIn.length()));
            lw = (float)width.applyAsInt(s) * cursor.scale;
            if ((float)cursor.x + lw > (float)cursor.maxWidth && (space == -1 && cursor.x > cursor.maxWidth / 2 || space != -1)) {
                cursor.x = cursor.xStart;
                cursor.y = (int)((float)cursor.y + cursor.scale * 10.0f);
            }
            text.add(lbl.apply(s).setBounds(cursor.bounds(lw, h)));
            cursor.x = (int)((float)cursor.x + lw);
        }
        return text;
    }

    public static <T> List<GuiElement> linewrapStyled(String textIn, Cursor cursor, TextStyle style, Function<IText, GuiElement> lbl, ToIntFunction<IText> width) {
        return MarkdownParser.linewrap(textIn, cursor, t -> new StyledText(new LiteralText((String)t), style), lbl, width);
    }

    static {
        htmlEscapeEntities.put("amp", Character.valueOf('&'));
        htmlEscapeEntities.put("lt", Character.valueOf('<'));
        htmlEscapeEntities.put("gt", Character.valueOf('>'));
        htmlEscapeEntities.put("quot", Character.valueOf('\"'));
        htmlEscapeEntities.put("apos", Character.valueOf('\''));
    }

    private static interface Line {
        public List<GuiElement> toElements(MarkdownRenderer var1, Cursor var2);
    }

    private static class CodeLine
    implements Line {
        private String[] code;
        private String lang;
        private String c;

        public CodeLine(String lang, String code) {
            this.code = code.split("\n");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.code.length; ++i) {
                String ln = this.code[i];
                for (int j = 0; j < ln.length(); ++j) {
                    char c = ln.charAt(j);
                    if (c == '\t') {
                        int s = 4 - j % 4;
                        for (int k = 0; k < s; ++k) {
                            sb.append(' ');
                        }
                        continue;
                    }
                    sb.append(c);
                }
                this.code[i] = sb.toString();
                sb.setLength(0);
            }
            this.c = code;
            this.lang = lang;
        }

        @Override
        public List<GuiElement> toElements(MarkdownRenderer mdr, Cursor cursor) {
            Code c = new Code(mdr.getGui(), this.lang, this.c, this.code, cursor.bounds(cursor.maxWidth, this.code.length * 10 + 8));
            cursor.y += this.code.length * 10 + 15;
            return Arrays.asList(c);
        }

        private static class Code
        extends Panel {
            public Code(IGui gui, String lang, String c, final String[] code, Box b) {
                super(gui);
                this.setBounds(b);
                Panel p = new Panel(gui);
                p.setBackgroundColor(gui.getColors().button_fill);
                ScrollPanel scp = new ScrollPanel(gui);
                this.addElement(scp);
                scp.setDisplay(p);
                scp.setBounds(new Box(0, 0, b.w, b.h));
                int w = Arrays.stream(code).mapToInt(gui::textWidth).max().orElse(0) + 5;
                if (w > this.bounds.w - 52) {
                    w += 55;
                }
                p.setBounds(new Box(0, 0, w, b.h - 4));
                p.addElement(new GuiElement(gui){

                    @Override
                    public void draw(MouseEvent event, float partialTicks) {
                        int x = this.bounds.x + 3;
                        int y = this.bounds.y + 5;
                        int c = this.gui.getColors().label_text_color;
                        for (int i = 0; i < code.length; ++i) {
                            this.gui.drawText(x, y + i * 10, code[i], c);
                        }
                    }
                }.setBounds(new Box(0, 0, w, b.h - 4)));
                Button cpy = new Button(gui, gui.i18nFormat("button.cpm.copy", new Object[0]), () -> gui.setClipboardText(c));
                cpy.setBounds(new Box(this.bounds.w - 52, 3, 50, 12));
                this.addElement(cpy);
            }
        }
    }

    private static class EmptyLine
    implements Line {
        private int height;

        public EmptyLine(int height) {
            this.height = height;
        }

        @Override
        public List<GuiElement> toElements(MarkdownRenderer mdr, Cursor cursor) {
            cursor.y += this.height;
            return Collections.emptyList();
        }
    }

    private static class TableLine
    implements Line {
        private Line[][] table;
        private Align[] colAlign;
        private int cols;

        public TableLine(List<String> lines, MarkdownParser parser) {
            try {
                String[][] table = (String[][])lines.stream().map(l -> (String[])Arrays.stream(l.substring(1, l.length() - 1).split("\\|")).map(String::trim).toArray(String[]::new)).toArray(x$0 -> new String[x$0][]);
                this.cols = table[0].length;
                this.table = new ComponentLine[table.length - 1][this.cols];
                this.colAlign = new Align[this.cols];
                Arrays.fill((Object[])this.colAlign, (Object)Align.LEFT);
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < table.length; ++i) {
                    int j;
                    String[] c = table[i];
                    if (i == 1) {
                        for (j = 0; j < this.cols; ++j) {
                            String align = c[j];
                            boolean left = align.startsWith(":");
                            boolean right = align.endsWith(":");
                            if (left && right) {
                                this.colAlign[j] = Align.CENTER;
                                continue;
                            }
                            if (!right) continue;
                            this.colAlign[j] = Align.RIGHT;
                        }
                        continue;
                    }
                    for (j = 0; j < this.cols; ++j) {
                        String txt = c[j];
                        sb.append(txt);
                        this.table[i == 0 ? 0 : i - 1][j] = MarkdownParser.parseLine(sb, 1.0f, null, parser);
                    }
                }
            }
            catch (Exception e) {
                Log.warn("Error parsing markdown table", e);
                this.table = null;
            }
        }

        @Override
        public List<GuiElement> toElements(MarkdownRenderer mdr, Cursor cursor) {
            if (this.table == null) {
                Label l = new Label(mdr.getGui(), "Error parsing table in Markdown");
                l.setBounds(cursor.bounds(0.0f, 0.0f));
                l.setColor(-65536);
                cursor.y += 10;
                return Arrays.asList(l);
            }
            return Arrays.asList(new Table(mdr, cursor));
        }

        private static enum Align {
            LEFT,
            CENTER,
            RIGHT;

        }

        private class Table
        extends Panel {
            public Table(MarkdownRenderer mdr, Cursor cursor) {
                super(mdr.getGui());
                Panel[] ps = new Panel[TableLine.this.cols];
                int y = 1;
                int mw = (cursor.maxWidth - 1) / TableLine.this.cols;
                for (int i = 0; i < TableLine.this.table.length; ++i) {
                    int j;
                    Line[] lines = TableLine.this.table[i];
                    int mh = 0;
                    for (j = 0; j < lines.length; ++j) {
                        Panel p;
                        Line line = lines[j];
                        ps[j] = p = new Panel(this.gui);
                        p.setBackgroundColor(i == 0 ? this.gui.getColors().menu_bar_background : (i % 2 == 0 ? this.gui.getColors().button_fill : this.gui.getColors().button_border));
                        Cursor c = new Cursor();
                        c.maxWidth = mw - 1;
                        c.y = 1;
                        p.getElements().addAll(line.toElements(mdr, c));
                        mh = Math.max(mh, c.y);
                        this.addElement(p);
                    }
                    for (j = 0; j < ps.length; ++j) {
                        ps[j].setBounds(new Box(1 + j * mw, y, mw - 1, mh));
                    }
                    y += mh;
                    ++y;
                }
                this.setBounds(cursor.bounds(mw * TableLine.this.cols + 1, y));
                this.setBackgroundColor(this.gui.getColors().popup_background);
                cursor.y += y + 10;
            }
        }
    }

    private static class QuoteLine
    implements Line {
        private Line[] lines;
        private QuoteNote header;

        public QuoteLine(List<String> t, MarkdownParser parser) {
            try {
                String header = t.get(0);
                if (header.startsWith("> [!")) {
                    int i = header.indexOf(33);
                    header = header.substring(i + 1);
                    i = header.indexOf(93);
                    header = header.substring(0, i);
                    t.remove(0);
                    for (QuoteNote q : QuoteNote.values()) {
                        if (!q.name().equalsIgnoreCase(header)) continue;
                        this.header = q;
                        break;
                    }
                }
                this.lines = new ComponentLine[t.size()];
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < t.size(); ++i) {
                    String txt = t.get(i);
                    sb.append(txt, 2, txt.length());
                    this.lines[i] = MarkdownParser.parseLine(sb, 1.0f, null, parser);
                }
            }
            catch (Exception e) {
                Log.warn("Error parsing markdown quote", e);
                this.lines = null;
            }
        }

        @Override
        public List<GuiElement> toElements(MarkdownRenderer mdr, Cursor cursor) {
            if (this.lines == null) {
                Label l = new Label(mdr.getGui(), "Error parsing quote in Markdown");
                l.setBounds(cursor.bounds(0.0f, 0.0f));
                l.setColor(-65536);
                cursor.y += 10;
                return Arrays.asList(l);
            }
            return Arrays.asList(new QuoteBlock(mdr, cursor));
        }

        public static enum QuoteNote {
            NOTE(g -> -13663753),
            TIP(g -> -12601008),
            IMPORTANT(g -> -6065673),
            WARNING(g -> -2975454),
            CAUTION(g -> -503479);

            private Function<IGui, Integer> color;

            private QuoteNote(Function<IGui, Integer> color) {
                this.color = color;
            }
        }

        private class QuoteBlock
        extends Panel {
            public QuoteBlock(MarkdownRenderer mdr, Cursor cursor) {
                super(mdr.getGui());
                int mw = cursor.maxWidth - 1;
                Panel p = new Panel(this.gui);
                Cursor c = new Cursor();
                c.maxWidth = mw - 10;
                for (int j = 0; j < QuoteLine.this.lines.length; ++j) {
                    Line line = QuoteLine.this.lines[j];
                    p.getElements().addAll(line.toElements(mdr, c));
                }
                int h = QuoteLine.this.header != null ? 21 : 0;
                p.setBounds(new Box(6, h, mw - 10, c.y));
                this.addElement(p);
                this.setBounds(cursor.bounds(mw + 1, c.y + h + 2));
                cursor.y += c.y + h + 10;
            }

            @Override
            public void draw(MouseEvent event, float partialTicks) {
                this.gui.pushMatrix();
                this.gui.setPosOffset(this.getBounds());
                this.gui.setupCut();
                Box bounds = this.getBounds();
                int rgb = this.gui.getColors().popup_background;
                if (QuoteLine.this.header != null) {
                    rgb = QuoteLine.this.header.color.apply(this.gui);
                    this.gui.drawBox(1, 1, 2, bounds.h - 1, this.gui.getColors().popup_background);
                    String note = this.gui.i18nFormat("label.cpm.md.quote." + QuoteLine.this.header.name().toLowerCase(Locale.ROOT), new Object[0]);
                    this.gui.drawTexture(4, 2, 16, 16, QuoteLine.this.header.ordinal() * 16, 96, "editor", rgb);
                    this.gui.drawText(25, 7, note, this.gui.getColors().popup_background);
                    this.gui.drawText(24, 6, note, rgb);
                }
                this.gui.drawBox(0, 0, 2, bounds.h - 2, rgb);
                for (GuiElement guiElement : this.elements) {
                    if (!guiElement.isVisible()) continue;
                    guiElement.draw(event.offset(bounds), partialTicks);
                }
                this.gui.popMatrix();
                this.gui.setupCut();
            }
        }
    }

    private static class HorizontalLine
    implements Line {
        private HorizontalLine() {
        }

        @Override
        public List<GuiElement> toElements(MarkdownRenderer mdr, Cursor cursor) {
            cursor.y += 4;
            return Arrays.asList(new HLine(mdr.getGui()).setBounds(cursor.bounds(0, -4, cursor.maxWidth, 1)));
        }

        private static class HLine
        extends GuiElement {
            public HLine(IGui gui) {
                super(gui);
            }

            @Override
            public void draw(MouseEvent event, float partialTicks) {
                this.gui.drawBox(this.bounds.x, this.bounds.y, this.bounds.w, 1, this.gui.getColors().button_disabled);
            }
        }
    }

    private static class LinkReference {
        private String url;
        private String tooltip;

        private LinkReference() {
        }

        public LinkReference(String url) {
            this.setLink(url);
        }

        public static LinkReference getRef(MarkdownParser parser, String id) {
            return parser.linkReferences.computeIfAbsent(id.toLowerCase(Locale.ROOT), __ -> new LinkReference());
        }

        public void setLink(String url) {
            this.url = url;
            if (url.endsWith("\"")) {
                String[] sp = url.split(" \"", 2);
                this.url = sp[0];
                this.tooltip = sp[1];
                this.tooltip = this.tooltip.substring(0, this.tooltip.length() - 1);
            }
        }
    }

    private static class TextComponent
    implements Component {
        private String text;
        private TextStyle style;

        public TextComponent(StringBuilder text, TextStyle style) {
            this.text = text.toString();
            text.setLength(0);
            this.style = new TextStyle(style);
        }

        @Override
        public List<GuiElement> toElements(MarkdownRenderer mdr, Cursor cursor) {
            IGui gui = mdr.getGui();
            return MarkdownParser.linewrapStyled(this.text, cursor, this.style, s -> new LabelText(gui, (IText)s).setScale(cursor.scale), gui::textWidthFormatted);
        }
    }

    private static class IndentComponent
    implements Component {
        private int x;

        private IndentComponent() {
        }

        public void setX(int x) {
            this.x = x;
        }

        @Override
        public List<GuiElement> toElements(MarkdownRenderer mdr, Cursor cursor) {
            cursor.x += this.x;
            cursor.xStart = this.x;
            return Collections.emptyList();
        }
    }

    private static class ListComponent
    implements Component {
        private int sub;
        private String h;
        private IndentComponent indent;

        public ListComponent(int sub, String h, IndentComponent indent) {
            this.sub = sub;
            this.h = h;
            this.indent = indent;
        }

        @Override
        public List<GuiElement> toElements(MarkdownRenderer mdr, Cursor cursor) {
            int w = this.h == null ? 10 : mdr.getGui().textWidth(this.h);
            this.indent.setX(5 + this.sub * 15 + w);
            cursor.x = 5 + this.sub * 15;
            cursor.xStart = cursor.x + w;
            GuiElement he = this.h != null ? new Label(mdr.getGui(), this.h) : new BulletPoint(mdr.getGui(), Math.min(this.sub, 3));
            List<GuiElement> l = Arrays.asList(he.setBounds(cursor.bounds(0.0f, 0.0f)));
            cursor.x += w;
            return l;
        }

        private static class BulletPoint
        extends GuiElement {
            private int i;

            public BulletPoint(IGui gui, int i) {
                super(gui);
                this.i = i;
            }

            @Override
            public void draw(MouseEvent event, float partialTicks) {
                this.gui.drawTexture(this.bounds.x, this.bounds.y, 8, 8, 48 + this.i % 2 * 8, this.i / 2 * 8, "editor");
            }
        }
    }

    public static class Cursor {
        public int maxWidth;
        public int x;
        public int y;
        public int xStart;
        public float scale = 1.0f;

        public Box bounds(float w, float h) {
            return new Box(this.x, this.y, (int)w, (int)h);
        }

        public Box bounds(int x, int y, int w, int h) {
            return new Box(x, this.y + y, w, h);
        }
    }

    private static class ImageComponent
    implements Component {
        private LinkReference ref;
        private String altText;
        private Vec2i size = new Vec2i();
        private Tooltip error;

        public ImageComponent(String altText, LinkReference ref) {
            this.altText = altText;
            this.ref = ref;
        }

        @Override
        public List<GuiElement> toElements(MarkdownRenderer mdr, Cursor cursor) {
            IGui gui = mdr.getGui();
            Img i = new Img(gui);
            if (this.ref.tooltip != null) {
                i.tooltip = new Tooltip(gui.getFrame(), this.ref.tooltip);
            }
            if (this.ref.url != null) {
                boolean[] refresh = new boolean[]{false};
                ((CompletableFuture)mdr.getLoader().loadImage(this.ref.url).thenAcceptAsync(img -> {
                    if (this.size.x == 0) {
                        this.size.x = img.getWidth();
                        this.size.y = img.getHeight();
                        if (refresh[0]) {
                            mdr.refresh();
                            return;
                        }
                    }
                    TextureProvider p = new TextureProvider((Image)img, new Vec2i());
                    mdr.registerCleanup(p::free);
                    i.pr = p;
                    this.error = null;
                }, gui::executeLater)).exceptionally(e -> {
                    this.size.x = 16;
                    this.size.y = 16;
                    this.error = new Tooltip(gui.getFrame(), gui.i18nFormat("tooltip.cpm.failedToLoadImage", e.getMessage()));
                    return null;
                });
                refresh[0] = true;
            } else {
                this.error = new Tooltip(gui.getFrame(), gui.i18nFormat("tooltip.cpm.failedToLoadImage", "Invalid image URL"));
            }
            if (this.error != null) {
                float s = cursor.scale;
                Tooltip tt = this.error;
                return MarkdownParser.linewrapSimple(this.altText, cursor, t -> new Alt(mdr.getGui(), (String)t, s, tt), mdr.getGui()::textWidth);
            }
            if (this.size.x > cursor.maxWidth) {
                float sc = (float)this.size.x / (float)cursor.maxWidth;
                this.size.x = cursor.maxWidth;
                this.size.y = (int)((float)this.size.y / sc);
            }
            i.setBounds(cursor.bounds(this.size.x, this.size.y));
            cursor.x += this.size.x + 1;
            cursor.y += this.size.y + 1;
            return Arrays.asList(i);
        }

        private static class Img
        extends GuiElement {
            private Tooltip tooltip;
            private TextureProvider pr;
            private boolean error;

            public Img(IGui gui) {
                super(gui);
            }

            @Override
            public void draw(MouseEvent event, float partialTicks) {
                if (event.isHovered(this.bounds) && this.tooltip != null) {
                    this.tooltip.set();
                }
                if (this.error) {
                    this.gui.drawBox(this.bounds.x, this.bounds.y, this.bounds.w, this.bounds.h, -65536);
                } else if (this.pr != null) {
                    this.pr.bind();
                    this.gui.drawTexture(this.bounds.x, this.bounds.y, this.bounds.w, this.bounds.h, 0.0f, 0.0f, 1.0f, 1.0f);
                } else {
                    this.gui.drawBox(this.bounds.x, this.bounds.y, this.bounds.w, this.bounds.h, this.gui.getColors().button_fill);
                }
            }
        }

        private static class Alt
        extends GuiElement {
            private LiteralText txt;
            private float scale;
            private Tooltip tt;

            public Alt(IGui gui, String text, float scale, Tooltip tt) {
                super(gui);
                this.txt = new LiteralText(text);
                this.scale = scale;
                this.tt = tt;
            }

            @Override
            public void draw(MouseEvent event, float partialTicks) {
                if (this.tt != null && event.isHovered(this.bounds)) {
                    this.tt.set();
                }
                this.gui.drawFormattedText(this.bounds.x, this.bounds.y, this.txt, this.gui.getColors().label_text_color, this.scale);
            }
        }
    }

    private static class CustomComponent
    implements Component {
        private String id;
        private String args;

        public CustomComponent(String id, String args) {
            this.id = id;
            this.args = args;
        }

        @Override
        public List<GuiElement> toElements(MarkdownRenderer mdr, Cursor cursor) {
            MarkdownRenderer.CustomMdElementFactory f = mdr.customElementFactories.get(this.id);
            if (f == null) {
                Label lbl = new Label(mdr.getGui(), "??");
                lbl.setBounds(cursor.bounds(10.0f, 10.0f));
                lbl.setColor(0xFF0000);
                lbl.setTooltip(new Tooltip(mdr.getGui().getFrame(), "Unknown custom component: " + this.id));
                cursor.x += 10;
                return Arrays.asList(lbl);
            }
            return f.create(mdr, cursor, this.args);
        }
    }

    private static class LinkComponent
    implements Component {
        protected LinkReference ref;
        protected String text;

        public LinkComponent(String text, LinkReference ref) {
            this.text = text;
            this.ref = ref;
        }

        @Override
        public List<GuiElement> toElements(MarkdownRenderer mdr, Cursor cursor) {
            float s = cursor.scale;
            String url = this.ref.url;
            Runnable click = () -> mdr.browse(url);
            ArrayList hovers = new ArrayList();
            Tooltip tt = this.ref.tooltip != null ? new Tooltip(mdr.getGui().getFrame(), this.ref.tooltip) : null;
            return MarkdownParser.linewrapSimple(this.text, cursor, t -> new Lbl(mdr.getGui(), (String)t, click, s, hovers, tt), mdr.getGui()::textWidth);
        }

        private static class Lbl
        extends GuiElement {
            private LiteralText txt;
            private float scale;
            private Runnable click;
            private List<Predicate<MouseEvent>> hovers;
            private Tooltip tt;

            public Lbl(IGui gui, String text, Runnable click, float scale, List<Predicate<MouseEvent>> hovers, Tooltip tt) {
                super(gui);
                this.txt = new LiteralText(text);
                this.scale = scale;
                this.click = click;
                this.hovers = hovers;
                this.tt = tt;
                hovers.add(e -> e.isHovered(this.bounds));
            }

            @Override
            public void draw(MouseEvent event, float partialTicks) {
                if (this.tt != null && event.isHovered(this.bounds)) {
                    this.tt.set();
                }
                this.gui.drawFormattedText(this.bounds.x, this.bounds.y, this.txt, this.hovers.stream().anyMatch(p -> p.test(event)) ? this.gui.getColors().link_hover : this.gui.getColors().link_normal, this.scale);
            }

            @Override
            public void mouseClick(MouseEvent event) {
                if (event.isHovered(this.bounds) && event.btn == 0) {
                    this.click.run();
                }
            }
        }
    }

    private static class ScaledComponent
    implements Component {
        private float scale;
        private int yOff;
        private Component component;

        public ScaledComponent(float scale, int yOff, Component component) {
            this.scale = scale;
            this.yOff = yOff;
            this.component = component;
        }

        @Override
        public List<GuiElement> toElements(MarkdownRenderer mdr, Cursor cursor) {
            Cursor c = new Cursor();
            c.x = cursor.x;
            c.scale = cursor.scale * this.scale;
            c.y = cursor.y + this.yOff;
            c.xStart = cursor.xStart;
            c.maxWidth = (int)((float)cursor.maxWidth / this.scale);
            List<GuiElement> el = this.component.toElements(mdr, c);
            cursor.x = c.x;
            cursor.y = c.y;
            return el;
        }
    }

    private static interface Component {
        public List<GuiElement> toElements(MarkdownRenderer var1, Cursor var2);
    }

    private static class CodeComponent
    implements Component {
        private String text;

        public CodeComponent(StringBuilder text) {
            this.text = text.toString();
            text.setLength(0);
        }

        @Override
        public List<GuiElement> toElements(MarkdownRenderer mdr, Cursor cursor) {
            float s = cursor.scale;
            return MarkdownParser.linewrapSimple(this.text, cursor, t -> new Lbl(mdr.getGui(), (String)t, s), mdr.getGui()::textWidth);
        }

        private static class Lbl
        extends GuiElement {
            private String text;
            private LiteralText txt;
            private float scale;

            public Lbl(IGui gui, String text, float scale) {
                super(gui);
                this.text = text;
                this.txt = new LiteralText(text);
                this.scale = scale;
            }

            @Override
            public void draw(MouseEvent event, float partialTicks) {
                this.gui.drawBox((float)this.bounds.x, (float)(this.bounds.y - 1), (float)this.gui.textWidth(this.text) * this.scale, this.scale * 10.0f, this.gui.getColors().button_fill);
                this.gui.drawFormattedText(this.bounds.x, this.bounds.y, this.txt, this.gui.getColors().label_text_color, this.scale);
            }
        }
    }

    private static class ComponentLine
    implements Line {
        private List<Component> components;
        private float scale;

        public ComponentLine(List<Component> components, float scale) {
            this.components = components;
            this.scale = scale;
        }

        public String toString() {
            return this.scale + " " + this.components.toString();
        }

        @Override
        public List<GuiElement> toElements(MarkdownRenderer mdr, Cursor cursor) {
            Cursor sc = new Cursor();
            sc.y = cursor.y;
            sc.maxWidth = cursor.maxWidth;
            sc.scale = this.scale;
            List<GuiElement> e = this.components.stream().flatMap(c -> c.toElements(mdr, sc).stream()).collect(Collectors.toList());
            cursor.y = (int)((float)sc.y + this.scale * 10.0f);
            return e;
        }
    }
}

