/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.util;

import com.tom.cpl.math.Vec2i;
import com.tom.cpl.util.Image;
import com.tom.cpl.util.ImageIO;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class AWTImageIO
implements ImageIO.IImageIO {
    @Override
    public Image read(File f) throws IOException {
        return AWTImageIO.toImage(ImageIO.read(f));
    }

    @Override
    public Image read(InputStream f) throws IOException {
        return AWTImageIO.toImage(ImageIO.read(f));
    }

    @Override
    public void write(Image img, File f) throws IOException {
        ImageIO.write((RenderedImage)AWTImageIO.toBufferedImage(img), "PNG", f);
    }

    @Override
    public void write(Image img, OutputStream f) throws IOException {
        ImageIO.write((RenderedImage)AWTImageIO.toBufferedImage(img), "PNG", f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vec2i getSize(InputStream din) throws IOException {
        try (ImageInputStream in = ImageIO.createImageInputStream(din);){
            Iterator<ImageReader> readers = ImageIO.getImageReaders(in);
            if (readers.hasNext()) {
                ImageReader reader = readers.next();
                try {
                    reader.setInput(in);
                    int w = reader.getWidth(0);
                    int h = reader.getHeight(0);
                    Vec2i vec2i = new Vec2i(w, h);
                    reader.dispose();
                    return vec2i;
                }
                catch (Throwable throwable) {
                    reader.dispose();
                    throw throwable;
                }
            }
        }
        return new Vec2i();
    }

    public static BufferedImage toBufferedImage(Image i) {
        BufferedImage img = new BufferedImage(i.getWidth(), i.getHeight(), 2);
        int[] to = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        System.arraycopy(i.getData(), 0, to, 0, i.getData().length);
        return img;
    }

    public static Image toImage(BufferedImage bi) {
        Image i = new Image(bi.getWidth(), bi.getHeight());
        for (int y = 0; y < i.getHeight(); ++y) {
            for (int x = 0; x < i.getWidth(); ++x) {
                i.setRGB(x, y, bi.getRGB(x, y));
            }
        }
        return i;
    }
}

