/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.gui.elements;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.math.Box;
import java.util.ArrayList;
import java.util.List;

public class Panel
extends GuiElement {
    protected List<GuiElement> elements = new ArrayList<GuiElement>();
    protected int backgroundColor;

    public Panel(IGui gui) {
        super(gui);
    }

    public <T extends GuiElement> T addElement(T elem) {
        this.elements.add(elem);
        return elem;
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        this.gui.pushMatrix();
        this.gui.setPosOffset(this.getBounds());
        this.gui.setupCut();
        Box bounds = this.getBounds();
        if (this.backgroundColor != 0) {
            this.gui.drawBox(0, 0, bounds.w, bounds.h, this.backgroundColor);
        }
        for (GuiElement guiElement : this.elements) {
            if (!guiElement.isVisible()) continue;
            guiElement.draw(event.offset(bounds), partialTicks);
        }
        this.gui.popMatrix();
        this.gui.setupCut();
    }

    @Override
    public void mouseClick(MouseEvent event) {
        if (!this.elements.isEmpty()) {
            ArrayList<GuiElement> elements = new ArrayList<GuiElement>(this.elements);
            for (int i = elements.size() - 1; i >= 0; --i) {
                GuiElement guiElement = (GuiElement)elements.get(i);
                if (!guiElement.isVisible()) continue;
                guiElement.mouseClick(event.offset(this.getBounds()));
            }
        }
        if (event.isInBounds(this.getBounds()) && this.backgroundColor > 0) {
            event.consume();
        }
    }

    @Override
    public void keyPressed(KeyboardEvent event) {
        if (!this.elements.isEmpty()) {
            ArrayList<GuiElement> elements = new ArrayList<GuiElement>(this.elements);
            for (int i = elements.size() - 1; i >= 0; --i) {
                GuiElement guiElement = (GuiElement)elements.get(i);
                if (!guiElement.isVisible()) continue;
                guiElement.keyPressed(event);
            }
        }
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Override
    public void mouseDrag(MouseEvent event) {
        if (!this.elements.isEmpty()) {
            ArrayList<GuiElement> elements = new ArrayList<GuiElement>(this.elements);
            for (int i = elements.size() - 1; i >= 0; --i) {
                GuiElement guiElement = (GuiElement)elements.get(i);
                if (!guiElement.isVisible()) continue;
                guiElement.mouseDrag(event.offset(this.getBounds()));
            }
        }
        if (event.isInBounds(this.getBounds()) && this.backgroundColor > 0) {
            event.consume();
        }
    }

    @Override
    public void mouseRelease(MouseEvent event) {
        if (!this.elements.isEmpty()) {
            ArrayList<GuiElement> elements = new ArrayList<GuiElement>(this.elements);
            for (int i = elements.size() - 1; i >= 0; --i) {
                GuiElement guiElement = (GuiElement)elements.get(i);
                if (!guiElement.isVisible()) continue;
                guiElement.mouseRelease(event.offset(this.getBounds()));
            }
        }
        if (event.isInBounds(this.getBounds()) && this.backgroundColor > 0) {
            event.consume();
        }
    }

    @Override
    public void mouseWheel(MouseEvent event) {
        if (!this.elements.isEmpty()) {
            ArrayList<GuiElement> elements = new ArrayList<GuiElement>(this.elements);
            for (int i = elements.size() - 1; i >= 0; --i) {
                GuiElement guiElement = (GuiElement)elements.get(i);
                if (!guiElement.isVisible()) continue;
                guiElement.mouseWheel(event.offset(this.getBounds()));
            }
        }
        if (event.isInBounds(this.getBounds()) && this.backgroundColor > 0) {
            event.consume();
        }
    }

    public IGui getGui() {
        return this.gui;
    }

    public List<GuiElement> getElements() {
        return this.elements;
    }

    public boolean remove(GuiElement o) {
        return this.elements.remove(o);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (GuiElement guiElement : this.elements) {
            guiElement.setEnabled(enabled);
        }
    }
}

