/*
 * Decompiled with CFR 0.152.
 */
package nl.teamdiopside.seamless.util;

import java.io.IOException;
import java.util.List;
import nl.teamdiopside.seamless.annotation.mixin.ConditionalMixin;
import nl.teamdiopside.seamless.compat.Mods;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.Annotations;

public class ConditionalMixinManager {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Seamless/Mixin");

    public static boolean shouldApply(String className) {
        try {
            List annotationNodes = MixinService.getService().getBytecodeProvider().getClassNode((String)className).visibleAnnotations;
            if (annotationNodes == null) {
                return true;
            }
            boolean shouldApply = true;
            for (AnnotationNode node : annotationNodes) {
                if (!node.desc.equals(Type.getDescriptor(ConditionalMixin.class))) continue;
                List mods = Annotations.getValue((AnnotationNode)node, (String)"mods", (boolean)true, Mods.class);
                boolean applyIfPresent = (Boolean)Annotations.getValue((AnnotationNode)node, (String)"applyIfPresent", (Object)Boolean.TRUE);
                boolean anyModsLoaded = ConditionalMixinManager.anyModsLoaded(mods);
                shouldApply = anyModsLoaded == applyIfPresent;
                LOGGER.debug("Mod(s) {} {}loaded. {} {}", new Object[]{mods, anyModsLoaded ? "" : "not ", shouldApply ? "Applying" : "Skipping", className});
            }
            return shouldApply;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean anyModsLoaded(List<Mods> mods) {
        for (Mods mod : mods) {
            if (!mod.isLoaded) continue;
            return true;
        }
        return false;
    }
}

