/*
 * Decompiled with CFR 0.152.
 */
package nl.teamdiopside.seamless;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_4309;
import nl.teamdiopside.seamless.Seamless;

public class Reload {
    public static final List<OutlineRule> RULES = new ArrayList<OutlineRule>();

    public static void reload(class_3300 resourceManager) {
        Reload.apply(Reload.getJsons(resourceManager));
    }

    public static void apply(Map<class_2960, JsonElement> jsons) {
        Seamless.fastEnabled = (Boolean)Seamless.fastOption.method_41753();
        RULES.clear();
        ArrayList<OutlineRule> temp = new ArrayList<OutlineRule>();
        ArrayList<JsonFile> files = new ArrayList<JsonFile>();
        jsons.forEach((key, json) -> files.add(new JsonFile((class_2960)key, (JsonElement)json)));
        files.sort(Comparator.comparing(jsonFile -> jsonFile.key.toString()));
        for (JsonFile file : files) {
            class_2960 key2 = file.key();
            JsonElement json2 = file.json();
            if (!Seamless.modIds.contains(key2.method_12836())) continue;
            try {
                Set<String> blocks = Reload.getSet(json2, "blocks");
                HashMap<String, Set<String>> blockstates = Reload.getBlockStates(json2, "blockstates");
                Set<String> directions = Reload.getSet(json2, "directions");
                Set<String> connectingBlocks = Reload.getSet(json2, "connecting_blocks");
                HashMap<String, Set<String>> connectingBlockstates = Reload.getBlockStates(json2, "connecting_blockstates");
                temp.add(new OutlineRule(blocks, blockstates, directions, connectingBlocks, connectingBlockstates, key2));
                Seamless.LOGGER.info("Loaded Seamless outline rule " + String.valueOf(key2));
            }
            catch (Exception e) {
                Seamless.LOGGER.error("Failed to parse JSON for Seamless outline rule " + String.valueOf(key2) + ".json, Error: " + String.valueOf(e));
            }
        }
        RULES.addAll(temp);
    }

    public static Set<String> getSet(JsonElement json, String string) {
        HashSet<String> set = new HashSet<String>();
        json.getAsJsonObject().get(string).getAsJsonArray().forEach(element -> set.add(element.getAsString()));
        return set;
    }

    public static HashMap<String, Set<String>> getBlockStates(JsonElement json, String string) {
        HashMap<String, Set<String>> blockstates = new HashMap<String, Set<String>>();
        try {
            json.getAsJsonObject().get(string).getAsJsonObject().asMap().forEach((k, v) -> {
                HashSet states = new HashSet();
                v.getAsJsonArray().forEach(jsonElement -> states.add(jsonElement.getAsString()));
                blockstates.put((String)k, states);
            });
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return blockstates;
    }

    public static Map<class_2960, JsonElement> getJsons(class_3300 resourceManager) {
        String directory = "seamless_rules";
        Gson gson = new Gson();
        HashMap map = Maps.newHashMap();
        class_4309.method_51148((class_3300)resourceManager, (String)directory, (Gson)gson, (Map)map);
        return map;
    }

    public record JsonFile(class_2960 key, JsonElement json) {
    }

    public record OutlineRule(Set<String> blocks, HashMap<String, Set<String>> blockstates, Set<String> directions, Set<String> connectingBlocks, HashMap<String, Set<String>> connectingBlockstates, class_2960 location) {
    }
}

