/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.mixin.suggestions.arguments;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.types.templates.Tag;
import com.mt1006.nbt_ac.autocomplete.CustomTagParser;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestionManager;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestions;
import com.mt1006.nbt_ac.autocomplete.SuggestionList;
import com.mt1006.nbt_ac.autocomplete.suggestions.NbtSuggestion;
import com.mt1006.nbt_ac.utils.Utils;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2212;
import net.minecraft.class_2267;
import net.minecraft.class_2300;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={class_2212.class})
public abstract class NbtTagArgumentMixin
implements ArgumentType<Tag> {
    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        try {
            NbtSuggestion nbtSuggestion = this.getSuggestion(commandContext);
            if (nbtSuggestion == null) {
                return Suggestions.empty();
            }
            String tag = suggestionsBuilder.getRemaining();
            if (nbtSuggestion.subcompound == null) {
                NbtSuggestionManager.simpleSuggestion("", String.format("%s[%s]", nbtSuggestion.source.symbol, nbtSuggestion.type.getName()), suggestionsBuilder);
                return suggestionsBuilder.buildFuture();
            }
            return NbtSuggestionManager.loadFromSuggestion(nbtSuggestion, tag, suggestionsBuilder);
        }
        catch (Exception exception) {
            return Suggestions.empty();
        }
    }

    @Unique
    private NbtSuggestion getSuggestion(CommandContext<?> ctx) {
        String commandName = Utils.getCommandName(ctx);
        if (commandName.equals("data")) {
            return this.getSuggestionForDataCommand(ctx);
        }
        if (ctx.getChild() != null) {
            return this.getSuggestion(ctx.getChild());
        }
        return null;
    }

    @Unique
    private NbtSuggestion getSuggestionForDataCommand(CommandContext<?> ctx) {
        String root;
        String instruction = Utils.getNodeString(ctx, 1);
        if (!instruction.equals("modify")) {
            return null;
        }
        String type = Utils.getNodeString(ctx, 2);
        String path = Utils.getArgumentString(ctx, "targetPath");
        switch (type) {
            case "block": {
                class_2267 coords = (class_2267)ctx.getArgument("targetPos", class_2267.class);
                root = Utils.blockFromCoords(coords);
                break;
            }
            case "entity": {
                class_2300 entitySelector = (class_2300)ctx.getArgument("target", class_2300.class);
                root = Utils.entityFromEntitySelector(entitySelector);
                break;
            }
            default: {
                return null;
            }
        }
        if (root == null) {
            return null;
        }
        NbtSuggestions rootSuggestions = NbtSuggestionManager.get(root);
        if (rootSuggestions == null) {
            return null;
        }
        CustomTagParser pathParser = new CustomTagParser(path, CustomTagParser.Type.PATH);
        SuggestionList suggestionList = pathParser.prepareSuggestionList(rootSuggestions, root);
        pathParser.read(suggestionList, null, root);
        return pathParser.lastFoundSuggestion;
    }
}

