/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.symbolchat.gui.widget.symbolButton;

import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_7919;
import net.replaceitem.symbolchat.SymbolChat;
import net.replaceitem.symbolchat.Util;
import net.replaceitem.symbolchat.gui.widget.symbolButton.SymbolButtonWidget;
import org.jetbrains.annotations.Nullable;

public class PasteSymbolButtonWidget
extends SymbolButtonWidget {
    @Nullable
    protected final Context context;
    protected final String symbol;
    private boolean isFavorite;

    public PasteSymbolButtonWidget(int x, int y, @Nullable Context context, String symbol) {
        this(x, y, context, symbol, class_7919.method_47407((class_2561)class_2561.method_30163((String)Util.getCapitalizedSymbolName(symbol))));
    }

    public PasteSymbolButtonWidget(int x, int y, @Nullable Context context, String symbol, class_7919 tooltip) {
        super(x, y, symbol);
        this.symbol = symbol;
        this.context = context;
        this.method_47400(tooltip);
        this.method_47402(SymbolChat.config.getSymbolTooltipMode().getDelay());
        this.isFavorite = SymbolChat.symbolManager.isFavorite(symbol);
    }

    @Override
    protected void renderOverlay(class_332 drawContext) {
        super.renderOverlay(drawContext);
        if (this.isFavorite) {
            this.drawCorners(drawContext, SymbolChat.config.getFavoriteColor());
        }
    }

    @Override
    public boolean onClick(int button) {
        if (button == 0 && this.context != null) {
            this.context.onSymbolClicked(this.getSymbol());
            return true;
        }
        if (button == 1) {
            this.onRightClick();
            if (this.context != null) {
                this.context.refresh();
            }
        }
        return true;
    }

    protected void onRightClick() {
        if (this.symbol.codePoints().count() > 1L) {
            return;
        }
        boolean currentlyFavorite = SymbolChat.symbolManager.isFavorite(this.symbol);
        if (currentlyFavorite) {
            SymbolChat.config.removeFavorite(this.getSymbol());
        } else {
            SymbolChat.config.addFavorite(this.getSymbol());
        }
        this.isFavorite = !currentlyFavorite;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public static interface Context {
        public void onSymbolClicked(String var1);

        public void refresh();
    }
}

