/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.symbolchat.gui.widget;

import java.util.OptionalInt;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_7845;
import net.minecraft.class_8021;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntSpinnerWidget
extends class_7845 {
    private final int min;
    private final int max;
    private final class_342 textField;
    private final class_4185 decreaseButton;
    private final class_4185 increaseButton;
    @Nullable
    private Consumer<OptionalInt> changedListener;

    private IntSpinnerWidget(class_327 textRenderer, int value, int min, int max) {
        this.min = min;
        this.max = max;
        class_7845.class_7939 adder = this.method_47610(Integer.MAX_VALUE);
        this.decreaseButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)"<"), (class_4185.class_4241)this.createEvent(-1)).method_46437(12, 12).method_46431();
        this.increaseButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)">"), (class_4185.class_4241)this.createEvent(1)).method_46437(12, 12).method_46431();
        this.textField = new class_342(textRenderer, 0, 0, 20, 12, (class_2561)class_2561.method_43473());
        this.textField.method_1880(Math.max(String.valueOf(min).length(), String.valueOf(max).length()));
        this.textField.method_1863(string -> {
            OptionalInt val = this.getValue();
            this.decreaseButton.field_22763 = val.isEmpty() || val.getAsInt() != min;
            boolean bl = this.increaseButton.field_22763 = val.isEmpty() || val.getAsInt() != max;
            if (this.changedListener != null) {
                this.changedListener.accept(this.getValue());
            }
        });
        this.setValue(value);
        adder.method_47612((class_8021)this.decreaseButton);
        adder.method_47612((class_8021)this.textField);
        adder.method_47612((class_8021)this.increaseButton);
    }

    public void setChangeListener(@Nullable Consumer<OptionalInt> changedListener) {
        this.changedListener = changedListener;
    }

    public void setValue(int value) {
        this.textField.method_1852(String.valueOf(class_3532.method_15340((int)value, (int)this.min, (int)this.max)));
    }

    public void setValue(@NotNull String value) {
        this.textField.method_1852(value);
    }

    public OptionalInt getValue() {
        try {
            return OptionalInt.of(Integer.parseInt(this.textField.method_1882()));
        }
        catch (NumberFormatException e) {
            return OptionalInt.empty();
        }
    }

    private class_4185.class_4241 createEvent(int delta) {
        return button -> this.setValue(this.getValue().orElse(0) + delta);
    }

    public static Builder builder(@NotNull class_327 textRenderer) {
        return new Builder(textRenderer);
    }

    public static class Builder {
        @NotNull
        private final class_327 textRenderer;
        @Nullable
        private Consumer<OptionalInt> changedListener;
        private Integer value = 0;
        @Nullable
        private String stringValue = null;
        private int min = Integer.MIN_VALUE;
        private int max = Integer.MAX_VALUE;

        public Builder(@NotNull class_327 textRenderer) {
            this.textRenderer = textRenderer;
        }

        public Builder min(int min) {
            this.min = min;
            return this;
        }

        public Builder max(int max) {
            this.max = max;
            return this;
        }

        public Builder value(int value) {
            this.value = value;
            return this;
        }

        public Builder value(@Nullable String value) {
            this.stringValue = value;
            return this;
        }

        public Builder changedListener(@Nullable Consumer<OptionalInt> changedListener) {
            this.changedListener = changedListener;
            return this;
        }

        public IntSpinnerWidget build() {
            IntSpinnerWidget intSpinnerWidget = new IntSpinnerWidget(this.textRenderer, this.value, this.min, this.max);
            if (this.stringValue != null) {
                intSpinnerWidget.setValue(this.stringValue);
            } else {
                intSpinnerWidget.setValue(this.value);
            }
            intSpinnerWidget.setChangeListener(this.changedListener);
            return intSpinnerWidget;
        }
    }
}

