/*
 * Decompiled with CFR 0.152.
 */
package xyz.eclipseisoffline.uuidcommand.command;

import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2186;
import net.minecraft.class_2300;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_638;
import net.minecraft.class_640;
import net.minecraft.class_742;
import xyz.eclipseisoffline.uuidcommand.ClientWorldEntityCollector;
import xyz.eclipseisoffline.uuidcommand.UUIDHolder;
import xyz.eclipseisoffline.uuidcommand.mixin.EntitySelectorAccessor;

public class ClientEntitySelector
extends class_2300 {
    public ClientEntitySelector(class_2300 selector) {
        super(selector.method_9815(), selector.method_9819(), true, ((EntitySelectorAccessor)selector).getPredicates(), ((EntitySelectorAccessor)selector).getDistance(), ((EntitySelectorAccessor)selector).getPositionOffset(), ((EntitySelectorAccessor)selector).getBox(), ((EntitySelectorAccessor)selector).getSorter(), ((EntitySelectorAccessor)selector).getSenderOnly(), ((EntitySelectorAccessor)selector).getPlayerName(), ((EntitySelectorAccessor)selector).getUuid(), ((EntitySelectorAccessor)selector).getEntityFilter() == EntitySelectorAccessor.getPassthroughFilter() ? null : (class_1299)((EntitySelectorAccessor)selector).getEntityFilter(), ((EntitySelectorAccessor)selector).getUsesAt());
    }

    public UUIDHolder getClientEntity(FabricClientCommandSource source) throws CommandSyntaxException {
        List<UUIDHolder> list = this.getClientEntities(source);
        if (list.isEmpty()) {
            throw class_2186.field_9863.create();
        }
        if (list.size() > 1) {
            throw class_2186.field_9860.create();
        }
        return list.get(0);
    }

    public List<UUIDHolder> getClientEntities(FabricClientCommandSource source) throws CommandSyntaxException {
        ArrayList<UUIDHolder> entities = new ArrayList<UUIDHolder>(this.getUnfilteredClientEntities(source).stream().filter(entity -> entity.method_5864().method_45382(source.method_45549())).map(entity -> (UUIDHolder)entity).toList());
        if (entities.isEmpty()) {
            entities.addAll(this.getClientPlayerEntries(source).stream().map(player -> (UUIDHolder)player).toList());
        }
        return entities;
    }

    private List<class_640> getClientPlayerEntries(FabricClientCommandSource source) {
        class_640 player = null;
        assert (source.getClient().method_1562() != null);
        if (((EntitySelectorAccessor)((Object)this)).getPlayerName() != null) {
            player = source.getClient().method_1562().method_2874(((EntitySelectorAccessor)((Object)this)).getPlayerName());
        } else if (((EntitySelectorAccessor)((Object)this)).getUuid() != null) {
            player = source.getClient().method_1562().method_2871(((EntitySelectorAccessor)((Object)this)).getUuid());
        }
        if (player != null) {
            return Lists.newArrayList((Object[])new class_640[]{player});
        }
        return Collections.emptyList();
    }

    private List<? extends class_1297> getUnfilteredClientEntities(FabricClientCommandSource source) throws CommandSyntaxException {
        this.checkSourcePermission(source);
        if (((EntitySelectorAccessor)((Object)this)).getPlayerName() != null) {
            for (class_742 player : source.getWorld().method_18456()) {
                if (!player.method_7334().getName().equals(((EntitySelectorAccessor)((Object)this)).getPlayerName())) continue;
                return Lists.newArrayList((Object[])new class_742[]{player});
            }
            return Collections.emptyList();
        }
        if (((EntitySelectorAccessor)((Object)this)).getUuid() != null) {
            for (class_1297 entity : source.getWorld().method_18112()) {
                if (!entity.method_5667().equals(((EntitySelectorAccessor)((Object)this)).getUuid())) continue;
                return Lists.newArrayList((Object[])new class_1297[]{entity});
            }
            return Collections.emptyList();
        }
        class_243 vec3d = ((EntitySelectorAccessor)((Object)this)).getPositionOffset().apply(source.getPosition());
        class_238 box = ((EntitySelectorAccessor)((Object)this)).invokeGetOffsetBox(vec3d);
        if (((EntitySelectorAccessor)((Object)this)).getSenderOnly()) {
            Predicate<class_1297> predicate = ((EntitySelectorAccessor)((Object)this)).invokeGetPositionPredicate(vec3d, box, null);
            return source.getEntity() != null && predicate.test(source.getEntity()) ? List.of(source.getEntity()) : List.of();
        }
        Predicate<class_1297> predicate = ((EntitySelectorAccessor)((Object)this)).invokeGetPositionPredicate(vec3d, box, source.method_45549());
        ObjectArrayList list = new ObjectArrayList();
        this.appendEntitiesFromClientWorld((List<class_1297>)list, source.getWorld(), vec3d, predicate);
        return ((EntitySelectorAccessor)((Object)this)).invokeGetEntities(vec3d, list);
    }

    private void checkSourcePermission(FabricClientCommandSource source) throws CommandSyntaxException {
        if (((EntitySelectorAccessor)((Object)this)).getUsesAt() && !source.method_9259(0)) {
            throw class_2186.field_9862.create();
        }
    }

    private void appendEntitiesFromClientWorld(List<class_1297> entities, class_638 world, class_243 pos, Predicate<class_1297> predicate) {
        int i = ((EntitySelectorAccessor)((Object)this)).invokeGetAppendLimit();
        if (entities.size() >= i) {
            return;
        }
        if (((EntitySelectorAccessor)((Object)this)).getBox() != null) {
            world.method_47575(((EntitySelectorAccessor)((Object)this)).getEntityFilter(), ((EntitySelectorAccessor)((Object)this)).getBox().method_997(pos), predicate, entities, i);
        } else {
            ((ClientWorldEntityCollector)world).UUIDCommand$collectEntitiesByType(((EntitySelectorAccessor)((Object)this)).getEntityFilter(), predicate, entities, i);
        }
    }
}

