/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.peek.events;

import de.maxhenkel.peek.Peek;
import de.maxhenkel.peek.data.DataStore;
import de.maxhenkel.peek.tooltips.ContainerTooltip;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2315;
import net.minecraft.class_2336;
import net.minecraft.class_2371;
import net.minecraft.class_2377;
import net.minecraft.class_2480;
import net.minecraft.class_3708;
import net.minecraft.class_5632;
import net.minecraft.class_9288;
import net.minecraft.class_9334;

public class TooltipImageEvents {
    public static Optional<class_5632> getTooltipImage(class_1799 stack, class_2248 block) {
        if (block instanceof class_2480) {
            return TooltipImageEvents.getShulkerBoxTooltipImage(stack);
        }
        if (block instanceof class_2281) {
            return TooltipImageEvents.getChestTooltipImage(stack);
        }
        if (block instanceof class_3708) {
            return TooltipImageEvents.getBarrelTooltipImage(stack);
        }
        if (block instanceof class_2315) {
            return TooltipImageEvents.getDispenserTooltipImage(stack);
        }
        if (block instanceof class_2377) {
            return TooltipImageEvents.getHopperTooltipImage(stack);
        }
        if (block instanceof class_2336) {
            return TooltipImageEvents.getEnderChestTooltipImage();
        }
        return Optional.empty();
    }

    private static Optional<class_5632> getEnderChestTooltipImage() {
        if (!Peek.CONFIG.peekEnderChests.get().booleanValue()) {
            return Optional.empty();
        }
        if (DataStore.enderChestInventory == null) {
            return Optional.empty();
        }
        return Optional.of(new ContainerTooltip(9, 3, DataStore.enderChestInventory));
    }

    private static Optional<class_5632> getShulkerBoxTooltipImage(class_1799 stack) {
        if (!Peek.CONFIG.peekShulkerBoxes.get().booleanValue()) {
            return Optional.empty();
        }
        return TooltipImageEvents.sizedContainerTooltipImage(stack, 9, 3);
    }

    private static Optional<class_5632> getChestTooltipImage(class_1799 stack) {
        if (!Peek.CONFIG.peekChests.get().booleanValue()) {
            return Optional.empty();
        }
        return TooltipImageEvents.sizedContainerTooltipImage(stack, 9, 3);
    }

    private static Optional<class_5632> getBarrelTooltipImage(class_1799 stack) {
        if (!Peek.CONFIG.peekBarrels.get().booleanValue()) {
            return Optional.empty();
        }
        return TooltipImageEvents.sizedContainerTooltipImage(stack, 9, 3);
    }

    private static Optional<class_5632> getDispenserTooltipImage(class_1799 stack) {
        if (!Peek.CONFIG.peekDispensers.get().booleanValue()) {
            return Optional.empty();
        }
        return TooltipImageEvents.sizedContainerTooltipImage(stack, 3, 3);
    }

    private static Optional<class_5632> getHopperTooltipImage(class_1799 stack) {
        if (!Peek.CONFIG.peekHoppers.get().booleanValue()) {
            return Optional.empty();
        }
        return TooltipImageEvents.sizedContainerTooltipImage(stack, 5, 1);
    }

    private static Optional<class_5632> sizedContainerTooltipImage(class_1799 stack, int width, int height) {
        class_9288 contents = (class_9288)stack.method_57825(class_9334.field_49622, (Object)class_9288.field_49334);
        if (!Peek.CONFIG.showEmptyContainers.get().booleanValue() && contents.method_57489().allMatch(class_1799::method_7960)) {
            return Optional.empty();
        }
        class_2371 items = class_2371.method_10213((int)(width * height), (Object)class_1799.field_8037);
        contents.method_57492(items);
        return Optional.of(new ContainerTooltip(width, height, (class_2371<class_1799>)items));
    }
}

