/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.firstperson;

import dev.tr7zw.firstperson.FirstPersonModelCore;
import dev.tr7zw.firstperson.access.PlayerAccess;
import dev.tr7zw.firstperson.api.ActivationHandler;
import dev.tr7zw.firstperson.api.FirstPersonAPI;
import dev.tr7zw.firstperson.util.NMSHelper;
import dev.tr7zw.firstperson.versionless.FirstPersonBase;
import dev.tr7zw.firstperson.versionless.config.VanillaHands;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1695;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_5498;
import net.minecraft.class_742;

public class LogicHandler {
    private final class_310 client;
    private final FirstPersonModelCore fpm;
    private class_243 offset = class_243.field_1353;
    private Set<class_1792> autoVanillaHandItems = new HashSet<class_1792>();
    private Set<class_1792> autoDisableItems = new HashSet<class_1792>();
    private long timeout = 0L;

    void registerDefaultHandlers() {
        FirstPersonAPI.registerPlayerHandler(() -> {
            if (this.client.field_1724.method_6113() || this.client.field_1724.method_6123() || this.client.field_1724.method_6128() || this.client.field_1724.method_6024(1.0f) != 0.0f && !this.isCrawlingOrSwimming((class_1657)this.client.field_1724)) {
                this.timeout = System.currentTimeMillis() + 100L;
                return true;
            }
            if (System.currentTimeMillis() < this.timeout) {
                return true;
            }
            if (this.autoDisableItems.contains(this.client.field_1724.method_6047().method_7909()) || this.autoDisableItems.contains(this.client.field_1724.method_6079().method_7909())) {
                return true;
            }
            return this.client.field_1724.method_31550();
        });
    }

    public boolean shouldApplyThirdPerson(boolean thirdPerson) {
        if (!this.fpm.isEnabled() || thirdPerson) {
            return false;
        }
        for (ActivationHandler handler : FirstPersonAPI.getActivationHandlers()) {
            if (!handler.preventFirstperson()) continue;
            return false;
        }
        return true;
    }

    public void updatePositionOffset(class_1297 entity, float delta) {
        this.offset = class_243.field_1353;
        if (entity == this.client.method_1560() && this.client.field_1724.method_6113()) {
            return;
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        if (entity != this.client.field_1724 || this.client.field_1690.method_31044() != class_5498.field_26664 || !this.fpm.isRenderingPlayer()) {
            return;
        }
        class_742 player = (class_742)entity;
        double realYaw = class_3532.method_17821((float)delta, (float)player.field_6220, (float)player.field_6283);
        if (!player.method_7340() || this.client.method_1560() == player) {
            float bodyOffset;
            if (this.isCrawlingOrSwimming((class_1657)this.client.field_1724)) {
                player.field_6283 = player.field_6241;
                bodyOffset = player.field_6004 > 0.0f ? 0.6f : 0.5f;
            } else if (player.method_18276() || player.method_18376() == class_4050.field_18081) {
                bodyOffset = 0.27f + (float)this.fpm.getConfig().sneakXOffset / 100.0f;
            } else if (player.method_5765()) {
                if (player.method_5854() instanceof class_1690 || player.method_5854() instanceof class_1695) {
                    realYaw = class_3532.method_17821((float)delta, (float)player.field_6220, (float)player.field_6283);
                } else {
                    class_1297 class_12972 = player.method_5854();
                    if (class_12972 instanceof class_1309) {
                        class_1309 living = (class_1309)class_12972;
                        realYaw = LogicHandler.calculateBodyRot(class_3532.method_17821((float)delta, (float)living.field_6220, (float)living.field_6283), NMSHelper.getYRot((class_1297)player));
                    }
                }
                bodyOffset = 0.2f + (float)this.fpm.getConfig().sitXOffset / 100.0f;
            } else {
                bodyOffset = 0.25f + (float)this.fpm.getConfig().xOffset / 100.0f;
            }
            x += (double)bodyOffset * Math.sin(Math.toRadians(realYaw));
            z -= (double)bodyOffset * Math.cos(Math.toRadians(realYaw));
            if (this.isCrawlingOrSwimming((class_1657)this.client.field_1724)) {
                y = player.field_6004 > 0.0f && player.method_5869() ? (y += (double)0.6f * Math.sin(Math.toRadians(player.field_6004))) : (y += (double)0.01f * -Math.sin(Math.toRadians(player.field_6004)));
            }
        }
        this.offset = new class_243(x, y, z);
    }

    private static float calculateBodyRot(float entityBodyRot, float riderHeadRot) {
        float wrappedHeadRot = class_3532.method_15393((float)riderHeadRot);
        float rotDiff = class_3532.method_15393((float)(wrappedHeadRot - entityBodyRot));
        if (class_3532.method_15379((float)rotDiff) > 50.0f) {
            entityBodyRot = wrappedHeadRot - 50.0f * Math.signum(rotDiff);
        }
        entityBodyRot = class_3532.method_15393((float)entityBodyRot);
        return entityBodyRot;
    }

    public boolean isSwimming(class_1657 player) {
        return player.method_5681();
    }

    public boolean isCrawlingOrSwimming(class_1657 player) {
        return player.method_20232();
    }

    public boolean showVanillaHands() {
        return this.showVanillaHands((class_1309)this.client.field_1724);
    }

    public boolean showVanillaHands(class_1309 livingEntity) {
        if (livingEntity instanceof PlayerAccess) {
            PlayerAccess playerAccess = (PlayerAccess)livingEntity;
            return this.showVanillaHands(playerAccess.getInventory().method_7391(), (class_1799)playerAccess.getInventory().field_7544.get(0));
        }
        return false;
    }

    public boolean showVanillaHands(class_1799 mainhand, class_1799 offhand) {
        return this.fpm.getConfig().vanillaHandsMode == VanillaHands.ALL || this.fpm.getConfig().vanillaHandsMode == VanillaHands.ALL_DOUBLE || this.fpm.getConfig().vanillaHandsMode == VanillaHands.ITEMS && (!mainhand.method_7960() || !offhand.method_7960()) || this.autoVanillaHandItems.contains(mainhand.method_7909()) || this.autoVanillaHandItems.contains(offhand.method_7909()) || this.autoDisableItems.contains(mainhand.method_7909()) || this.autoDisableItems.contains(offhand.method_7909());
    }

    public boolean hideArmsAndItems() {
        return this.hideArmsAndItems((class_1309)this.client.field_1724);
    }

    public boolean hideArmsAndItems(class_1309 livingEntity) {
        if (livingEntity instanceof PlayerAccess) {
            PlayerAccess playerAccess = (PlayerAccess)livingEntity;
            return this.hideArmsAndItems(livingEntity, playerAccess.getInventory().method_7391(), (class_1799)playerAccess.getInventory().field_7544.get(0));
        }
        return false;
    }

    public boolean hideArmsAndItems(class_1309 livingEntity, class_1799 mainhand, class_1799 offhand) {
        class_1657 player;
        if (FirstPersonModelCore.instance.getConfig().vanillaHandsSkipSwimming && livingEntity instanceof class_1657 && this.isSwimming(player = (class_1657)livingEntity)) {
            return false;
        }
        if (this.lookingDown()) {
            return false;
        }
        return this.fpm.getConfig().vanillaHandsMode != VanillaHands.OFF || this.autoVanillaHandItems.contains(mainhand.method_7909()) || this.autoVanillaHandItems.contains(offhand.method_7909()) || this.autoDisableItems.contains(mainhand.method_7909()) || this.autoDisableItems.contains(offhand.method_7909());
    }

    public boolean dynamicHandsEnabled() {
        return this.dynamicHandsEnabled((class_1309)this.client.field_1724);
    }

    public boolean dynamicHandsEnabled(class_1309 livingEntity) {
        if (livingEntity instanceof PlayerAccess) {
            PlayerAccess playerAccess = (PlayerAccess)livingEntity;
            return this.dynamicHandsEnabled(livingEntity, playerAccess.getInventory().method_7391(), (class_1799)playerAccess.getInventory().field_7544.get(0));
        }
        return false;
    }

    public boolean dynamicHandsEnabled(class_1309 livingEntity, class_1799 mainhand, class_1799 offhand) {
        class_1657 player;
        if (FirstPersonModelCore.instance.getConfig().vanillaHandsSkipSwimming && livingEntity instanceof class_1657 && this.isSwimming(player = (class_1657)livingEntity)) {
            return false;
        }
        return this.fpm.getConfig().dynamicMode && this.fpm.getConfig().vanillaHandsMode != VanillaHands.OFF && !this.autoVanillaHandItems.contains(mainhand.method_7909()) && !this.autoVanillaHandItems.contains(offhand.method_7909()) && !this.autoDisableItems.contains(mainhand.method_7909()) && !this.autoDisableItems.contains(offhand.method_7909());
    }

    public boolean lookingDown() {
        return this.dynamicHandsEnabled() && NMSHelper.getXRot((class_1297)class_310.method_1551().field_1724) > 30.0f;
    }

    public void addAutoVanillaHandsItem(class_1792 item) {
        this.autoVanillaHandItems.add(item);
    }

    public void addAutoDisableItem(class_1792 item) {
        this.autoDisableItems.add(item);
    }

    public void reloadAutoVanillaHandsSettings() {
        class_1792 item;
        this.autoVanillaHandItems.clear();
        this.autoDisableItems.clear();
        class_1792 invalid = NMSHelper.getItem(NMSHelper.getResourceLocation("minecraft", "air"));
        for (String itemId : this.fpm.getConfig().autoVanillaHands) {
            try {
                item = NMSHelper.getItem(NMSHelper.getResourceLocation(itemId.split(":")[0], itemId.split(":")[1]));
                if (invalid == item) continue;
                this.addAutoVanillaHandsItem(item);
            }
            catch (Exception ex) {
                FirstPersonBase.LOGGER.info("Unknown item to add to the auto vanilla hold list: {}", (Object)itemId);
            }
        }
        FirstPersonBase.LOGGER.info("Loaded Vanilla Hands items: {}", this.autoVanillaHandItems);
        for (String itemId : this.fpm.getConfig().autoToggleModItems) {
            try {
                item = NMSHelper.getItem(NMSHelper.getResourceLocation(itemId.split(":")[0], itemId.split(":")[1]));
                if (invalid == item) continue;
                this.addAutoDisableItem(item);
            }
            catch (Exception ex) {
                FirstPersonBase.LOGGER.info("Unknown item to add to the auto disable list: {}", (Object)itemId);
            }
        }
        FirstPersonBase.LOGGER.info("Loaded Auto Disable items: {}", this.autoDisableItems);
    }

    @Generated
    public LogicHandler(class_310 client, FirstPersonModelCore fpm) {
        this.client = client;
        this.fpm = fpm;
    }

    @Generated
    public class_243 getOffset() {
        return this.offset;
    }
}

