//Settings//
#include "/lib/common.glsl"

#ifdef FSH

const float shadowDistanceRenderMul = 1.0;
const float wetnessHalflife = 128.0;
const int noiseTextureResolution = 512;

//Buffer Options//
/*
const int colortex0Format = R11F_G11F_B10F; //scene
const int colortex1Format = RGBA16; //translucent
const int colortex2Format = RGBA16; //temporal data
const int colortex3Format = RGBA16; //gbuffers data
const int colortex4Format = RGB8; //rsm gi
const int colortex5Format = RGBA16; //accumulated rsm
const int colortex6Format = R11F_G11F_B10F; //reflections
*/

const bool colortex0Clear = false;
const bool colortex3Clear = false;
const bool colortex4Clear = false;
const bool gaux1Clear = false;

//Varyings//
in vec2 texCoord;

//Uniforms//
uniform sampler2D shadowtex0;
uniform sampler2D colortex1;

#ifdef SHARPENING
uniform float viewWidth, viewHeight;
#endif

#ifdef CHROMATIC_ABERRATION
uniform float aspectRatio;
#endif

//Includes//
#if defined SHARPENING && MC_VERSION >= 11200
#include "/lib/post/sharpenFilter.glsl"
#endif

#ifdef CHROMATIC_ABERRATION
#include "/lib/post/chromaticAberration.glsl"
#endif

//Program//
void main() {
	vec3 color = texture2D(colortex1, texCoord).rgb;

	#if defined SHARPENING && MC_VERSION >= 11200
	sharpenFilter(color, texCoord);
	#endif

	#ifdef CHROMATIC_ABERRATION
	getChromaticAberration(color, texCoord);
	#endif

	if (texCoord.x < 0.0) {
		color = texture2D(shadowtex0, texCoord).rgb;
	}

	gl_FragColor.rgb = color;
}

#endif

/////////////////////////////////////////////////////////////////////////////////////

#ifdef VSH

//Varyings//
out vec2 texCoord;

//Program//
void main() {
	//Coord
	texCoord = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;
	
	//Position
	gl_Position = ftransform();
}


#endif