//Settings//
#include "/lib/common.glsl"

#ifdef FSH

//Varyings//
in vec2 texCoord;

//Uniforms//
#if defined LPV_FOG || defined VL
uniform float viewHeight, viewWidth;

uniform sampler2D colortex1;
#endif

uniform sampler2D colortex0;

const vec2 vlOffsets[4] = vec2[4](
	vec2( 1.5,  0.5),
	vec2(-0.5,  1.5),
	vec2(-1.5, -0.5),
	vec2( 0.5, -1.5)
);

void main() {
	vec3 color = texture2D(colortex0, texCoord).rgb;

	#if defined LPV_FOG || defined VL
	vec3 volume = texture2D(colortex1, texCoord + vlOffsets[0] / vec2(viewWidth, viewHeight)).rgb;
		 volume+= texture2D(colortex1, texCoord + vlOffsets[1] / vec2(viewWidth, viewHeight)).rgb;
		 volume+= texture2D(colortex1, texCoord + vlOffsets[2] / vec2(viewWidth, viewHeight)).rgb;
		 volume+= texture2D(colortex1, texCoord + vlOffsets[3] / vec2(viewWidth, viewHeight)).rgb;
	volume *= 0.25;
	volume = pow4(volume) * 128.0;

	color += volume;
	#endif

	/* DRAWBUFFERS:0 */
	gl_FragData[0].rgb = pow(color.rgb, vec3(2.2));
}

#endif

/////////////////////////////////////////////////////////////////////////////////////

#ifdef VSH

//Varyings//
out vec2 texCoord;

void main() {
	//Coords
	texCoord = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;

	//Position
	gl_Position = ftransform();
}

#endif