//Settings//
#include "/lib/common.glsl"

#ifdef FSH

//Varyings//
in vec2 texCoord;

#ifdef VL
in vec3 sunVec, upVec;
#endif

//Uniforms//
#if defined LPV_FOG || defined VL
uniform int isEyeInWater;
uniform int frameCounter;

uniform float viewWidth, viewHeight;
uniform float far, near;
uniform float frameTimeCounter;
uniform float timeBrightness, wetness;
uniform float blindFactor;

#ifdef VL
uniform float timeAngle, shadowFade;

uniform vec3 skyColor;
#endif

#if MC_VERSION >= 11900
uniform float darknessFactor;
#endif

uniform ivec2 eyeBrightnessSmooth;

uniform vec3 cameraPosition;
#endif

uniform sampler2D colortex0;

#if defined LPV_FOG || defined VL
uniform sampler2D noisetex;
uniform sampler2D colortex1;
uniform sampler2D depthtex0, depthtex1;

#ifdef LPV_FOG
uniform sampler3D floodfillSampler;
#endif

#ifdef VL
#ifdef SHADOW_COLOR
uniform sampler2D shadowtex1;
#endif

uniform sampler2D shadowcolor0, shadowcolor1;
uniform sampler2D shadowtex0;

uniform mat4 shadowModelView, shadowProjection;
#endif

uniform mat4 gbufferProjection, gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
#endif

//Common Variables//
#if defined LPV_FOG || defined VL
float eBS = eyeBrightnessSmooth.y / 240.0;
float caveFactor = mix(clamp((cameraPosition.y - 56.0) / 16.0, float(sign(isEyeInWater)), 1.0), 1.0, eBS);

#ifdef VL
float sunVisibility = clamp(dot(sunVec, upVec) + 0.025, 0.0, 0.1) * 10.0;
#endif
#endif

//Includes//
#if defined LPV_FOG || defined VL
#include "/lib/atmosphere/spaceConversion.glsl"
#include "/lib/util/ToView.glsl"
#include "/lib/util/ToWorld.glsl"

#ifdef LPV_FOG
#include "/lib/util/bayerDithering.glsl"
#include "/lib/atmosphere/lpvFog.glsl"
#endif

#ifdef VL
#include "/lib/util/ToShadow.glsl"
#include "/lib/color/lightColor.glsl"
#include "/lib/atmosphere/volumetricLight.glsl"
#endif
#endif

//Program//
void main() {
	vec3 color = texture2D(colortex0, texCoord).rgb;
	vec4 vl = vec4(0.0);

	#if defined LPV_FOG || defined VL
	vec3 translucent = texture2D(colortex1, texCoord).rgb;

	#ifdef LPV_FOG
	float bayerDither = Bayer8(gl_FragCoord.xy);

	#ifdef TAA
	bayerDither = fract(bayerDither + frameTimeCounter * 16.0);
	#endif

	computeLPVFog(vl.rgb, translucent, bayerDither);
	#endif

	#ifdef VL
	float blueNoiseDither = texture2D(noisetex, gl_FragCoord.xy / 512.0).b;

	#ifdef TAA
	blueNoiseDither = fract(blueNoiseDither + 1.61803398875 * mod(float(frameCounter), 3600.0));
	#endif

	computeVL(vl.rgb, translucent, blueNoiseDither);
	#endif

	vl.rgb = pow(vl.rgb / 128.0, vec3(0.25));
	#endif

	/* DRAWBUFFERS:01 */
	gl_FragData[0].rgb = color;
	gl_FragData[1].rgb = vl.rgb;
}

#endif

/////////////////////////////////////////////////////////////////////////////////////

#ifdef VSH

//Varyings//
out vec2 texCoord;

#ifdef VL
out vec3 sunVec, upVec;
#endif

//Uniforms//
#ifdef VL
uniform float timeAngle;

uniform mat4 gbufferModelView;
#endif

//Program//
void main() {
	//Coord
	texCoord = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;
	
	//Sun Vector
	#ifdef VL
	sunVec = getSunVector(gbufferModelView, timeAngle);
	upVec = normalize(gbufferModelView[1].xyz);
	#endif

	//Position
	gl_Position = ftransform();
}

#endif