const vec3[] blocklightColorArray = vec3[](
	//Air
	vec3(0.0),
	//Non-emissive blocks
	vec3(0.0),
	//Glow Lichen, Sea Pickle
	vec3(0.50, 0.80, 0.60),
	//Brewing Stand
	vec3(1.00, 0.75, 0.10) * 1.5,
	//Torch, Lantern, Campfire, Fire, Cave Berries
	vec3(1.00, 0.55, 0.10) * 2.5,
	//Soul Torch, Soul Lantern, Soul Campfire, Soul Fire
	vec3(0.10, 0.50, 1.00) * 2.5,
	//End Rod
	vec3(1.00, 0.50, 0.90) * 2.0,
	//Sea Lantern
	vec3(0.70, 0.90, 1.00) * 2.0,
	//Glowstone
	vec3(1.00, 0.65, 0.25) * 2.5,
	//Shroomlight, Redstone Lamp
	vec3(1.00, 0.30, 0.10) * 3.0,
	//Respawn Anchor
	vec3(0.60, 0.05, 1.00) * 1.5,
	//Lava
	vec3(1.00, 0.15, 0.05) * 2.5,
	//Cave Berries
	vec3(1.00, 0.30, 0.05) * 2.0,
	//Amethyst
	vec3(0.85, 0.30, 1.00),
	//Red Concrete
	vec3(1.00, 0.00, 0.00) * 2.0,
	//Orange Concrete
	vec3(1.00, 0.20, 0.00) * 2.0,
	//Yellow Concrete
	vec3(1.00, 0.60, 0.10) * 2.0,
	//Lime Concrete
	vec3(0.00, 1.00, 0.10) * 2.0,
	//Light Blue Concrete
	vec3(0.00, 0.40, 1.00) * 2.0,
	//Magenta Concrete
	vec3(1.00, 0.00, 1.00) * 1.5,
	//Magma Block
	vec3(1.00, 0.20, 0.05) * 1.5,
    //Emerald Ore
    normalize(vec3(0.05, 1.00, 0.15)) * 0.75,
    //Diamond Ore
    normalize(vec3(0.10, 0.40, 1.00)) * 0.75,
    //Copper Ore
    normalize(vec3(0.50, 0.80, 0.30)) * 0.75,
    //Lapis Ore
    normalize(vec3(0.00, 0.10, 1.20)) * 0.75,
    //Gold Ore
    normalize(vec3(1.00, 0.75, 0.10)) * 0.75,
    //Iron Ore
    normalize(vec3(0.70, 0.40, 0.30)) * 0.75,
    //Redstone Ore
    normalize(vec3(1.00, 0.05, 0.00)) * 0.75,
    //Lit Redstone Ore
    vec3(1.00, 0.05, 0.00) * 2.0,
    //Powered Rails
    vec3(1.00, 0.05, 0.00),
    //Nether Portal
    vec3(0.60, 0.05, 1.00) * 2.0,
    //Orchre Froglight
    normalize(vec3(1.00, 0.55, 0.25)) * 2.0,
    //Verdant Froglight
    normalize(vec3(0.0, 1.00, 0.05)) * 2.0,
    //Pearlescent Froglight
    normalize(vec3(1.00, 0.20, 0.90)) * 2.0,
    //Red flowers
    normalize(vec3(1.00, 0.10, 0.05)) * 0.5,
    //Pink flowers
    normalize(vec3(0.80, 0.20, 0.60)) * 0.5,
    //Yellow flowers
    normalize(vec3(0.80, 0.50, 0.05)) * 0.5,
    //Blue flowers
    normalize(vec3(0.00, 0.15, 1.00)) * 0.5,
    //White flowers
    normalize(vec3(0.80, 0.80, 0.80)) * 0.5,
    //Orange flowers
    normalize(vec3(1.00, 0.70, 0.05)) * 0.5,
	//Jack-O-Lantern
	vec3(1.00, 0.55, 0.20) * 1.5,
    //Enchanting table
    vec3(0.15, 0.50, 1.00) * 2.0,
	//Red Candle
	normalize(vec3(1.0, 0.1, 0.1)),
	//Orange Candle
	normalize(vec3(1.0, 0.5, 0.1)),
	//Yellow Candle
	normalize(vec3(1.0, 1.0, 0.1)),
	//Brown Candle
	normalize(vec3(0.7, 0.7, 0.0)),
	//Green Candle
	normalize(vec3(0.1, 1.0, 0.1)),
	//Lime Candle
	normalize(vec3(0.0, 1.0, 0.1)),
	//Blue Candle
	normalize(vec3(0.1, 0.1, 1.0)),
	//Light blue Candle
	normalize(vec3(0.5, 0.5, 1.0)),
	//Cyan Candle
	normalize(vec3(0.1, 1.0, 1.0)),
	//Purple Candle
	normalize(vec3(0.7, 0.1, 1.0)),
	//Magenta Candle
	normalize(vec3(1.0, 0.1, 1.0)),
	//Pink Candle
	normalize(vec3(1.0, 0.5, 1.0)),
	//Black Candle
	normalize(vec3(0.3, 0.3, 0.3)),
	//White Candle
	normalize(vec3(0.9, 0.9, 0.9)),
	//Gray Candle
	normalize(vec3(0.5, 0.5, 0.5)),
	//Light gray Candle
	normalize(vec3(0.7, 0.7, 0.7)),
    //Candle
    normalize(vec3(0.6, 0.5, 0.4)),
    //Beacon
    vec3(0.6, 0.7, 1.0) * 2.0,
	//Buffer
	vec3(0.0)
);

vec3 getBlocklightColor(in uint voxel) {
	int material = int(voxel);
	if (material < 59) {
		return blocklightColorArray[min(voxel, blocklightColorArray.length() - 1u)];
	}

	return vec3(0.0);
}

const vec3[] blocklightTintArray = vec3[](
	//Red
	vec3(1.0, 0.1, 0.1),
	//Orange
	vec3(1.0, 0.5, 0.1),
	//Yellow
	vec3(1.0, 1.0, 0.1),
	//Brown
	vec3(0.7, 0.7, 0.0),
	//Green
	vec3(0.1, 1.0, 0.1),
	//Lime
	vec3(0.1, 1.0, 0.5),
	//Blue
	vec3(0.1, 0.1, 1.0),
	//Light blue
	vec3(0.5, 0.5, 1.0),
	//Cyan
	vec3(0.1, 1.0, 1.0),
	//Purple
	vec3(0.7, 0.1, 1.0),
	//Magenta
	vec3(1.0, 0.1, 1.0),
	//Pink
	vec3(1.0, 0.5, 1.0),
	//Black
	vec3(0.1, 0.1, 0.1),
	//White
	vec3(0.9, 0.9, 0.9),
	//Gray
	vec3(0.3, 0.3, 0.3),
	//Light gray
	vec3(0.7, 0.7, 0.7),
	//Buffer
	vec3(0.0)
);