void generateIPBR(inout vec4 albedo, in vec3 worldPos, in vec3 viewPos, in vec2 lightmap, inout float emission, inout float smoothness, inout float subsurface) {
    int material = max(mat - 10000, 0);
    float lAlbedo = clamp(length(albedo.rgb), 0.0, 1.0);

    #include "/lib/pbr/blocks/amethyst.glsl"
    #include "/lib/pbr/blocks/beacon.glsl"
    #include "/lib/pbr/blocks/brewing_stand.glsl"
    #include "/lib/pbr/blocks/candles_corals.glsl"
    #include "/lib/pbr/blocks/cave_berries.glsl"
    #include "/lib/pbr/blocks/concrete.glsl"
    #include "/lib/pbr/blocks/enchanting_table.glsl"
    #include "/lib/pbr/blocks/flowers.glsl"
    #include "/lib/pbr/blocks/froglights.glsl"
    #include "/lib/pbr/blocks/full_emitters.glsl"
    #include "/lib/pbr/blocks/glow_lichen_sea_pickle.glsl"
    #include "/lib/pbr/blocks/jack_o_lantern.glsl"
    #include "/lib/pbr/blocks/magma_block.glsl"
    #include "/lib/pbr/blocks/ores.glsl"
    #include "/lib/pbr/blocks/powered_rail.glsl"
    #include "/lib/pbr/blocks/redstone_ore.glsl"
    #include "/lib/pbr/blocks/soul_emitters.glsl"
    #include "/lib/pbr/blocks/torch_lantern.glsl"

    emission = clamp(emission * EMISSION_STRENGTH, 0.0, 8.0);
}