void getNormalFog(inout vec3 color, vec3 viewPos, in vec3 worldPos, in vec3 atmosphereColor) {
	float lViewPos = length(viewPos);
	float lWorldPos = length(worldPos.xz);

	//Overworld Fog
	#ifdef OVERWORLD
	float fogAltitude = clamp(pow16((worldPos.y + cameraPosition.y + 1000.0 - FOG_HEIGHT) * 0.001), 0.0, 1.0);
	float fogDistance = min(192.0 / far, 1.0) * (100.0 / FOG_DISTANCE);
	float fogDensity = FOG_DENSITY * mix(1.0, 0.5, mefade) * (1.0 - fogAltitude * 0.9) * (1.0 + wetness * 0.5);

    float fog = 1.0 - exp(-pow(lViewPos * (0.001 - 0.0005 * wetness), 2.0 - wetness) * lViewPos * fogDistance);
          fog *= fogDensity;
		  fog = clamp(fog, 0.0, 1.0);

    vec3 fogCol = atmosphereColor;
         fogCol = mix(fogCol, atmosphereColor, min(1.0 - sunVisibility + wetness, 1.0));

    //Underground Fog
	fogCol = mix(caveMinLightCol * fog, fogCol, clamp(caveFactor, 0.0, 1.0));

	//Distant Fade
	#ifdef DISTANT_FADE
	if (isEyeInWater < 0.5) {
		#if MC_VERSION >= 11800
		const float fogOffset = 0.0;
		#else
		const float fogOffset = 12.0;
		#endif

		#if DISTANT_FADE_STYLE == 0
		float fogFactor = lWorldPos;
		#else
		float fogFactor = lViewPos;
		#endif

		float vanillaFog = 1.0 - (far - (fogFactor + fogOffset)) * 8.0 / (4.0 * far);
			  vanillaFog = clamp(pow3(vanillaFog), 0.0, 1.0) * clamp(caveFactor, 0.0, 1.0);
	
		if (vanillaFog > 0.0){
			fogCol *= fog;
			fog = mix(fog, 1.0, vanillaFog);

			if (fog > 0.0) fogCol = mix(fogCol, atmosphereColor, vanillaFog) / fog;
		}
	}
	#endif
	#endif

	//Nether Fog
	#ifdef NETHER
	float fog = lViewPos * 0.005;

	#ifdef DISTANT_FADE
	fog += 2.0 * pow4(lWorldPos / far);
	#endif

	fog = 1.0 - exp(-fog);

	vec3 fogCol = netherColSqrt.rgb * 0.5;
	#endif

	//We don't want fog in the End because it looks cringe
	#ifndef END
	color = mix(color, fogCol, fog);
	#endif
}

//Fog that appears when you have a darkness effect
#if MC_VERSION >= 11900
void getDarknessFog(inout vec3 color, vec3 viewPos) {
	float fog = length(viewPos) * (darknessFactor * 0.025);
		  fog = (1.0 - exp(-1.0 * fog)) * darknessFactor;

	color = mix(color, vec3(0.0), fog);
}
#endif

//Fog that appears when you have a blindness effect
void getBlindFog(inout vec3 color, vec3 viewPos) {
	float fog = length(viewPos) * (blindFactor * 0.1);
		  fog = (1.0 - exp(-4.0 * pow3(fog))) * blindFactor;

	color = mix(color, vec3(0.0), fog);
}

//Powder Snow / Lava Fog
vec3 densefogCol[2] = vec3[2](
	vec3(1.0, 0.18, 0.02),
	vec3(0.05, 0.07, 0.12)
);

void getDenseFog(inout vec3 color, vec3 viewPos) {
	float fog = length(viewPos) * 0.1;
		  fog = 1.0 - exp(-2.0 * pow2(fog));

	color = mix(color, densefogCol[isEyeInWater - 2], fog);
}

void Fog(inout vec3 color, in vec3 viewPos, in vec3 worldPos, in vec3 atmosphereColor) {
	if (isEyeInWater < 1) getNormalFog(color, viewPos, worldPos, atmosphereColor);

}