/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.entity.item;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.ArrayList;
import me.jellysquid.mods.lithium.common.entity.item.ElementCategorizingList;
import me.jellysquid.mods.lithium.common.entity.item.ItemStackSubscriber;
import me.jellysquid.mods.lithium.common.hopper.NotifyingItemStack;
import me.jellysquid.mods.lithium.mixin.util.accessors.ItemStackAccessor;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_7927;

public class ItemEntityCategorizingList
extends ElementCategorizingList<class_1542, class_1792> {
    public static final int DOWNGRADE_THRESHOLD = 10;
    public static final int UPGRADE_THRESHOLD = 20;
    private final Reference2ReferenceOpenHashMap<class_1542, ItemStackSubscriber> subscribers = new Reference2ReferenceOpenHashMap();

    public static ItemEntityCategorizingList wrapDelegate(ArrayList<class_1542> delegate) {
        ItemEntityCategorizingList itemEntities = new ItemEntityCategorizingList(delegate);
        itemEntities.initialize();
        return itemEntities;
    }

    private ItemEntityCategorizingList(ArrayList<class_1542> delegate) {
        super(delegate);
    }

    @Override
    class_1792 getCategory(class_1542 element) {
        return ((ItemStackAccessor)element.method_6983()).lithium$getItem();
    }

    @Override
    class_1792 getCategory(class_1799 itemStack) {
        return ((ItemStackAccessor)itemStack).lithium$getItem();
    }

    @Override
    boolean areSubcategoriesAlwaysEmpty(class_1792 item) {
        return item.method_7882() == 1;
    }

    @Override
    boolean isSubCategoryA(class_1542 element) {
        class_1799 stack = element.method_6983();
        return ItemEntityCategorizingList.isSubCategoryA(stack);
    }

    private static boolean isSubCategoryA(class_1799 stack) {
        int count = stack.method_7947();
        int maxCount = ((ItemStackAccessor)stack).lithium$getItem().method_7882();
        return ItemEntityCategorizingList.isSubCategoryA(count, maxCount);
    }

    private static boolean isSubCategoryA(int count, int maxCount) {
        return count < maxCount;
    }

    @Override
    boolean isSubCategoryB(class_1542 element) {
        class_1799 stack = element.method_6983();
        return ItemEntityCategorizingList.isSubCategoryB(stack);
    }

    private static boolean isSubCategoryB(class_1799 stack) {
        int count = stack.method_7947();
        int maxCount = ((ItemStackAccessor)stack).lithium$getItem().method_7882();
        return ItemEntityCategorizingList.isSubCategoryB(count, maxCount);
    }

    private static boolean isSubCategoryB(int count, int maxCount) {
        return count * 2 <= maxCount;
    }

    public class_7927.class_7928 consumeForEntityStacking(class_1542 searchingEntity, class_7927<class_1542> itemEntityConsumer) {
        int maxCount;
        class_1792 item = this.getCategory(searchingEntity);
        class_1799 stack = searchingEntity.method_6983();
        int count = stack.method_7947();
        if (count * 2 >= (maxCount = item.method_7882())) {
            return this.consumeCategoryB(itemEntityConsumer, item);
        }
        return this.consumeCategoryA(itemEntityConsumer, item);
    }

    @Override
    void onElementSubcategorized(final class_1542 element, int index) {
        ItemStackSubscriber subscriber = new ItemStackSubscriber(){

            @Override
            public void lithium$notifyBeforeCountChange(class_1799 itemStack, int index, int newCount) {
                ItemEntityCategorizingList.this.notifyBeforeCountChange(element, index, newCount);
            }

            @Override
            public void lithium$notifyAfterItemEntityStackSwap(int index, class_1542 itemEntity, class_1799 oldStack) {
                ItemEntityCategorizingList.this.notifyAfterStackSwap(index, itemEntity, oldStack);
            }
        };
        this.subscribers.put((Object)element, (Object)subscriber);
        ((NotifyingItemStack)element.method_6983()).lithium$subscribeWithIndex(subscriber, index);
    }

    private void notifyBeforeCountChange(class_1542 element, int index, int newCount) {
        class_1792 item = this.getCategory(element);
        int maxCount = item.method_7882();
        boolean categoryA = ItemEntityCategorizingList.isSubCategoryA(newCount, maxCount);
        boolean oldCategoryA = this.isSubCategoryA(element);
        boolean categoryB = ItemEntityCategorizingList.isSubCategoryB(newCount, maxCount);
        boolean oldCategoryB = this.isSubCategoryB(element);
        this.updateSubcategoryAssignment(item, index, categoryA, oldCategoryA, categoryB, oldCategoryB);
    }

    private void updateSubcategoryAssignment(class_1792 category, int index, boolean categoryA, boolean oldCategoryA, boolean categoryB, boolean oldCategoryB) {
        if (categoryA == oldCategoryA && categoryB == oldCategoryB) {
            return;
        }
        this.removeFromSubCategories(category, index, oldCategoryA && !categoryA, oldCategoryB && !categoryB, false);
        this.addToSubCategories(category, index, categoryA && !oldCategoryA, categoryB && !oldCategoryB, false);
    }

    private void notifyAfterStackSwap(int index, class_1542 element, class_1799 oldStack) {
        class_1799 stack = element.method_6983();
        if (stack == oldStack) {
            return;
        }
        ItemStackSubscriber subscriber = (ItemStackSubscriber)this.subscribers.get((Object)element);
        if (subscriber != null) {
            ((NotifyingItemStack)oldStack).lithium$unsubscribe(subscriber);
            ((NotifyingItemStack)element.method_6983()).lithium$subscribeWithIndex(subscriber, index);
        }
        class_1792 previousCategory = this.getCategory(oldStack);
        class_1792 category = this.getCategory(element);
        boolean subCategoryA = this.isSubCategoryA(element);
        boolean subCategoryB = this.isSubCategoryB(element);
        boolean prevSubCategoryA = ItemEntityCategorizingList.isSubCategoryA(oldStack);
        boolean prevSubCategoryB = ItemEntityCategorizingList.isSubCategoryB(oldStack);
        this.updateCategoryAndSubcategories(category, previousCategory, index, subCategoryA, prevSubCategoryA, subCategoryB, prevSubCategoryB);
    }

    @Override
    void onElementUnSubcategorized(class_1542 element) {
        ItemStackSubscriber subscriber = (ItemStackSubscriber)this.subscribers.remove((Object)element);
        ((NotifyingItemStack)element.method_6983()).lithium$unsubscribe(subscriber);
    }

    @Override
    void onCollectionReset() {
        this.onAllElementsUnSubcategorized();
    }

    @Override
    class_1542 castOrNull(Object element) {
        return element instanceof class_1542 ? (class_1542)element : null;
    }

    private void onAllElementsUnSubcategorized() {
        for (Reference2ReferenceMap.Entry entry : this.subscribers.reference2ReferenceEntrySet()) {
            class_1542 itemEntity = (class_1542)entry.getKey();
            ItemStackSubscriber subscriber = (ItemStackSubscriber)entry.getValue();
            ((NotifyingItemStack)itemEntity.method_6983()).lithium$unsubscribe(subscriber);
        }
    }
}

