/*
 * Decompiled with CFR 0.152.
 */
package barker.justin.wss;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.ModInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"wider-stats-screen");
    public static final Path configPath = FileSystems.getDefault().getPath("config", "wider-stats-screen.txt");
    public static List<String> configLines;
    public static double scale;
    public static int defaultCategory;
    public static boolean injectClick;

    public void onInitialize() {
        Main.loadConfig();
    }

    public static boolean loadConfig() {
        boolean scaleSet = false;
        boolean defaultCategorySet = false;
        try {
            configLines = Files.readAllLines(configPath);
        }
        catch (IOException e) {
            LOGGER.info("[WSS] Config file not found, attempting to create one...");
            Main.createConfigFile();
            return false;
        }
        for (String str : configLines) {
            if (str.isBlank() || str.trim().charAt(0) == '#') continue;
            try {
                String key = str.split(":")[0].trim();
                String value = str.split(":")[1].trim();
                switch (key) {
                    case "scale": {
                        scale = Double.parseDouble(value);
                        scaleSet = true;
                        break;
                    }
                    case "defaultCategory": {
                        defaultCategory = Integer.parseInt(value);
                        if (defaultCategory > 5 || defaultCategory < -1) {
                            Main.warnInvalid(key, value);
                            defaultCategory = 0;
                            break;
                        }
                        defaultCategorySet = true;
                        break;
                    }
                    default: {
                        LOGGER.warn("[WSS] Unknown config option: " + key);
                        break;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.warn("[WSS] Failed to load config line \"" + str + "\" due to: " + e.getMessage());
            }
        }
        if (!scaleSet || !defaultCategorySet) {
            Main.createConfigFile();
        }
        LOGGER.info("[WSS] Config loaded.");
        return true;
    }

    public static void warnInvalid(String key, String value) {
        LOGGER.warn("[WSS] invalid value " + value + " for setting: " + key);
    }

    private static boolean createConfigFile() {
        configLines = new ArrayList<String>();
        configLines.add("# Set the horizontal spacing of the items screen.");
        configLines.add("# 1 is vanilla, and the suggested range is 1.5 to 2.5.");
        configLines.add("scale: " + scale);
        configLines.add("");
        configLines.add("# Set the default category to sort by.");
        configLines.add("# 0: times mined, 1: times broken, 2: times crafted");
        configLines.add("# 3: times used, 4: times picked up, 5: times dropped");
        configLines.add("# Set to -1 to disable this behavior.");
        configLines.add("defaultCategory: " + defaultCategory);
        try {
            Files.deleteIfExists(configPath);
            Files.createFile(configPath, new FileAttribute[0]);
            for (String str : configLines) {
                Files.writeString(configPath, (CharSequence)(str + System.lineSeparator()), StandardOpenOption.APPEND);
            }
            LOGGER.info("[WSS] Config created.");
            return true;
        }
        catch (IOException e) {
            LOGGER.error("[WSS] Failed to create config file: " + e.getMessage());
            return false;
        }
    }

    static {
        scale = 1.75;
        defaultCategory = 0;
        injectClick = false;
    }
}

