/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.symbolchat.resource;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.replaceitem.symbolchat.Util;
import net.replaceitem.symbolchat.resource.FontProcessor;

public class MappedFontProcessor
extends FontProcessor {
    public MappedFontProcessor(class_2960 id, Map<String, String> map, int order, boolean reverseDirection) {
        super(id, (String key) -> map.getOrDefault(key, (String)key), order, reverseDirection);
    }

    public static MappedFontProcessor read(class_2960 id, JsonObject object, int order, boolean reverseDirection) throws JsonParseException {
        JsonObject mappings = class_3518.method_15296((JsonObject)object, (String)"mappings");
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry stringJsonElementEntry : mappings.entrySet()) {
            String key = (String)stringJsonElementEntry.getKey();
            JsonElement value = (JsonElement)stringJsonElementEntry.getValue();
            MappedFontProcessor.readMapping(key, value, map);
        }
        return new MappedFontProcessor(id, map, order, reverseDirection);
    }

    private static void readMapping(String key, JsonElement value, Map<String, String> map) throws JsonParseException {
        try {
            if (key.codePoints().count() == 1L) {
                map.put(key, MappedFontProcessor.readStringOrCodepoint(value));
                return;
            }
            CodepointIterator lRange = MappedFontProcessor.readRange(key);
            CodepointIterator rRange = MappedFontProcessor.readRange(value);
            if (lRange.isOpenEnded() && rRange.isOpenEnded()) {
                throw new JsonSyntaxException("Left and right side of mapping can't both be open ended");
            }
            if (!lRange.isOpenEnded() && !rRange.isOpenEnded() && lRange.size() != rRange.size()) {
                throw new JsonSyntaxException("Mismatched lengths: " + lRange.size() + " and " + rRange.size());
            }
            while (lRange.hasNext() && rRange.hasNext()) {
                map.put((String)lRange.next(), (String)rRange.next());
            }
        }
        catch (Exception e) {
            throw new JsonSyntaxException("Error parsing mapping with key '" + key + "'", (Throwable)e);
        }
    }

    private static CodepointIterator readRange(JsonElement value) {
        JsonPrimitive primitive;
        if (value instanceof JsonPrimitive && (primitive = (JsonPrimitive)value).isString()) {
            return MappedFontProcessor.readRange(primitive.getAsString());
        }
        if (value instanceof JsonArray) {
            JsonArray array = (JsonArray)value;
            return new CodepointIterator.Sequence(array.asList().stream().map(MappedFontProcessor::readStringOrCodepoint).toList());
        }
        throw new JsonSyntaxException("Expected string or array as mapping");
    }

    private static CodepointIterator readRange(String key) {
        if (key.contains("..")) {
            String[] split = key.split("\\.\\.");
            if (split.length == 1) {
                String from = split[0];
                if (from.codePoints().count() != 1L) {
                    throw new JsonSyntaxException("Only one codepoint before '..' allowed");
                }
                return new CodepointIterator.Range(from.codePoints().findFirst().orElseThrow());
            }
            if (split.length == 2) {
                String from = split[0];
                String to = split[1];
                if (from.codePoints().count() != 1L || to.codePoints().count() != 1L) {
                    throw new JsonSyntaxException("Only one codepoint before and after '..' allowed");
                }
                return new CodepointIterator.Range(from.codePoints().findFirst().orElseThrow(), to.codePoints().findFirst().orElseThrow());
            }
            throw new JsonSyntaxException("Expected only one occurence of '..' in mapping range");
        }
        return new CodepointIterator.Sequence(key.codePoints().mapToObj(Util::stringFromCodePoint).toList());
    }

    private static String readStringOrCodepoint(JsonElement element) {
        if (element instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)element;
            if (primitive.isNumber()) {
                return Util.stringFromCodePoint(primitive.getAsNumber().intValue());
            }
            return primitive.getAsString();
        }
        throw new JsonSyntaxException("Not a string or codepoint number: " + element.toString());
    }

    static abstract class CodepointIterator
    implements Iterator<String> {
        CodepointIterator() {
        }

        public abstract boolean isOpenEnded();

        public boolean requiresNext() {
            return !this.isOpenEnded() && this.hasNext();
        }

        public abstract int size();

        static class Sequence
        extends CodepointIterator {
            List<String> sequence;
            int index = 0;

            public Sequence(List<String> sequence) {
                this.sequence = sequence;
            }

            @Override
            public boolean isOpenEnded() {
                return false;
            }

            @Override
            public int size() {
                return this.sequence.size();
            }

            @Override
            public boolean hasNext() {
                return this.index < this.sequence.size();
            }

            @Override
            public String next() {
                return this.sequence.get(this.index++);
            }
        }

        static class Range
        extends CodepointIterator {
            int start;
            int end;
            int nextCodepoint;
            public static final int OPEN_ENDED = Integer.MIN_VALUE;

            public Range(int start, int end) {
                if (start > end && end != Integer.MIN_VALUE) {
                    throw new IllegalArgumentException("Second codepoint is lower than first");
                }
                this.start = start;
                this.end = end;
                this.nextCodepoint = start;
            }

            public Range(int start) {
                this(start, Integer.MIN_VALUE);
            }

            @Override
            public boolean isOpenEnded() {
                return this.end == Integer.MIN_VALUE;
            }

            @Override
            public int size() {
                if (this.isOpenEnded()) {
                    return -1;
                }
                return this.end - this.start + 1;
            }

            @Override
            public boolean hasNext() {
                return this.isOpenEnded() || this.nextCodepoint <= this.end;
            }

            @Override
            public String next() {
                return Util.stringFromCodePoint(this.nextCodepoint++);
            }
        }
    }
}

