/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.symbolchat.gui.widget;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_7528;
import net.replaceitem.symbolchat.SearchUtil;
import net.replaceitem.symbolchat.SymbolChat;
import net.replaceitem.symbolchat.gui.SymbolSelectionPanel;
import net.replaceitem.symbolchat.gui.container.ContainerWidgetImpl;
import net.replaceitem.symbolchat.gui.container.GridLayoutContainer;
import net.replaceitem.symbolchat.gui.container.ScrollableContainer;
import net.replaceitem.symbolchat.gui.widget.SymbolSearchBar;
import net.replaceitem.symbolchat.gui.widget.symbolButton.PasteSymbolButtonWidget;
import net.replaceitem.symbolchat.resource.SymbolTab;
import org.jetbrains.annotations.Nullable;

public class SymbolTabWidget
extends ContainerWidgetImpl
implements PasteSymbolButtonWidget.Context {
    private static final int SEARCH_BAR_HEIGHT = 10;
    public static final class_2561 NO_RESULTS = class_2561.method_43471((String)"symbolchat.no_search_results");
    public static final class_2561 NO_FAVORITE_SYMBOLS = class_2561.method_43471((String)"symbolchat.no_favorite_symbols");
    public static final class_2561 NO_CLOTHCONFIG = class_2561.method_43471((String)"symbolchat.no_clothconfig");
    private final SymbolSelectionPanel symbolSelectionPanel;
    @Nullable
    private class_2561 emptyText;
    protected final SymbolTab tab;
    @Nullable
    private SymbolSearchBar searchBar;
    protected final class_7528 scrollableWidget;
    protected final GridLayoutContainer symbolContainer;

    public SymbolTabWidget(int x, int y, int width, int height, SymbolTab symbolTab, SymbolSelectionPanel symbolSelectionPanel, int panelColumns) {
        super(x, y, width, height);
        this.tab = symbolTab;
        this.symbolSelectionPanel = symbolSelectionPanel;
        int columns = this.tab.getType().getColumns(panelColumns);
        this.symbolContainer = new GridLayoutContainer(0, 0, 0, 0, columns);
        this.symbolContainer.setSpacing(1);
        int offset = this.tab.hasSearchBar() ? 12 : 0;
        this.scrollableWidget = new ScrollableContainer(this.method_46426(), this.method_46427() + offset, this.method_25368(), this.method_25364() - offset, (class_339)this.symbolContainer);
        this.addChildren((class_364)this.scrollableWidget);
        if (this.tab.hasSearchBar()) {
            this.searchBar = new SymbolSearchBar(this.method_46426() + 2, this.method_46427() + 1, this.method_25368() - 4, 10);
            this.searchBar.method_1863(s -> this.refresh());
            this.addChildren((class_364)this.searchBar);
        }
        this.refresh();
    }

    @Override
    public void onSymbolClicked(String symbol) {
        this.symbolSelectionPanel.getSymbolInsertable().insertSymbol(symbol);
    }

    @Override
    public void refresh() {
        this.symbolContainer.clearElements();
        this.addSymbols();
        this.symbolContainer.refreshPositions();
    }

    protected void addSymbols() {
        Stream<String> stream = this.tab.streamSymbols();
        if (this.searchBar != null) {
            stream = SearchUtil.performSearch(stream, this.searchBar.method_1882());
        }
        List<PasteSymbolButtonWidget> buttons = stream.map(this::createButton).toList();
        buttons.forEach(this.symbolContainer::addChildren);
        this.emptyText = this.getEmptyText(buttons.isEmpty());
    }

    private class_2561 getEmptyText(boolean noSymbols) {
        if (!noSymbols) {
            return null;
        }
        if (SymbolChat.symbolManager.isOnlyFavorites(this.tab)) {
            return SymbolChat.clothConfigEnabled ? NO_FAVORITE_SYMBOLS : NO_CLOTHCONFIG;
        }
        return NO_RESULTS;
    }

    protected PasteSymbolButtonWidget createButton(String symbol) {
        SymbolTab.Type type = this.tab.getType();
        PasteSymbolButtonWidget pasteSymbolButtonWidget = new PasteSymbolButtonWidget(this.method_46426(), this.method_46427(), this, symbol);
        if (type.hasFullWidthButtons()) {
            pasteSymbolButtonWidget.method_25358(this.method_25368() - 2);
        }
        if (!type.hasTooltip()) {
            pasteSymbolButtonWidget.method_47400(null);
        }
        return pasteSymbolButtonWidget;
    }

    @Override
    public void method_48579(class_332 drawContext, int mouseX, int mouseY, float delta) {
        super.method_48579(drawContext, mouseX, mouseY, delta);
        if (this.emptyText != null) {
            class_327 textRenderer = class_310.method_1551().field_1772;
            List orderedTexts = textRenderer.method_1728((class_5348)this.emptyText, this.field_22758 - 4);
            drawContext.method_51448().method_22903();
            drawContext.method_51448().method_46416(0.0f, 0.0f, 200.0f);
            int centerX = this.method_46426() + this.method_25368() / 2;
            int n = this.method_46427() + this.method_25364() / 2;
            int n2 = orderedTexts.size();
            Objects.requireNonNull(textRenderer);
            int startY = n - n2 * 9 / 2;
            for (int i = 0; i < orderedTexts.size(); ++i) {
                class_5481 orderedText = (class_5481)orderedTexts.get(i);
                Objects.requireNonNull(textRenderer);
                int dy = startY + i * 9;
                drawContext.method_51430(textRenderer, orderedText, centerX - textRenderer.method_30880(orderedText) / 2, dy, 0x66FFFFFF, false);
            }
            drawContext.method_51448().method_22909();
        }
    }
}

